/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassProxy;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOModelElement;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionResolver;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.server.IPackageManager;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRevisionManager;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.db.IClassMapping;
import org.eclipse.emf.cdo.server.db.IDBStoreReader;
import org.eclipse.emf.cdo.server.db.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.CDODBSchema;
import org.eclipse.emf.cdo.server.internal.db.ClassServerInfo;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.DBStoreAccessor;
import org.eclipse.emf.cdo.server.internal.db.DBStoreChunkReader;
import org.eclipse.emf.cdo.server.internal.db.FeatureServerInfo;
import org.eclipse.emf.cdo.server.internal.db.PackageServerInfo;
import org.eclipse.emf.cdo.server.internal.db.ServerInfo;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.spi.common.InternalCDOClass;
import org.eclipse.emf.cdo.spi.common.InternalCDOPackage;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBRowHandler;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBStoreReader
extends DBStoreAccessor
implements IDBStoreReader {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DBStoreReader.class);

    public DBStoreReader(DBStore store, ISession session) throws DBException {
        super(store, session);
    }

    protected DBStoreReader(DBStore store, IView view) throws DBException {
        super(store, view);
    }

    public DBStoreChunkReader createChunkReader(CDORevision revision, CDOFeature feature) {
        return new DBStoreChunkReader(this, revision, feature);
    }

    public Collection<CDOPackageInfo> readPackageInfos() {
        final ArrayList<CDOPackageInfo> result = new ArrayList<CDOPackageInfo>(0);
        IDBRowHandler rowHandler = new IDBRowHandler(){

            public boolean handle(int row, Object ... values) {
                String packageURI = (String)values[0];
                boolean dynamic = DBStoreReader.this.getBoolean(values[1]);
                long lowerBound = (Long)values[2];
                long upperBound = (Long)values[3];
                CDOIDMetaRange metaIDRange = lowerBound == 0L ? null : CDOIDUtil.createMetaRange((CDOID)CDOIDUtil.createMeta((long)lowerBound), (int)((int)(upperBound - lowerBound) + 1));
                String parentURI = (String)values[4];
                result.add(new CDOPackageInfo(packageURI, dynamic, metaIDRange, parentURI));
                return true;
            }
        };
        DBUtil.select((Connection)this.getConnection(), (IDBRowHandler)rowHandler, (IDBField[])new IDBField[]{CDODBSchema.PACKAGES_URI, CDODBSchema.PACKAGES_DYNAMIC, CDODBSchema.PACKAGES_RANGE_LB, CDODBSchema.PACKAGES_RANGE_UB, CDODBSchema.PACKAGES_PARENT});
        return result;
    }

    public void readPackage(CDOPackage cdoPackage) {
        String where = String.valueOf(CDODBSchema.PACKAGES_URI.getName()) + " = '" + cdoPackage.getPackageURI() + "'";
        Object[] values = DBUtil.select((Connection)this.getConnection(), (String)where, (IDBField[])new IDBField[]{CDODBSchema.PACKAGES_ID, CDODBSchema.PACKAGES_NAME, CDODBSchema.PACKAGES_ECORE});
        PackageServerInfo.setDBID(cdoPackage, (Integer)values[0]);
        ((InternalCDOPackage)cdoPackage).setName((String)values[1]);
        ((InternalCDOPackage)cdoPackage).setEcore((String)values[2]);
        this.readClasses(cdoPackage);
        this.mapPackages(cdoPackage);
    }

    protected void readClasses(final CDOPackage cdoPackage) {
        IDBRowHandler rowHandler = new IDBRowHandler(){

            public boolean handle(int row, Object ... values) {
                int classID = (Integer)values[0];
                int classifierID = (Integer)values[1];
                String name = (String)values[2];
                boolean isAbstract = DBStoreReader.this.getBoolean(values[3]);
                CDOClass cdoClass = CDOModelUtil.createClass((CDOPackage)cdoPackage, (int)classifierID, (String)name, (boolean)isAbstract);
                ClassServerInfo.setDBID(cdoClass, classID);
                ((InternalCDOPackage)cdoPackage).addClass(cdoClass);
                DBStoreReader.this.readSuperTypes(cdoClass, classID);
                DBStoreReader.this.readFeatures(cdoClass, classID);
                return true;
            }
        };
        String where = String.valueOf(CDODBSchema.CLASSES_PACKAGE.getName()) + "=" + ServerInfo.getDBID((CDOModelElement)cdoPackage);
        DBUtil.select((Connection)this.getConnection(), (IDBRowHandler)rowHandler, (String)where, (IDBField[])new IDBField[]{CDODBSchema.CLASSES_ID, CDODBSchema.CLASSES_CLASSIFIER, CDODBSchema.CLASSES_NAME, CDODBSchema.CLASSES_ABSTRACT});
    }

    protected void readSuperTypes(final CDOClass cdoClass, int classID) {
        IDBRowHandler rowHandler = new IDBRowHandler(){

            public boolean handle(int row, Object ... values) {
                String packageURI = (String)values[0];
                int classifierID = (Integer)values[1];
                ((InternalCDOClass)cdoClass).addSuperType(CDOModelUtil.createClassRef((String)packageURI, (int)classifierID));
                return true;
            }
        };
        String where = String.valueOf(CDODBSchema.SUPERTYPES_TYPE.getName()) + "=" + classID;
        DBUtil.select((Connection)this.getConnection(), (IDBRowHandler)rowHandler, (String)where, (IDBField[])new IDBField[]{CDODBSchema.SUPERTYPES_SUPERTYPE_PACKAGE, CDODBSchema.SUPERTYPES_SUPERTYPE_CLASSIFIER});
    }

    protected void readFeatures(final CDOClass cdoClass, int classID) {
        IDBRowHandler rowHandler = new IDBRowHandler(){

            public boolean handle(int row, Object ... values) {
                CDOFeature feature;
                int featureID = (Integer)values[1];
                String name = (String)values[2];
                CDOType type = CDOModelUtil.getType((int)((Integer)values[3]));
                boolean many = DBStoreReader.this.getBoolean(values[6]);
                if (type == CDOType.OBJECT) {
                    String packageURI = (String)values[4];
                    int classifierID = (Integer)values[5];
                    boolean containment = DBStoreReader.this.getBoolean(values[7]);
                    CDOClassRef classRef = CDOModelUtil.createClassRef((String)packageURI, (int)classifierID);
                    CDOClassProxy referenceType = new CDOClassProxy(classRef, cdoClass.getPackageManager());
                    feature = CDOModelUtil.createReference((CDOClass)cdoClass, (int)featureID, (String)name, (CDOClassProxy)referenceType, (boolean)many, (boolean)containment);
                } else {
                    feature = CDOModelUtil.createAttribute((CDOClass)cdoClass, (int)featureID, (String)name, (CDOType)type, (boolean)many);
                }
                FeatureServerInfo.setDBID(feature, (Integer)values[0]);
                ((InternalCDOClass)cdoClass).addFeature(feature);
                return true;
            }
        };
        String where = String.valueOf(CDODBSchema.FEATURES_CLASS.getName()) + "=" + classID;
        DBUtil.select((Connection)this.getConnection(), (IDBRowHandler)rowHandler, (String)where, (IDBField[])new IDBField[]{CDODBSchema.FEATURES_ID, CDODBSchema.FEATURES_FEATURE, CDODBSchema.FEATURES_NAME, CDODBSchema.FEATURES_TYPE, CDODBSchema.FEATURES_REFERENCE_PACKAGE, CDODBSchema.FEATURES_REFERENCE_CLASSIFIER, CDODBSchema.FEATURES_MANY, CDODBSchema.FEATURES_CONTAINMENT});
    }

    public String readPackageURI(int packageID) {
        String where = String.valueOf(CDODBSchema.PACKAGES_ID.getName()) + "=" + packageID;
        Object[] uri = DBUtil.select((Connection)this.getConnection(), (String)where, (IDBField[])new IDBField[]{CDODBSchema.PACKAGES_URI});
        return (String)uri[0];
    }

    public CloseableIterator<CDOID> readObjectIDs(boolean withTypes) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Selecting object IDs");
        }
        return this.getStore().getMappingStrategy().readObjectIDs(this, withTypes);
    }

    public CDOClassRef readObjectType(CDOID id) {
        if (TRACER.isEnabled()) {
            TRACER.format("Selecting object type: {0}", new Object[]{id});
        }
        return this.getStore().getMappingStrategy().readObjectType(this, id);
    }

    @Override
    public CDOClassRef readClassRef(int classID) {
        String where = String.valueOf(CDODBSchema.CLASSES_ID.getName()) + "=" + classID;
        Object[] res = DBUtil.select((Connection)this.getConnection(), (String)where, (IDBField[])new IDBField[]{CDODBSchema.CLASSES_CLASSIFIER, CDODBSchema.CLASSES_PACKAGE});
        int classifierID = (Integer)res[0];
        String packageURI = this.readPackageURI((Integer)res[1]);
        return CDOModelUtil.createClassRef((String)packageURI, (int)classifierID);
    }

    public CDORevision readRevision(CDOID id, int referenceChunk) {
        if (TRACER.isEnabled()) {
            TRACER.format("Selecting revision: {0}", new Object[]{id});
        }
        IRevisionManager revisionManager = this.getStore().getRepository().getRevisionManager();
        CDOClass cdoClass = this.getObjectType(id);
        InternalCDORevision revision = (InternalCDORevision)CDORevisionUtil.create((CDORevisionResolver)revisionManager, (CDOClass)cdoClass, (CDOID)id);
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        IClassMapping mapping = mappingStrategy.getClassMapping(cdoClass);
        mapping.readRevision(this, (CDORevision)revision, referenceChunk);
        return revision;
    }

    public CDORevision readRevisionByTime(CDOID id, int referenceChunk, long timeStamp) {
        if (TRACER.isEnabled()) {
            TRACER.format("Selecting revision: {0}, timestamp={1,date} {1,time}", new Object[]{id, timeStamp});
        }
        IRevisionManager revisionManager = this.getStore().getRepository().getRevisionManager();
        CDOClass cdoClass = this.getObjectType(id);
        InternalCDORevision revision = (InternalCDORevision)CDORevisionUtil.create((CDORevisionResolver)revisionManager, (CDOClass)cdoClass, (CDOID)id);
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        IClassMapping mapping = mappingStrategy.getClassMapping(cdoClass);
        mapping.readRevisionByTime(this, (CDORevision)revision, timeStamp, referenceChunk);
        return revision;
    }

    public CDORevision readRevisionByVersion(CDOID id, int referenceChunk, int version) {
        if (TRACER.isEnabled()) {
            TRACER.format("Selecting revision: {0}, version={1}", new Object[]{id, version});
        }
        IRevisionManager revisionManager = this.getStore().getRepository().getRevisionManager();
        CDOClass cdoClass = this.getObjectType(id);
        InternalCDORevision revision = (InternalCDORevision)CDORevisionUtil.create((CDORevisionResolver)revisionManager, (CDOClass)cdoClass, (CDOID)id);
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        IClassMapping mapping = mappingStrategy.getClassMapping(cdoClass);
        mapping.readRevisionByVersion(this, (CDORevision)revision, version, referenceChunk);
        return revision;
    }

    public CDOID readResourceID(String path) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        return mappingStrategy.readResourceID(this, path);
    }

    public String readResourcePath(CDOID id) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        return mappingStrategy.readResourcePath(this, id);
    }

    protected CDOClass getObjectType(CDOID id) {
        IRepository repository = this.getStore().getRepository();
        IPackageManager packageManager = repository.getPackageManager();
        CDOClassRef type = this.readObjectType(id);
        return type.resolve((CDOPackageManager)packageManager);
    }
}

