/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.ide.undo.MoveResourcesOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.actions.LTKLauncher;

public class RenameResourceAction
extends WorkspaceAction {
    private static final String WORKBENCH_PLUGIN_ID = "org.eclipse.ui.workbench";
    private TreeEditor treeEditor;
    private Tree navigatorTree;
    private Text textEditor;
    private Composite textEditorParent;
    private TextActionHandler textActionHandler;
    private IResource inlinedResource;
    private boolean saving = false;
    public static final String ID = "org.eclipse.ui.RenameResourceAction";
    private IPath newPath;
    private String[] modelProviderIds;
    private static final String CHECK_RENAME_TITLE = IDEWorkbenchMessages.RenameResourceAction_checkTitle;
    private static final String CHECK_RENAME_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_readOnlyCheck;
    private static String RESOURCE_EXISTS_TITLE = IDEWorkbenchMessages.RenameResourceAction_resourceExists;
    private static String RESOURCE_EXISTS_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_overwriteQuestion;
    private static String PROJECT_EXISTS_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_overwriteProjectQuestion;
    private static String PROJECT_EXISTS_TITLE = IDEWorkbenchMessages.RenameResourceAction_projectExists;

    @Deprecated
    public RenameResourceAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.RenameResourceAction_text);
        this.initAction();
    }

    public RenameResourceAction(IShellProvider provider) {
        super(provider, IDEWorkbenchMessages.RenameResourceAction_text);
        this.initAction();
    }

    private void initAction() {
        this.setToolTipText(IDEWorkbenchMessages.RenameResourceAction_toolTip);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.rename_resource_action_context");
    }

    @Deprecated
    public RenameResourceAction(Shell shell, Tree tree) {
        this(shell);
        this.navigatorTree = tree;
        this.treeEditor = new TreeEditor(tree);
    }

    public RenameResourceAction(IShellProvider provider, Tree tree) {
        this(provider);
        this.navigatorTree = tree;
        this.treeEditor = new TreeEditor(tree);
    }

    private boolean checkOverwrite(Shell shell, IResource destination) {
        boolean[] result = new boolean[1];
        Runnable query = () -> {
            String pathName = destination.getFullPath().makeRelative().toString();
            String message = RESOURCE_EXISTS_MESSAGE;
            String title = RESOURCE_EXISTS_TITLE;
            if (destination.getType() == 4) {
                message = PROJECT_EXISTS_MESSAGE;
                title = PROJECT_EXISTS_TITLE;
            }
            blArray[0] = MessageDialog.openQuestion((Shell)shell, (String)title, (String)MessageFormat.format(message, pathName));
        };
        shell.getDisplay().syncExec(query);
        return result[0];
    }

    private boolean checkReadOnlyAndNull(IResource currentResource) {
        if (currentResource == null) {
            return false;
        }
        ResourceAttributes attributes = currentResource.getResourceAttributes();
        if (attributes != null && attributes.isReadOnly()) {
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)CHECK_RENAME_TITLE, (String)MessageFormat.format(CHECK_RENAME_MESSAGE, currentResource.getName()));
        }
        return true;
    }

    Composite createParent() {
        Tree tree = this.getTree();
        Composite result = new Composite((Composite)tree, 0);
        TreeItem[] selectedItems = tree.getSelection();
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.setEditor((Control)result, selectedItems[0]);
        return result;
    }

    private static int getCellEditorInset(Control c) {
        return 1;
    }

    private void createTextEditor(final IResource resource) {
        this.textEditorParent = this.createParent();
        this.textEditorParent.setVisible(false);
        int inset = RenameResourceAction.getCellEditorInset((Control)this.textEditorParent);
        if (inset > 0) {
            this.textEditorParent.addListener(9, e -> {
                Point textSize = this.textEditor.getSize();
                Point parentSize = this.textEditorParent.getSize();
                e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
            });
        }
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditor.setFont(this.navigatorTree.getFont());
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addListener(24, e -> {
            Point textSize = this.textEditor.computeSize(-1, -1);
            textSize.x += textSize.y;
            Point parentSize = this.textEditorParent.getSize();
            this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
            this.textEditorParent.redraw();
        });
        this.textEditor.addListener(31, event -> {
            switch (event.detail) {
                case 2: {
                    this.disposeTextWidget();
                    event.doit = true;
                    event.detail = 0;
                    break;
                }
                case 4: {
                    this.saveChangesAndDispose(resource);
                    event.doit = true;
                    event.detail = 0;
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                RenameResourceAction.this.saveChangesAndDispose(resource);
            }
        });
        if (this.textActionHandler != null) {
            this.textActionHandler.addText(this.textEditor);
        }
    }

    private void disposeTextWidget() {
        if (this.textActionHandler != null) {
            this.textActionHandler.removeText(this.textEditor);
        }
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            this.treeEditor.setEditor(null, null);
        }
    }

    @Override
    protected List<? extends IResource> getActionResources() {
        if (this.inlinedResource == null) {
            return super.getActionResources();
        }
        ArrayList<IResource> actionResources = new ArrayList<IResource>();
        actionResources.add(this.inlinedResource);
        return actionResources;
    }

    @Override
    protected String getOperationMessage() {
        return IDEWorkbenchMessages.RenameResourceAction_progress;
    }

    @Override
    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.RenameResourceAction_problemMessage;
    }

    @Override
    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.RenameResourceAction_problemTitle;
    }

    private Tree getTree() {
        return this.navigatorTree;
    }

    protected String queryNewResourceName(IResource resource) {
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IPath prefix = resource.getFullPath().removeLastSegments(1);
        IInputValidator validator = string -> {
            if (resource.getName().equals(string)) {
                return IDEWorkbenchMessages.RenameResourceAction_nameMustBeDifferent;
            }
            IStatus status = workspace.validateName(string, resource.getType());
            if (!status.isOK()) {
                return status.getMessage();
            }
            if (workspace.getRoot().exists(prefix.append(string))) {
                return IDEWorkbenchMessages.RenameResourceAction_nameExists;
            }
            return null;
        };
        InputDialog dialog = new InputDialog(this.getShell(), IDEWorkbenchMessages.RenameResourceAction_inputDialogTitle, IDEWorkbenchMessages.RenameResourceAction_inputDialogMessage, resource.getName(), validator);
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            return dialog.getValue();
        }
        return null;
    }

    private void queryNewResourceNameInline(IResource resource) {
        if (this.textEditorParent == null) {
            this.createTextEditor(resource);
        }
        this.textEditor.setText(resource.getName());
        this.textEditorParent.setVisible(true);
        Point textSize = this.textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.textEditorParent.getSize();
        int inset = RenameResourceAction.getCellEditorInset((Control)this.textEditorParent);
        this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
        this.textEditorParent.redraw();
        int startOfFileExtension = resource.getName().lastIndexOf(46);
        if (startOfFileExtension == -1) {
            this.textEditor.selectAll();
        } else {
            this.textEditor.setSelection(0, startOfFileExtension);
        }
        this.textEditor.setFocus();
    }

    @Override
    public void run() {
        IResource currentResource = this.getCurrentResource();
        if (currentResource == null || !currentResource.exists()) {
            return;
        }
        String defaultValue = "";
        IPreferencesService preferences = Platform.getPreferencesService();
        String renameMode = preferences.getString(WORKBENCH_PLUGIN_ID, "RESOURCE_RENAME_MODE", defaultValue, null);
        boolean dialogMode = "dialog".equals(renameMode);
        if (LTKLauncher.isCompositeRename(this.getStructuredSelection()) || this.navigatorTree == null || dialogMode) {
            if (!LTKLauncher.openRenameWizard(this.getStructuredSelection())) {
                if (!this.checkReadOnlyAndNull(currentResource)) {
                    return;
                }
                String newName = this.queryNewResourceName(currentResource);
                if (newName == null || newName.isEmpty()) {
                    return;
                }
                this.newPath = currentResource.getFullPath().removeLastSegments(1).append(newName);
                super.run();
            }
        } else {
            this.runWithInlineEditor();
        }
    }

    private void runWithInlineEditor() {
        IResource currentResource = this.getCurrentResource();
        if (!this.checkReadOnlyAndNull(currentResource)) {
            return;
        }
        this.queryNewResourceNameInline(currentResource);
    }

    private IResource getCurrentResource() {
        List<? extends IResource> resources = this.getSelectedResources();
        if (resources.size() == 1) {
            return resources.get(0);
        }
        return null;
    }

    protected void runWithNewPath(IPath path, IResource resource) {
        this.newPath = path;
        super.run();
    }

    private void saveChangesAndDispose(IResource resource) {
        if (this.saving) {
            return;
        }
        this.saving = true;
        this.inlinedResource = resource;
        String newName = this.textEditor.getText();
        Runnable query = () -> {
            try {
                if (!newName.equals(this.inlinedResource.getName())) {
                    IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
                    IStatus status = workspace.validateName(newName, this.inlinedResource.getType());
                    if (!status.isOK()) {
                        this.displayError(status.getMessage());
                    } else if (!LTKLauncher.renameResource(newName, (IStructuredSelection)new StructuredSelection((Object)this.inlinedResource))) {
                        IPath newPath = this.inlinedResource.getFullPath().removeLastSegments(1).append(newName);
                        this.runWithNewPath(newPath, this.inlinedResource);
                    }
                }
                this.inlinedResource = null;
                this.disposeTextWidget();
                if (this.navigatorTree != null && !this.navigatorTree.isDisposed()) {
                    this.navigatorTree.setFocus();
                }
            }
            finally {
                this.saving = false;
            }
        };
        this.getTree().getShell().getDisplay().asyncExec(query);
    }

    @Override
    protected boolean updateSelection(IStructuredSelection selection) {
        this.disposeTextWidget();
        if (selection.size() > 1) {
            return false;
        }
        if (!super.updateSelection(selection)) {
            return false;
        }
        IResource currentResource = this.getCurrentResource();
        return currentResource != null && currentResource.exists();
    }

    public void setTextActionHandler(TextActionHandler actionHandler) {
        this.textActionHandler = actionHandler;
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] modelProviderIds) {
        this.modelProviderIds = modelProviderIds;
    }

    @Override
    protected IRunnableWithProgress createOperation(IStatus[] errorStatus) {
        return monitor -> {
            IResource[] resources = this.getActionResources().toArray(new IResource[this.getActionResources().size()]);
            if (resources.length == 1) {
                IWorkspaceRoot workspaceRoot = resources[0].getWorkspace().getRoot();
                IResource newResource = workspaceRoot.findMember(this.newPath);
                boolean go = true;
                if (newResource != null) {
                    go = this.checkOverwrite(this.getShell(), newResource);
                }
                if (go) {
                    MoveResourcesOperation op = new MoveResourcesOperation(resources[0], this.newPath, IDEWorkbenchMessages.RenameResourceAction_operationTitle);
                    op.setModelProviderIds(this.getModelProviderIds());
                    try {
                        PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, WorkspaceUndoUtil.getUIInfoAdapter(this.getShell()));
                    }
                    catch (ExecutionException e) {
                        IDEWorkbenchPlugin.log(e.toString());
                        iStatusArray[0] = e.getCause() instanceof CoreException ? ((CoreException)e.getCause()).getStatus() : new Status(4, "org.eclipse.ui", this.getProblemsMessage(), (Throwable)e);
                    }
                }
            }
        };
    }
}

