/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.ui.generators.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.eef.EEFGen.EEFGenModel;
import org.eclipse.emf.eef.codegen.core.launcher.AbstractPropertiesGeneratorLauncher;
import org.eclipse.emf.eef.codegen.core.services.PropertiesGeneratorLaunchersServices;
import org.eclipse.emf.eef.codegen.launcher.EEFLauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateAll {
    private File targetFolder;
    private EEFGenModel eefGenModel;
    private Set<IContainer> generationTargets;

    public GenerateAll(IContainer targetFolder, EEFGenModel eefGenModel) {
        this.targetFolder = targetFolder.getLocation().toFile();
        this.eefGenModel = eefGenModel;
        this.generationTargets = new HashSet<IContainer>();
        this.generationTargets.add(targetFolder);
    }

    public Set<IContainer> getGenerationTargets() {
        return this.generationTargets;
    }

    public void doGenerate(IProgressMonitor monitor) throws IOException {
        if (!this.targetFolder.exists()) {
            monitor.subTask("Creating target folder");
            this.targetFolder.mkdirs();
        }
        monitor.worked(1);
        ArrayList arguments = new ArrayList();
        monitor.subTask("Loading...");
        EEFLauncher launcher = new EEFLauncher((EObject)this.eefGenModel, this.targetFolder, arguments);
        monitor.worked(2);
        launcher.doGenerate(BasicMonitor.toMonitor((IProgressMonitorWithBlocking)new SubProgressMonitor(monitor, -1)));
        for (AbstractPropertiesGeneratorLauncher abstractPropertiesGeneratorLauncher : PropertiesGeneratorLaunchersServices.getInstance().getlaunchers()) {
            abstractPropertiesGeneratorLauncher.doGenerate(this.eefGenModel, this.targetFolder, monitor);
            if (abstractPropertiesGeneratorLauncher.getTargetContainer().isEmpty()) continue;
            this.generationTargets.addAll(abstractPropertiesGeneratorLauncher.getTargetContainer());
        }
    }
}

