/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.ecore.services;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;

public class FileUtil {
    private static final String MODEL = "model";
    private static final String EDIT = "edit";
    private static final String EDITOR = "editor";
    private static final String TESTS = "tests";

    public boolean fileExists(GenModel genModel, String filePath, String generationKind) {
        boolean result = false;
        String outputFolder = null;
        if (EDIT.equals(generationKind)) {
            outputFolder = genModel.getEditDirectory();
        } else if (EDITOR.equals(generationKind)) {
            outputFolder = genModel.getEditorDirectory();
        } else if (MODEL.equals(generationKind)) {
            outputFolder = genModel.getModelDirectory();
        } else if (TESTS.equals(generationKind)) {
            outputFolder = genModel.getTestsDirectory();
        }
        if (outputFolder != null) {
            IPath location = ResourcesPlugin.getWorkspace().getRoot().getLocation().append((IPath)new Path(outputFolder));
            IContainer iContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(location);
            if (iContainer != null && iContainer.exists()) {
                result = iContainer instanceof IProject ? iContainer.getFile((IPath)new Path(filePath)).exists() : iContainer.getProject().getFile((IPath)new Path(filePath)).exists();
            }
        }
        return result;
    }
}

