/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.flow.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.eef.codegen.core.util.ExtensionHelper;
import org.eclipse.emf.eef.codegen.flow.Step;
import org.eclipse.emf.eef.codegen.flow.var.WorkflowVariable;
import org.w3c.dom.Node;

public class MergePluginXML
extends Step {
    private Object editGenProject;

    public MergePluginXML(String name, Object editGenProject) {
        super(name);
        this.editGenProject = editGenProject;
    }

    public IStatus execute(IProgressMonitor monitor) {
        try {
            IProject editProject = this.getEditGenProject();
            editProject.refreshLocal(2, monitor);
            PluginXMLSearcher searcher = new PluginXMLSearcher();
            editProject.accept((IResourceVisitor)searcher);
            ExtensionHelper actualHelper = new ExtensionHelper(editProject);
            for (IFile next : searcher.filesToMerge) {
                ExtensionHelper predictiveHelper = new ExtensionHelper(next);
                List<Node> diff = actualHelper.diff(predictiveHelper);
                actualHelper.append(diff);
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.emf.eef.codegen", "An error occured during workspace analysis.", (Throwable)e);
        }
    }

    private IProject getEditGenProject() {
        if (this.editGenProject instanceof IProject) {
            return (IProject)this.editGenProject;
        }
        if (this.editGenProject instanceof WorkflowVariable) {
            return (IProject)((WorkflowVariable)this.editGenProject).getValue();
        }
        return null;
    }

    private class PluginXMLSearcher
    implements IResourceVisitor {
        private List<IFile> filesToMerge = new ArrayList<IFile>();

        public boolean visit(IResource resource) throws CoreException {
            IFile file;
            if (resource instanceof IFile && (file = (IFile)resource).getName().matches(".*\\.plugin\\.xml")) {
                this.filesToMerge.add(file);
            }
            return true;
        }
    }
}

