/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.ui.eclipse.launch;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.mwe.internal.core.debug.communication.Connection;
import org.eclipse.jdt.launching.JavaRuntime;

public class ConnectRunnable
implements Runnable {
    private Connection fConnector = null;
    private Exception fException = null;
    private Thread thread = null;

    public ConnectRunnable(Connection connector) {
        this.fConnector = connector;
    }

    @Override
    public void run() {
        try {
            int timeout = Platform.getPreferencesService().getInt("org.eclipse.jdt.launching", JavaRuntime.PREF_CONNECT_TIMEOUT, 20000, null);
            this.fConnector.accept(timeout);
        }
        catch (Exception e) {
            this.fException = e;
        }
    }

    public void cancel() {
        this.fConnector.close();
    }

    public Exception getException() {
        return this.fException;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public boolean isRunning() {
        return this.thread.isAlive();
    }

    public static ConnectRunnable startListeningThread(Connection connector) {
        ConnectRunnable runnable = new ConnectRunnable(connector);
        Thread connectThread = new Thread((Runnable)runnable, "Listening Connector");
        runnable.setThread(connectThread);
        connectThread.setDaemon(true);
        connectThread.start();
        return runnable;
    }
}

