/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.preferences;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.ui.EMFCompareUIPlugin;
import org.eclipse.emf.compare.ui.util.EMFCompareConstants;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class EMFComparePreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public EMFComparePreferencesPage() {
        super(1);
        this.setPreferenceStore(EMFCompareUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(EMFCompareUIMessages.getString("EMFComparePreferencesPage.description"));
    }

    public void createFieldEditors() {
        PreferenceLinkArea link = new PreferenceLinkArea(this.getFieldEditorParent(), 0, "org.eclipse.ui.preferencePages.ContentTypes", EMFCompareUIMessages.getString("EMFComparePreferencesPage.contentTypesLink"), (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        link.getControl().setLayoutData((Object)gd);
        ImageIntegerFieldEditor searchWindowEditor = new ImageIntegerFieldEditor("emfcompare.search.window", EMFCompareConstants.PREFERENCES_DESCRIPTION_SEARCH_WINDOW, this.getFieldEditorParent());
        this.addField(searchWindowEditor);
        this.addField((FieldEditor)new BooleanFieldEditor("emfcompare.ignore.ID", EMFCompareConstants.PREFERENCES_DESCRIPTION_IGNORE_ID, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("emfcompare.ignore.XMI.ID", EMFCompareConstants.PREFERENCES_DESCRIPTION_IGNORE_XMIID, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("viewer.draw.differences", EMFCompareConstants.PREFERENCES_DESCRIPTION_DRAW_DIFFERENCES, this.getFieldEditorParent()));
        Group colorGroup = new Group(this.getFieldEditorParent(), 16);
        colorGroup.setText(EMFCompareUIMessages.getString("EMFComparePreferencesPage.colorGroupTitle"));
        this.addField((FieldEditor)new CompareColorFieldEditor("highlight.color", EMFCompareConstants.PREFERENCES_DESCRIPTION_HIGHLIGHT_COLOR, (Composite)colorGroup));
        this.addField((FieldEditor)new CompareColorFieldEditor("changed.color", EMFCompareConstants.PREFERENCES_DESCRIPTION_CHANGED_COLOR, (Composite)colorGroup));
        this.addField((FieldEditor)new CompareColorFieldEditor("conflicting.color", EMFCompareConstants.PREFERENCES_DESCRIPTION_CONFLICTING_COLOR, (Composite)colorGroup));
        this.addField((FieldEditor)new CompareColorFieldEditor("added.color", EMFCompareConstants.PREFERENCES_DESCRIPTION_ADDED_COLOR, (Composite)colorGroup));
        this.addField((FieldEditor)new CompareColorFieldEditor("removed.color", EMFCompareConstants.PREFERENCES_DESCRIPTION_REMOVED_COLOR, (Composite)colorGroup));
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        colorGroup.setLayoutData((Object)gd);
    }

    public void init(IWorkbench workbench) {
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("emfcompare.search.window") || event.getProperty().equals("emfcompare.ignore.ID") || event.getProperty().equals("emfcompare.ignore.XMI.ID")) {
                    EMFComparePreferencesPage.this.reflectOnCore();
                }
            }
        });
    }

    protected void reflectOnCore() {
        Preferences corePreferences = EMFComparePlugin.getDefault().getPluginPreferences();
        corePreferences.setValue("emfcompare.search.window", this.getPreferenceStore().getInt("emfcompare.search.window"));
        corePreferences.setValue("emfcompare.ignore.ID", this.getPreferenceStore().getBoolean("emfcompare.ignore.ID"));
        corePreferences.setValue("emfcompare.ignore.XMI.ID", this.getPreferenceStore().getBoolean("emfcompare.ignore.XMI.ID"));
    }

    private final class CompareColorFieldEditor
    extends ColorFieldEditor {
        public CompareColorFieldEditor(String name, String label, Composite parent) {
            super(name, label, parent);
        }

        protected void adjustForNumColumns(int numColumns) {
            ((GridData)this.getColorSelector().getButton().getLayoutData()).horizontalSpan = 1;
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            Label control = this.getLabelControl(parent);
            GridData gd = new GridData();
            gd.horizontalSpan = 1;
            control.setLayoutData((Object)gd);
            Button colorButton = this.getChangeControl(parent);
            colorButton.setLayoutData((Object)new GridData());
        }
    }

    private final class ImageIntegerFieldEditor
    extends FieldEditor {
        protected Label image;
        protected boolean isValid;
        protected Integer oldValue;
        protected Text textField;

        public ImageIntegerFieldEditor(String name, String labelText, Composite parent) {
            this.init(name, labelText);
            this.createControl(parent);
        }

        public int getNumberOfControls() {
            return 3;
        }

        public boolean isValid() {
            return this.isValid;
        }

        protected void adjustForNumColumns(int numColumns) {
            GridData gd = (GridData)this.image.getLayoutData();
            gd.horizontalSpan = numColumns - 2;
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            this.getLabelControl(parent);
            this.createTextControl(parent);
            GridData gd = new GridData();
            GC gc = new GC((Drawable)this.textField);
            Point extent = gc.textExtent("W");
            gc.dispose();
            gd.widthHint = 5 * extent.x;
            this.textField.setLayoutData((Object)gd);
            this.image = new Label(parent, 0);
            this.image.setImage(this.getHelpIcon());
            this.image.setToolTipText(EMFCompareUIMessages.getString("EMFComparePreferencesPage.searchWindowHelp"));
            gd = new GridData();
            gd.horizontalSpan = numColumns - 1;
            this.image.setLayoutData((Object)gd);
        }

        protected void doLoad() {
            if (this.textField != null) {
                this.oldValue = this.getPreferenceStore().getInt(this.getPreferenceName());
                this.textField.setText(Integer.toString(this.oldValue));
            }
        }

        protected void doLoadDefault() {
            if (this.textField != null) {
                int value = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
                this.textField.setText(Integer.toString(value));
            }
            this.valueChanged();
        }

        protected void doStore() {
            if (this.textField != null) {
                int newValue = Integer.valueOf(this.textField.getText());
                this.getPreferenceStore().setValue(this.getPreferenceName(), newValue);
            }
        }

        protected void refreshValidState() {
            this.clearErrorMessage();
            try {
                Integer.parseInt(this.textField.getText());
                this.isValid = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.isValid = false;
                this.showErrorMessage(EMFCompareUIMessages.getString("EMFComparePrefetencesPage.ImageIntegerFieldEditor.invalidInput"));
            }
        }

        protected void valueChanged() {
            int newValue;
            boolean oldState = this.isValid;
            this.refreshValidState();
            if (this.isValid != oldState) {
                this.fireStateChanged("field_editor_is_valid", oldState, this.isValid);
            }
            if (this.isValid && (newValue = Integer.parseInt(this.textField.getText())) != this.oldValue) {
                this.fireValueChanged("field_editor_value", this.oldValue, newValue);
                this.oldValue = Integer.parseInt(this.textField.getText());
            }
        }

        private Text createTextControl(Composite parent) {
            if (this.textField == null) {
                this.textField = new Text(parent, 2052);
                this.textField.setFont(parent.getFont());
                this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyReleased(KeyEvent event) {
                        ImageIntegerFieldEditor.this.valueChanged();
                    }
                });
                this.textField.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        ImageIntegerFieldEditor.this.textField = null;
                    }
                });
            }
            return this.textField;
        }

        private Image getHelpIcon() {
            Image helpIcon;
            block2: {
                helpIcon = null;
                try {
                    ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)Platform.getBundle((String)"org.eclipse.emf.compare.ui").getEntry("icons/full/prefshelp.gif")));
                    helpIcon = descriptor.createImage();
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError();
                }
            }
            return helpIcon;
        }
    }
}

