/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStatement
extends Statement {
    private final Expression fileName;
    private final Statement[] body;
    private final Identifier mode;

    public FileStatement(int start, int end, int line, Expression fileName, Statement[] body, Identifier mode) {
        super(start, end, line);
        this.fileName = fileName;
        this.body = body;
        this.mode = mode;
    }

    public Statement[] getBody() {
        return this.body;
    }

    public Expression getTargetFileName() {
        return this.fileName;
    }

    public Identifier getMode() {
        return this.mode;
    }

    @Override
    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier result = this.getTargetFileName().analyze(ctx, issues);
        if (!BuiltinMetaModel.isAssignableFrom((EClassifier)EcorePackage.eINSTANCE.getEString(), result)) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "String expected!", this.getTargetFileName()));
        }
        Statement[] statementArray = this.body;
        int n = 0;
        int n2 = statementArray.length;
        while (n < n2) {
            Statement element = statementArray[n];
            element.analyze(ctx, issues);
            ++n;
        }
    }

    @Override
    public void evaluateInternal(XpandExecutionContext ctx) {
        Object result = this.getTargetFileName().evaluate(ctx);
        if (result == null) {
            throw new EvaluationException("Nullevaluation", (SyntaxElement)this.getTargetFileName());
        }
        String fileName = result.toString();
        String modeVal = null;
        if (this.mode != null) {
            modeVal = this.mode.getValue();
        }
        ctx.getOutput().openFile(fileName, modeVal);
        Statement[] statementArray = this.body;
        int n = 0;
        int n2 = statementArray.length;
        while (n < n2) {
            Statement element = statementArray[n];
            element.evaluate(ctx);
            ++n;
        }
        ctx.getOutput().closeFile();
    }
}

