/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.OrthogonalConnectionAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PrecisionPointList;

public class BaseSlidableAnchor
extends AbstractConnectionAnchor
implements OrthogonalConnectionAnchor {
    private static final char TERMINAL_START_CHAR = '(';
    private static final char TERMINAL_DELIMITER_CHAR = ',';
    private static final char TERMINAL_END_CHAR = ')';
    private PrecisionPoint relativeReference;
    private static int STRAIGHT_LINE_TOLERANCE = 3;

    public BaseSlidableAnchor() {
    }

    public BaseSlidableAnchor(IFigure f) {
        super(f);
    }

    public BaseSlidableAnchor(IFigure f, PrecisionPoint p) {
        super(f);
        this.relativeReference = new PrecisionPoint(p.preciseX, p.preciseY);
    }

    public String getTerminal() {
        if (this.isDefaultAnchor()) {
            return "";
        }
        return this.composeTerminalString(this.relativeReference);
    }

    public Point getReferencePoint() {
        return this.getAnchorPosition();
    }

    private String composeTerminalString(PrecisionPoint p) {
        StringBuffer s = new StringBuffer(24);
        s.append('(');
        s.append((float)p.preciseX);
        s.append(',');
        s.append((float)p.preciseY);
        s.append(')');
        return s.toString();
    }

    private Point getAnchorPosition() {
        PrecisionRectangle rBox = new PrecisionRectangle(this.getBox());
        if (this.isDefaultAnchor()) {
            return rBox.getCenter();
        }
        return new PrecisionPoint(this.relativeReference.preciseX * rBox.preciseWidth + rBox.preciseX, this.relativeReference.preciseY * rBox.preciseHeight + rBox.preciseY);
    }

    protected Point getLocation(Point ownReference, Point foreignReference) {
        PointList intersections = this.getIntersectionPoints(ownReference, foreignReference);
        if (intersections != null && intersections.size() != 0) {
            Point location = PointListUtilities.pickClosestPoint(intersections, foreignReference);
            return location;
        }
        return null;
    }

    public Point getLocation(Point reference) {
        Point ownReference = this.normalizeToStraightlineTolerance(reference, this.getReferencePoint(), STRAIGHT_LINE_TOLERANCE);
        Point location = this.getLocation(ownReference, reference);
        if (location == null && (location = this.getLocation((Point)new PrecisionPoint(this.getBox().getCenter()), reference)) == null) {
            location = this.getBox().getCenter();
        }
        return location;
    }

    protected Point normalizeToStraightlineTolerance(Point foreignReference, Point ownReference, int tolerance) {
        PrecisionPoint preciseOwnReference = new PrecisionPoint(ownReference);
        PrecisionPoint normalizedReference = (PrecisionPoint)preciseOwnReference.getCopy();
        PrecisionPoint preciseForeignReference = new PrecisionPoint(foreignReference);
        if (Math.abs(preciseForeignReference.preciseX - preciseOwnReference.preciseX) < (double)tolerance) {
            normalizedReference.preciseX = preciseForeignReference.preciseX;
            normalizedReference.updateInts();
            return normalizedReference;
        }
        if (Math.abs(preciseForeignReference.preciseY - preciseOwnReference.preciseY) < (double)tolerance) {
            normalizedReference.preciseY = preciseForeignReference.preciseY;
            normalizedReference.updateInts();
        }
        return normalizedReference;
    }

    protected PointList getIntersectionPoints(Point ownReference, Point foreignReference) {
        PointList polygon = this.getPolygonPoints();
        return new LineSeg(ownReference, foreignReference).getLineIntersectionsWithLineSegs(polygon);
    }

    protected PointList getPolygonPoints() {
        if (this.getOwner() instanceof IPolygonAnchorableFigure) {
            PrecisionPointList polyList = new PrecisionPointList(((IPolygonAnchorableFigure)this.getOwner()).getPolygonPoints());
            this.getOwner().translateToAbsolute((Translatable)polyList);
            return polyList;
        }
        PrecisionRectangle r = new PrecisionRectangle(this.getBox());
        PrecisionPointList ptList = new PrecisionPointList(5);
        ptList.addPoint((Point)new PrecisionPoint(r.preciseX, r.preciseY));
        ptList.addPoint((Point)new PrecisionPoint(r.preciseX + r.preciseWidth, r.preciseY));
        ptList.addPoint((Point)new PrecisionPoint(r.preciseX + r.preciseWidth, r.preciseY + r.preciseHeight));
        ptList.addPoint((Point)new PrecisionPoint(r.preciseX, r.preciseY + r.preciseHeight));
        ptList.addPoint((Point)new PrecisionPoint(r.preciseX, r.preciseY));
        return ptList;
    }

    public static PrecisionPoint getAnchorRelativeLocation(Point p, Rectangle bounds) {
        PrecisionPoint relLocation;
        if (bounds.width == 0 || bounds.height == 0) {
            return new PrecisionPoint(0.5, 0.5);
        }
        Point temp = new Point(p);
        if (p.x < bounds.x || p.x > bounds.x + bounds.width || p.y < bounds.y || p.y > bounds.y + bounds.height) {
            if (p.x < bounds.x || p.x > bounds.x + bounds.width) {
                int n = temp.x = p.x < bounds.x ? bounds.x : bounds.x + bounds.width;
            }
            if (p.y < bounds.y || p.y > bounds.y + bounds.height) {
                temp.y = p.y < bounds.y ? bounds.y : bounds.y + bounds.height;
            }
            relLocation = new PrecisionPoint((double)(temp.x - bounds.x) / (double)bounds.width, (double)(temp.y - bounds.y) / (double)bounds.height);
        } else {
            relLocation = new PrecisionPoint((double)(temp.x - bounds.x) / (double)bounds.width, (double)(temp.y - bounds.y) / (double)bounds.height);
        }
        return relLocation;
    }

    protected Rectangle getBox() {
        Rectangle rBox = this.getOwner() instanceof Connection ? ((Connection)this.getOwner()).getPoints().getBounds() : this.getOwner().getBounds();
        PrecisionRectangle box = new PrecisionRectangle(rBox);
        this.getOwner().translateToAbsolute((Translatable)box);
        return box;
    }

    public boolean isDefaultAnchor() {
        return this.relativeReference == null;
    }

    public static PrecisionPoint parseTerminalString(String terminal) {
        try {
            return new PrecisionPoint((double)Float.parseFloat(terminal.substring(terminal.indexOf(40) + 1, terminal.indexOf(44))), (double)Float.parseFloat(terminal.substring(terminal.indexOf(44) + 1, terminal.indexOf(41))));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Point getOrthogonalLocation(Point orthoReference) {
        PrecisionPoint ownReference = new PrecisionPoint(this.getReferencePoint());
        PrecisionRectangle bounds = new PrecisionRectangle(FigureUtilities.getAnchorableFigureBounds(this.getOwner()));
        this.getOwner().translateToAbsolute((Translatable)bounds);
        bounds.expand(1.0E-6, 1.0E-6);
        PrecisionPoint preciseOrthoReference = new PrecisionPoint(orthoReference);
        int orientation = 0;
        if (preciseOrthoReference.preciseX >= bounds.preciseX && preciseOrthoReference.preciseX <= bounds.preciseX + bounds.preciseWidth) {
            ownReference.preciseX = preciseOrthoReference.preciseX;
            orientation = 128;
        } else if (preciseOrthoReference.preciseY >= bounds.preciseY && preciseOrthoReference.preciseY <= bounds.preciseY + bounds.preciseHeight) {
            ownReference.preciseY = preciseOrthoReference.preciseY;
            orientation = 64;
        }
        ownReference.updateInts();
        Point location = this.getLocation((Point)ownReference, (Point)preciseOrthoReference);
        if (location == null) {
            location = this.getLocation(orthoReference);
            orientation = 0;
        }
        if (orientation != 0) {
            PrecisionPoint loc = new PrecisionPoint(location);
            if (orientation == 128) {
                loc.preciseX = preciseOrthoReference.preciseX;
            } else {
                loc.preciseY = preciseOrthoReference.preciseY;
            }
            loc.updateInts();
            location = loc;
        }
        return location;
    }
}

