/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.lite.validation.IValidationStateUpdater;
import org.eclipse.gmf.runtime.lite.validation.ValidationStateManager;
import org.eclipse.gmf.runtime.lite.validation.ViolationDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationState {
    private final URI myDiagramUri;
    private final ValidationStateManager myStateManager;
    private HashMap<URI, Collection<ViolationDescriptor>> myViolations = new HashMap();
    private ValidationStateUpdater myUpdater;

    public ValidationState(ValidationStateManager stateManager, URI diagramUri) {
        this.myDiagramUri = diagramUri;
        this.myStateManager = stateManager;
    }

    public URI getDiagramUri() {
        return this.myDiagramUri;
    }

    public Collection<ViolationDescriptor> getViolations(URI uri) {
        return this.myViolations.get(uri);
    }

    public Collection<ViolationDescriptor> getAllViolations() {
        ArrayList<ViolationDescriptor> result = new ArrayList<ViolationDescriptor>();
        for (Collection<ViolationDescriptor> next : this.myViolations.values()) {
            result.addAll(next);
        }
        return result;
    }

    public IValidationStateUpdater startUpdate() {
        if (this.myUpdater != null) {
            throw new IllegalStateException();
        }
        this.myUpdater = new ValidationStateUpdater();
        return this.myUpdater;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValidationStateUpdater
    implements IValidationStateUpdater {
        private HashMap<URI, Collection<ViolationDescriptor>> myUpdatedViolations = new HashMap();

        @Override
        public void addViolation(ViolationDescriptor violation) {
            if (violation == null) {
                return;
            }
            URI uri = violation.getUri();
            Collection<ViolationDescriptor> descriptors = this.get(uri, true);
            if (!descriptors.contains(violation)) {
                descriptors.add(violation);
            }
        }

        public void removeViolation(ViolationDescriptor violation) {
            if (violation == null) {
                return;
            }
            URI uri = violation.getUri();
            Collection<ViolationDescriptor> descriptors = this.get(uri, false);
            if (descriptors != null) {
                descriptors.remove(violation);
            }
        }

        private Collection<ViolationDescriptor> get(URI uri, boolean createIfMissing) {
            Collection<ViolationDescriptor> result = this.myUpdatedViolations.get(uri);
            if (result == null && createIfMissing) {
                result = new ArrayList<ViolationDescriptor>();
                this.myUpdatedViolations.put(uri, result);
            }
            return result;
        }

        @Override
        public void commitChanges() {
            if (ValidationState.this.myUpdater != this) {
                throw new IllegalStateException();
            }
            try {
                HashMap oldViolations = ValidationState.this.myViolations;
                ValidationState.this.myViolations = this.myUpdatedViolations;
                ValidationState.this.myStateManager.fireValidationStateChanged(ValidationState.this, Collections.unmodifiableMap(oldViolations), Collections.unmodifiableMap(this.myUpdatedViolations));
            }
            finally {
                ValidationState.this.myUpdater = null;
            }
        }

        @Override
        public void discardChanges() {
            if (ValidationState.this.myUpdater == this) {
                ValidationState.this.myUpdater = null;
            }
        }
    }
}

