/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.label;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gmf.runtime.diagram.core.providers.AbstractViewProvider;
import org.eclipse.gmf.runtime.diagram.ui.view.factories.BasicNodeViewFactory;
import org.eclipse.gmf.runtime.diagram.ui.view.factories.NoteViewFactory;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.label.LabelConstants;
import org.eclipse.swt.graphics.RGB;

public class LabelViewProvider
extends AbstractViewProvider {
    private static final Map nodeMap = new HashMap();

    static {
        nodeMap.put(LabelConstants.VIEWTYPE_GEFLABEL_NOTE, GEFLabelNoteViewFactory.class);
        nodeMap.put(LabelConstants.VIEWTYPE_WRAPPINGLABEL_NOTE, WrappingLabelNoteViewFactory.class);
        nodeMap.put(LabelConstants.VIEWTYPE_OLDWRAPLABEL_NOTE, OldWrapLabelNoteViewFactory.class);
        nodeMap.put(LabelConstants.VIEWTYPE_WRAPLABEL_NOTE, WrapLabelNoteViewFactory.class);
        nodeMap.put("GEFLabel", BasicNodeViewFactory.class);
        nodeMap.put("WrappingLabel", BasicNodeViewFactory.class);
        nodeMap.put("OldWrapLabel", BasicNodeViewFactory.class);
        nodeMap.put("WrapLabel", BasicNodeViewFactory.class);
    }

    protected Class getNodeViewClass(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        if (semanticHint != null && semanticHint.length() > 0) {
            return (Class)nodeMap.get(semanticHint);
        }
        return (Class)nodeMap.get(this.getSemanticEClass(semanticAdapter));
    }

    public static class GEFLabelNoteViewFactory
    extends NoteViewFactory {
        protected void decorateView(View containerView, View view, IAdaptable semanticAdapter, String semanticHint, int index, boolean persisted) {
            this.initializeFromPreferences(view);
            FillStyle fillStyle = (FillStyle)view.getStyle(NotationPackage.Literals.FILL_STYLE);
            if (fillStyle != null) {
                RGB fillRGB = ColorConstants.lightGray.getRGB();
                fillStyle.setFillColor(FigureUtilities.RGBToInteger((RGB)fillRGB).intValue());
            }
            GEFLabelNoteViewFactory.getViewService().createNode(semanticAdapter, view, "GEFLabel", -1, persisted, this.getPreferencesHint());
        }
    }

    public static class OldWrapLabelNoteViewFactory
    extends NoteViewFactory {
        protected void decorateView(View containerView, View view, IAdaptable semanticAdapter, String semanticHint, int index, boolean persisted) {
            this.initializeFromPreferences(view);
            FillStyle fillStyle = (FillStyle)view.getStyle(NotationPackage.Literals.FILL_STYLE);
            if (fillStyle != null) {
                RGB fillRGB = ColorConstants.lightGreen.getRGB();
                fillStyle.setFillColor(FigureUtilities.RGBToInteger((RGB)fillRGB).intValue());
            }
            OldWrapLabelNoteViewFactory.getViewService().createNode(semanticAdapter, view, "OldWrapLabel", -1, persisted, this.getPreferencesHint());
        }
    }

    public static class WrapLabelNoteViewFactory
    extends NoteViewFactory {
        protected void decorateView(View containerView, View view, IAdaptable semanticAdapter, String semanticHint, int index, boolean persisted) {
            this.initializeFromPreferences(view);
            FillStyle fillStyle = (FillStyle)view.getStyle(NotationPackage.Literals.FILL_STYLE);
            if (fillStyle != null) {
                RGB fillRGB = ColorConstants.yellow.getRGB();
                fillStyle.setFillColor(FigureUtilities.RGBToInteger((RGB)fillRGB).intValue());
            }
            WrapLabelNoteViewFactory.getViewService().createNode(semanticAdapter, view, "WrapLabel", -1, persisted, this.getPreferencesHint());
        }
    }

    public static class WrappingLabelNoteViewFactory
    extends NoteViewFactory {
        protected void decorateView(View containerView, View view, IAdaptable semanticAdapter, String semanticHint, int index, boolean persisted) {
            this.initializeFromPreferences(view);
            FillStyle fillStyle = (FillStyle)view.getStyle(NotationPackage.Literals.FILL_STYLE);
            if (fillStyle != null) {
                RGB fillRGB = ColorConstants.lightBlue.getRGB();
                fillStyle.setFillColor(FigureUtilities.RGBToInteger((RGB)fillRGB).intValue());
            }
            WrappingLabelNoteViewFactory.getViewService().createNode(semanticAdapter, view, "WrappingLabel", -1, persisted, this.getPreferencesHint());
        }
    }
}

