/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.util.EncodingUtilities;
import org.apache.batik.util.io.ASCIIDecoder;
import org.apache.batik.util.io.CharDecoder;
import org.apache.batik.util.io.GenericDecoder;
import org.apache.batik.util.io.ISO_8859_1Decoder;
import org.apache.batik.util.io.NormalizingReader;
import org.apache.batik.util.io.UTF16Decoder;
import org.apache.batik.util.io.UTF8Decoder;

public class StreamNormalizingReader
extends NormalizingReader {
    protected CharDecoder charDecoder;
    protected int nextChar = -1;
    protected int line = 1;
    protected int column;
    protected static final Map charDecoderFactories = new HashMap(11);

    public StreamNormalizingReader(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public StreamNormalizingReader(InputStream inputStream, String string) throws IOException {
        if (string == null) {
            string = "ISO-8859-1";
        }
        this.charDecoder = this.createCharDecoder(inputStream, string);
    }

    public StreamNormalizingReader(Reader reader) throws IOException {
        this.charDecoder = new GenericDecoder(reader);
    }

    protected StreamNormalizingReader() {
    }

    public int read() throws IOException {
        int n = this.nextChar;
        if (n != -1) {
            this.nextChar = -1;
            if (n == 13) {
                this.column = 0;
                ++this.line;
            } else {
                ++this.column;
            }
            return n;
        }
        n = this.charDecoder.readChar();
        switch (n) {
            case 13: {
                this.column = 0;
                ++this.line;
                int n2 = this.charDecoder.readChar();
                if (n2 == 10) {
                    return 10;
                }
                this.nextChar = n2;
                return 10;
            }
            case 10: {
                this.column = 0;
                ++this.line;
            }
        }
        return n;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public void close() throws IOException {
        this.charDecoder.dispose();
        this.charDecoder = null;
    }

    protected CharDecoder createCharDecoder(InputStream inputStream, String string) throws IOException {
        CharDecoderFactory charDecoderFactory = (CharDecoderFactory)charDecoderFactories.get(string.toUpperCase());
        if (charDecoderFactory != null) {
            return charDecoderFactory.createCharDecoder(inputStream);
        }
        String string2 = EncodingUtilities.javaEncoding(string);
        if (string2 == null) {
            string2 = string;
        }
        return new GenericDecoder(inputStream, string2);
    }

    static {
        ASCIIDecoderFactory aSCIIDecoderFactory = new ASCIIDecoderFactory();
        charDecoderFactories.put("ASCII", aSCIIDecoderFactory);
        charDecoderFactories.put("US-ASCII", aSCIIDecoderFactory);
        charDecoderFactories.put("ISO-8859-1", new ISO_8859_1DecoderFactory());
        charDecoderFactories.put("UTF-8", new UTF8DecoderFactory());
        charDecoderFactories.put("UTF-16", new UTF16DecoderFactory());
    }

    protected static class ASCIIDecoderFactory
    implements CharDecoderFactory {
        protected ASCIIDecoderFactory() {
        }

        public CharDecoder createCharDecoder(InputStream inputStream) throws IOException {
            return new ASCIIDecoder(inputStream);
        }
    }

    protected static interface CharDecoderFactory {
        public CharDecoder createCharDecoder(InputStream var1) throws IOException;
    }

    protected static class ISO_8859_1DecoderFactory
    implements CharDecoderFactory {
        protected ISO_8859_1DecoderFactory() {
        }

        public CharDecoder createCharDecoder(InputStream inputStream) throws IOException {
            return new ISO_8859_1Decoder(inputStream);
        }
    }

    protected static class UTF16DecoderFactory
    implements CharDecoderFactory {
        protected UTF16DecoderFactory() {
        }

        public CharDecoder createCharDecoder(InputStream inputStream) throws IOException {
            return new UTF16Decoder(inputStream);
        }
    }

    protected static class UTF8DecoderFactory
    implements CharDecoderFactory {
        protected UTF8DecoderFactory() {
        }

        public CharDecoder createCharDecoder(InputStream inputStream) throws IOException {
            return new UTF8Decoder(inputStream);
        }
    }
}

