/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SemanticEditPolicy
extends AbstractEditPolicy {
    private static final String DELETE_FROM_MODEL_DLG_TITLE = DiagramUIMessages.PromptingDeleteFromModelAction_DeleteFromModelDialog_Title;
    private static final String DELETE_FROM_MODEL_DLG_MESSAGE = DiagramUIMessages.PromptingDeleteFromModelAction_DeleteFromModelDialog_Message;
    private static final String DELETE_FROM_MODEL_DLG_TOGGLE_LABEL = DiagramUIMessages.MessageDialogWithToggle_DoNotPromptAgainToggle_label;

    public Command getCommand(Request request) {
        if ("wrap semantic request".equals(request.getType())) {
            return this.getSemanticCommand(((EditCommandRequestWrapper)request).getEditCommandRequest());
        }
        if ("Reconnection source".equals(request.getType()) && this.relationshipSourceHasChanged((ReconnectRequest)request)) {
            org.eclipse.gef.ConnectionEditPart connectionEP = ((ReconnectRequest)request).getConnectionEditPart();
            if (ViewUtil.resolveSemanticElement((View)((View)connectionEP.getModel())) == null) {
                return this.getReorientRefRelationshipSourceCommand((ReconnectRequest)request);
            }
            return this.getReorientRelationshipSourceCommand((ReconnectRequest)request);
        }
        if ("Reconnection target".equals(request.getType()) && this.relationshipTargetHasChanged((ReconnectRequest)request)) {
            org.eclipse.gef.ConnectionEditPart connectionEP = ((ReconnectRequest)request).getConnectionEditPart();
            if (ViewUtil.resolveSemanticElement((View)((View)connectionEP.getModel())) == null) {
                return this.getReorientRefRelationshipTargetCommand((ReconnectRequest)request);
            }
            return this.getReorientRelationshipTargetCommand((ReconnectRequest)request);
        }
        return super.getCommand(request);
    }

    private boolean relationshipTargetHasChanged(ReconnectRequest request) {
        return !request.getConnectionEditPart().getTarget().equals(request.getTarget());
    }

    private boolean relationshipSourceHasChanged(ReconnectRequest request) {
        return !request.getConnectionEditPart().getSource().equals(request.getTarget());
    }

    protected Command getSemanticCommand(IEditCommandRequest request) {
        IElementType elementType;
        ICommand semanticCommand;
        if (request instanceof DestroyRequest && this.getHost() instanceof ConnectionEditPart && !((ConnectionEditPart)this.getHost()).isSemanticConnection()) {
            return null;
        }
        IEditCommandRequest completedRequest = this.completeRequest(request);
        boolean shouldPromptOnDestroy = false;
        if (completedRequest instanceof DestroyRequest && !SemanticEditPolicy.isParentCanonical(this.getHost())) {
            shouldPromptOnDestroy = ((DestroyRequest)completedRequest).isConfirmationRequired();
            ((DestroyRequest)completedRequest).setConfirm(false);
        }
        ICommand iCommand = semanticCommand = (elementType = ElementTypeRegistry.getInstance().getElementType(completedRequest.getEditHelperContext())) != null ? elementType.getEditCommand(completedRequest) : null;
        if (semanticCommand == null) {
            return null;
        }
        if (completedRequest instanceof DestroyRequest) {
            ((DestroyRequest)completedRequest).setConfirm(shouldPromptOnDestroy);
        }
        boolean shouldProceed = true;
        if (completedRequest instanceof DestroyRequest) {
            shouldProceed = this.shouldProceed((DestroyRequest)completedRequest);
        }
        if (shouldProceed) {
            ICommandProxy c = new ICommandProxy(semanticCommand);
            if (completedRequest instanceof DestroyRequest) {
                TransactionalEditingDomain domain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
                DeleteCommand ic = new DeleteCommand(domain, (View)this.getHost().getModel());
                CompositeTransactionalCommand cc = new CompositeTransactionalCommand(domain, semanticCommand.getLabel());
                cc.setTransactionNestingEnabled(true);
                cc.compose((IUndoableOperation)semanticCommand);
                cc.compose((IUndoableOperation)ic);
                c = new ICommandProxy((ICommand)cc);
            }
            return c;
        }
        return null;
    }

    public boolean understandsRequest(Request request) {
        if (request instanceof EditCommandRequestWrapper) {
            return true;
        }
        if ("Reconnection source".equals(request.getType()) || "Reconnection target".equals(request.getType())) {
            EObject parentElement = null;
            if (this.getHost().getParent() instanceof IGraphicalEditPart) {
                parentElement = ViewUtil.resolveSemanticElement((View)((View)this.getHost().getParent().getModel()));
            }
            if (this.getHostElement() != parentElement) {
                return true;
            }
        }
        return false;
    }

    private EObject getHostElement() {
        return ViewUtil.resolveSemanticElement((View)((View)this.getHost().getModel()));
    }

    protected IEditCommandRequest completeRequest(IEditCommandRequest request) {
        IEditCommandRequest result = request;
        if (result instanceof DestroyRequest) {
            DestroyRequest destroyRequest = (DestroyRequest)result;
            if (this.getHostElement() != null) {
                if (destroyRequest instanceof DestroyElementRequest) {
                    ((DestroyElementRequest)destroyRequest).setElementToDestroy(this.getHostElement());
                    ((DestroyElementRequest)destroyRequest).getParameters().clear();
                } else {
                    result = new DestroyElementRequest(request.getEditingDomain(), this.getHostElement(), destroyRequest.isConfirmationRequired());
                    result.addParameters(request.getParameters());
                }
            } else if (this.getHost() instanceof ConnectionEditPart) {
                EObject container = ViewUtil.resolveSemanticElement((View)((Edge)this.getHost().getModel()).getSource());
                EObject referenceObject = ViewUtil.resolveSemanticElement((View)((Edge)this.getHost().getModel()).getTarget());
                if (destroyRequest instanceof DestroyReferenceRequest) {
                    DestroyReferenceRequest destroyReferenceRequest = (DestroyReferenceRequest)result;
                    destroyReferenceRequest.setContainer(container);
                    destroyReferenceRequest.setReferencedObject(referenceObject);
                } else {
                    result = new DestroyReferenceRequest(((IGraphicalEditPart)this.getHost()).getEditingDomain(), container, null, referenceObject, destroyRequest.isConfirmationRequired());
                    result.addParameters(request.getParameters());
                }
            }
        }
        return result;
    }

    protected Command getReorientRelationshipSourceCommand(ReconnectRequest request) {
        EObject connectionSemElement = ViewUtil.resolveSemanticElement((View)((View)request.getConnectionEditPart().getModel()));
        EObject targetSemElement = ViewUtil.resolveSemanticElement((View)((View)request.getTarget().getModel()));
        EObject oldSemElement = ViewUtil.resolveSemanticElement((View)((View)request.getConnectionEditPart().getSource().getModel()));
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        ReorientRelationshipRequest semRequest = new ReorientRelationshipRequest(editingDomain, connectionSemElement, targetSemElement, oldSemElement, 1);
        semRequest.addParameters(request.getExtendedData());
        return this.getSemanticCommand((IEditCommandRequest)semRequest);
    }

    protected Command getReorientRelationshipTargetCommand(ReconnectRequest request) {
        EObject connectionSemElement = ViewUtil.resolveSemanticElement((View)((View)request.getConnectionEditPart().getModel()));
        EObject targetSemElement = ViewUtil.resolveSemanticElement((View)((View)request.getTarget().getModel()));
        EObject oldSemElement = ViewUtil.resolveSemanticElement((View)((View)request.getConnectionEditPart().getTarget().getModel()));
        String connectionHint = ViewUtil.getSemanticElementClassId((View)((View)request.getConnectionEditPart().getModel()));
        if (((View)request.getTarget().getModel()).getElement() != null) {
            String targetHint = ViewUtil.getSemanticElementClassId((View)((View)request.getTarget().getModel()));
            if (request.getConnectionEditPart() instanceof ITreeBranchEditPart && request.getTarget() instanceof ITreeBranchEditPart && connectionHint.equals(targetHint)) {
                ITreeBranchEditPart targetBranch = (ITreeBranchEditPart)request.getTarget();
                targetSemElement = ViewUtil.resolveSemanticElement((View)((View)targetBranch.getTarget().getModel()));
            }
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        ReorientRelationshipRequest semRequest = new ReorientRelationshipRequest(editingDomain, connectionSemElement, targetSemElement, oldSemElement, 2);
        semRequest.addParameters(request.getExtendedData());
        return this.getSemanticCommand((IEditCommandRequest)semRequest);
    }

    public EditPart getTargetEditPart(Request request) {
        if (this.understandsRequest(request)) {
            return this.getHost();
        }
        return super.getTargetEditPart(request);
    }

    protected Command getReorientRefRelationshipSourceCommand(ReconnectRequest request) {
        org.eclipse.gef.ConnectionEditPart connectionEP = request.getConnectionEditPart();
        if (connectionEP instanceof ConnectionEditPart && !((ConnectionEditPart)connectionEP).isSemanticConnection()) {
            return null;
        }
        EditPart sourceEditPart = connectionEP.getSource();
        EditPart targetEditPart = connectionEP.getTarget();
        EObject referenceOwner = ViewUtil.resolveSemanticElement((View)((View)sourceEditPart.getModel()));
        EObject oldTarget = ViewUtil.resolveSemanticElement((View)((View)targetEditPart.getModel()));
        EObject newTarget = ViewUtil.resolveSemanticElement((View)((View)request.getTarget().getModel()));
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        ReorientReferenceRelationshipRequest semRequest = new ReorientReferenceRelationshipRequest(editingDomain, referenceOwner, newTarget, oldTarget, 1);
        semRequest.addParameters(request.getExtendedData());
        return this.getSemanticCommand((IEditCommandRequest)semRequest);
    }

    protected Command getReorientRefRelationshipTargetCommand(ReconnectRequest request) {
        org.eclipse.gef.ConnectionEditPart connectionEP = request.getConnectionEditPart();
        if (connectionEP instanceof ConnectionEditPart && !((ConnectionEditPart)connectionEP).isSemanticConnection()) {
            return null;
        }
        EditPart sourceEditPart = connectionEP.getSource();
        EditPart targetEditPart = connectionEP.getTarget();
        EObject referenceOwner = ViewUtil.resolveSemanticElement((View)((View)sourceEditPart.getModel()));
        EObject oldTarget = ViewUtil.resolveSemanticElement((View)((View)targetEditPart.getModel()));
        EObject newTarget = ViewUtil.resolveSemanticElement((View)((View)request.getTarget().getModel()));
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        ReorientReferenceRelationshipRequest semRequest = new ReorientReferenceRelationshipRequest(editingDomain, referenceOwner, newTarget, oldTarget, 2);
        semRequest.addParameters(request.getExtendedData());
        return this.getSemanticCommand((IEditCommandRequest)semRequest);
    }

    protected boolean shouldProceed(DestroyRequest destroyRequest) {
        if (SemanticEditPolicy.isParentCanonical(this.getHost())) {
            return true;
        }
        if (!destroyRequest.isConfirmationRequired()) {
            return true;
        }
        destroyRequest.setConfirm(false);
        return this.showMessageDialog();
    }

    private static boolean isParentCanonical(EditPart editpart) {
        EditPart parent = null;
        parent = editpart instanceof ConnectionEditPart && ((ConnectionEditPart)editpart).getSource() != null ? ((ConnectionEditPart)editpart).getSource().getParent() : editpart.getParent();
        return parent instanceof GraphicalEditPart && ((GraphicalEditPart)parent).isCanonical();
    }

    private boolean showMessageDialog() {
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)Display.getCurrent().getActiveShell(), (String)DELETE_FROM_MODEL_DLG_TITLE, (String)DELETE_FROM_MODEL_DLG_MESSAGE, (String)DELETE_FROM_MODEL_DLG_TOGGLE_LABEL, (boolean)false, (IPreferenceStore)((IPreferenceStore)((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint().getPreferenceStore()), (String)"Global.promptOnDelFromModel");
        return dialog.getReturnCode() == 2;
    }
}

