/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.tr;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramGenModelTransformer;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.FeatureLabelMapping;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.tests.Utils;
import org.eclipse.gmf.tests.setup.DiaDefSource;
import org.eclipse.gmf.tests.setup.MapDefSource;
import org.eclipse.gmf.tests.tr.AbstractMappingTransformerTest;

public class LabelMappingTransformTest
extends AbstractMappingTransformerTest {
    private GenEditorGenerator transformationResult;

    public LabelMappingTransformTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        DiagramGenModelTransformer t = new DiagramGenModelTransformer();
        t.setEMFGenModel(Utils.createGenModel(this.getCanvasMapping().getDomainModel()));
        t.transform(this.getMapping());
        this.transformationResult = t.getResult();
        LabelMappingTransformTest.assertNotNull((Object)this.transformationResult);
    }

    protected MapDefSource initMapModel(DiaDefSource graphDef) {
        return new MapDefSource(graphDef){
            private Mapping mapping;
            private NodeMapping nodeA;
            private NodeMapping nodeB;
            {
                EPackage domainPack = EcoreFactory.eINSTANCE.createEPackage();
                domainPack.setName("DomainPack");
                EClass domainA = EcoreFactory.eINSTANCE.createEClass();
                domainA.setName("DomainA");
                EClass domainB = EcoreFactory.eINSTANCE.createEClass();
                domainB.setName("DomainB");
                domainPack.getEClassifiers().add((Object)domainA);
                domainPack.getEClassifiers().add((Object)domainB);
                EAttribute nameA = EcoreFactory.eINSTANCE.createEAttribute();
                nameA.setName("nameA");
                domainA.getEStructuralFeatures().add((Object)nameA);
                EAttribute nameB = EcoreFactory.eINSTANCE.createEAttribute();
                nameB.setName("nameB");
                domainB.getEStructuralFeatures().add((Object)nameB);
                EReference aOwnsA = LabelMappingTransformTest.newContainment("aOwnsA", domainA);
                domainA.getEStructuralFeatures().add((Object)aOwnsA);
                EReference bOwnsB = LabelMappingTransformTest.newContainment("bOwnsB", domainB);
                domainB.getEStructuralFeatures().add((Object)bOwnsB);
                this.mapping = GMFMapFactory.eINSTANCE.createMapping();
                CanvasMapping cme = GMFMapFactory.eINSTANCE.createCanvasMapping();
                cme.setDiagramCanvas(diaDefSource.getCanvasDef());
                cme.setDomainModel(domainPack);
                this.mapping.setDiagram(cme);
                this.nodeA = GMFMapFactory.eINSTANCE.createNodeMapping();
                this.nodeA.setDiagramNode(diaDefSource.getNodeDef());
                this.nodeA.setDomainMetaElement(domainA);
                FeatureLabelMapping lm = GMFMapFactory.eINSTANCE.createFeatureLabelMapping();
                lm.setDiagramLabel(diaDefSource.getLabelDef());
                lm.getFeatures().add((Object)nameA);
                this.nodeA.getLabelMappings().add((Object)lm);
                ChildReference childRef = GMFMapFactory.eINSTANCE.createChildReference();
                childRef.setContainmentFeature(aOwnsA);
                childRef.setReferencedChild(this.nodeA);
                this.nodeA.getChildren().add((Object)childRef);
                this.nodeB = GMFMapFactory.eINSTANCE.createNodeMapping();
                this.nodeB.setDiagramNode(diaDefSource.getNodeDef());
                this.nodeB.setDomainMetaElement(domainB);
                lm = GMFMapFactory.eINSTANCE.createFeatureLabelMapping();
                lm.setDiagramLabel(diaDefSource.getLabelDef());
                lm.getFeatures().add((Object)nameB);
                NodeMapping childNodeB = GMFMapFactory.eINSTANCE.createNodeMapping();
                childNodeB.setDiagramNode((Node)lm.getDiagramLabel());
                childNodeB.setDomainMetaElement(domainB);
                childNodeB.getLabelMappings().add((Object)lm);
                childRef = GMFMapFactory.eINSTANCE.createChildReference();
                childRef.setContainmentFeature(bOwnsB);
                childRef.setOwnedChild(childNodeB);
                this.nodeB.getChildren().add((Object)childRef);
                TopNodeReference tnr = GMFMapFactory.eINSTANCE.createTopNodeReference();
                tnr.setOwnedChild(this.nodeA);
                tnr.setContainmentFeature(aOwnsA);
                this.mapping.getNodes().add((Object)tnr);
                tnr = GMFMapFactory.eINSTANCE.createTopNodeReference();
                tnr.setOwnedChild(this.nodeB);
                tnr.setContainmentFeature(bOwnsB);
                this.mapping.getNodes().add((Object)tnr);
            }

            public LinkMapping getClassLink() {
                return null;
            }

            public Mapping getMapping() {
                return this.mapping;
            }

            public NodeMapping getNodeA() {
                return this.nodeA;
            }

            public NodeMapping getNodeB() {
                return this.nodeB;
            }

            public LinkMapping getReferenceLink() {
                return null;
            }
        };
    }

    public void testNodeAndLabelPairOutcome() {
        GenNode nodeA = this.getGenNodeA();
        LabelMappingTransformTest.assertFalse((boolean)nodeA.getLabels().isEmpty());
        GenChildNode childA = (GenChildNode)nodeA.getChildNodes().get(0);
        LabelMappingTransformTest.assertFalse((boolean)(childA instanceof GenChildLabelNode));
        LabelMappingTransformTest.assertFalse((boolean)childA.getLabels().isEmpty());
    }

    public void testSoleLabelNodeOutcome() {
        GenNode nodeB = this.getGenNodeB();
        LabelMappingTransformTest.assertTrue((boolean)nodeB.getLabels().isEmpty());
        GenChildNode childB = (GenChildNode)nodeB.getChildNodes().get(0);
        LabelMappingTransformTest.assertTrue((boolean)(childB instanceof GenChildLabelNode));
        LabelMappingTransformTest.assertTrue((boolean)childB.getLabels().isEmpty());
    }

    private static EReference newContainment(String name, EClass domainClass) {
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setName(name);
        ref.setContainment(true);
        ref.setUpperBound(-1);
        ref.setEType((EClassifier)domainClass);
        return ref;
    }

    private GenNode getGenNodeA() {
        GenNode rv = this.findTopNode(this.getNodeDomainElement(0));
        LabelMappingTransformTest.assertNotNull((Object)rv);
        return rv;
    }

    private GenNode getGenNodeB() {
        GenNode rv = this.findTopNode(this.getNodeDomainElement(1));
        LabelMappingTransformTest.assertNotNull((Object)rv);
        return rv;
    }

    private EClass getNodeDomainElement(int idx) {
        return ((TopNodeReference)this.getMapping().getNodes().get(idx)).getOwnedChild().getDomainMetaElement();
    }

    private GenNode findTopNode(EClass eClass) {
        for (GenTopLevelNode next : this.transformationResult.getDiagram().getTopLevelNodes()) {
            if (next.getDomainMetaClass().getEcoreClass() != eClass) continue;
            return next;
        }
        return null;
    }
}

