/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.draw2d.ui.internal.routers;

import junit.framework.TestCase;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ObliqueRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.RectilinearRouter;

public class AvoidObstructionsRoutingTest
extends TestCase {
    private ObliqueRouter obliqueRouter;
    private RectilinearRouter rectilinearRouter;

    public AvoidObstructionsRoutingTest(String name) {
        super(name);
    }

    protected ObliqueRouter getObliqueRouter() {
        if (this.obliqueRouter == null) {
            this.obliqueRouter = new ObliqueRouter();
        }
        return this.obliqueRouter;
    }

    protected RectilinearRouter getRectilinearRouter() {
        if (this.rectilinearRouter == null) {
            this.rectilinearRouter = new RectilinearRouter();
        }
        return this.rectilinearRouter;
    }

    protected void setUp() {
        try {
            super.setUp();
        }
        catch (Exception e) {
            AvoidObstructionsRoutingTest.fail((String)("The AvoidObstructionsRoutingTest.setUp method caught an exception - " + e));
        }
    }

    public boolean isConnectionObstructed(Connection conn, Rectangle obstruction) {
        PointList rectPoints = PointListUtilities.createPointsFromRect((Rectangle)obstruction);
        PointList intersections = new PointList();
        PointList distances = new PointList();
        return PointListUtilities.findIntersections((PointList)conn.getPoints(), (PointList)rectPoints, (PointList)intersections, (PointList)distances);
    }

    private void testSameContainerObstruction(boolean horizontal, BendpointConnectionRouter router) {
        RectangleFigure topNode = new RectangleFigure();
        topNode.setLayoutManager((LayoutManager)new FreeformLayout());
        topNode.setBounds(new Rectangle(0, 0, 400, 400));
        RectangleFigure node1 = new RectangleFigure();
        RectangleFigure node2 = new RectangleFigure();
        RectangleFigure node3 = new RectangleFigure();
        node1.setSize(40, 40);
        node1.setLocation(new Point(100, 100));
        node2.setSize(40, 40);
        node2.setLocation(horizontal ? new Point(200, 100) : new Point(100, 200));
        node3.setSize(40, 40);
        node3.setLocation(horizontal ? new Point(300, 100) : new Point(100, 300));
        topNode.add((IFigure)node1);
        topNode.add((IFigure)node2);
        topNode.add((IFigure)node3);
        this.verifyObstructionIsCleared((IFigure)topNode, (IFigure)node1, (IFigure)node3, (IFigure)node2, router);
    }

    private void testDifferentSourceContainerObstruction(boolean horizontal, BendpointConnectionRouter router) {
        RectangleFigure topNode = new RectangleFigure();
        topNode.setLayoutManager((LayoutManager)new FreeformLayout());
        topNode.setBounds(new Rectangle(0, 0, 400, 400));
        RectangleFigure subNode = new RectangleFigure(){

            protected boolean useLocalCoordinates() {
                return true;
            }
        };
        subNode.setSize(60, 60);
        subNode.setLayoutManager((LayoutManager)new XYLayout());
        topNode.add((IFigure)subNode);
        subNode.setLocation(new Point(100, 100));
        RectangleFigure node1 = new RectangleFigure();
        RectangleFigure node2 = new RectangleFigure();
        RectangleFigure node3 = new RectangleFigure();
        node1.setSize(40, 40);
        subNode.add((IFigure)node1);
        node1.setLocation(new Point(10, 10));
        node2.setSize(40, 40);
        node2.setLocation(horizontal ? new Point(200, 100) : new Point(100, 200));
        node3.setSize(40, 40);
        node3.setLocation(horizontal ? new Point(300, 100) : new Point(100, 300));
        topNode.add((IFigure)node2);
        topNode.add((IFigure)node3);
        this.verifyObstructionIsCleared((IFigure)topNode, (IFigure)node1, (IFigure)node3, (IFigure)node2, router);
    }

    private void testDifferentTargetContainerObstruction(boolean horizontal, BendpointConnectionRouter router) {
        RectangleFigure topNode = new RectangleFigure();
        topNode.setLayoutManager((LayoutManager)new FreeformLayout());
        topNode.setBounds(new Rectangle(0, 0, 400, 400));
        RectangleFigure node1 = new RectangleFigure();
        RectangleFigure node2 = new RectangleFigure();
        RectangleFigure node3 = new RectangleFigure();
        node1.setSize(40, 40);
        node1.setLocation(new Point(100, 100));
        node2.setSize(40, 40);
        node2.setLocation(horizontal ? new Point(200, 100) : new Point(100, 200));
        RectangleFigure subNode = new RectangleFigure(){

            protected boolean useLocalCoordinates() {
                return true;
            }
        };
        subNode.setSize(60, 60);
        subNode.setLayoutManager((LayoutManager)new XYLayout());
        topNode.add((IFigure)subNode);
        subNode.setLocation(horizontal ? new Point(300, 100) : new Point(100, 300));
        node3.setSize(40, 40);
        subNode.add((IFigure)node3);
        node3.setLocation(new Point(10, 10));
        topNode.add((IFigure)node1);
        topNode.add((IFigure)node2);
        this.verifyObstructionIsCleared((IFigure)topNode, (IFigure)node1, (IFigure)node3, (IFigure)node2, router);
    }

    private void testDifferentSourceAndTargetContainerObstruction(boolean horizontal, BendpointConnectionRouter router) {
        RectangleFigure topNode = new RectangleFigure();
        topNode.setLayoutManager((LayoutManager)new FreeformLayout());
        topNode.setBounds(new Rectangle(0, 0, 400, 400));
        RectangleFigure node1 = new RectangleFigure();
        RectangleFigure node2 = new RectangleFigure();
        RectangleFigure node3 = new RectangleFigure();
        RectangleFigure subNode = new RectangleFigure(){

            protected boolean useLocalCoordinates() {
                return true;
            }
        };
        subNode.setSize(60, 60);
        subNode.setLayoutManager((LayoutManager)new XYLayout());
        topNode.add((IFigure)subNode);
        subNode.setLocation(new Point(100, 100));
        node1.setSize(40, 40);
        subNode.add((IFigure)node1);
        node1.setLocation(new Point(10, 10));
        node2.setSize(40, 40);
        node2.setLocation(horizontal ? new Point(200, 100) : new Point(100, 200));
        RectangleFigure subNode2 = new RectangleFigure(){

            protected boolean useLocalCoordinates() {
                return true;
            }
        };
        subNode2.setSize(60, 60);
        subNode2.setLayoutManager((LayoutManager)new XYLayout());
        topNode.add((IFigure)subNode2);
        subNode2.setLocation(horizontal ? new Point(300, 100) : new Point(100, 300));
        node3.setSize(40, 40);
        subNode2.add((IFigure)node3);
        node3.setLocation(new Point(10, 10));
        topNode.add((IFigure)node2);
        this.verifyObstructionIsCleared((IFigure)topNode, (IFigure)node1, (IFigure)node3, (IFigure)node2, router);
    }

    public void testSameContainerObstruction_horizontal() {
        this.testSameContainerObstruction(true, (BendpointConnectionRouter)this.getObliqueRouter());
        this.testSameContainerObstruction(true, (BendpointConnectionRouter)this.getRectilinearRouter());
    }

    public void testDifferentSourceContainerObstruction_horizontal() {
        this.testDifferentSourceContainerObstruction(true, (BendpointConnectionRouter)this.getObliqueRouter());
        this.testDifferentSourceContainerObstruction(true, (BendpointConnectionRouter)this.getRectilinearRouter());
    }

    public void testDifferentTargetContainerObstruction_horizontal() {
        this.testDifferentTargetContainerObstruction(true, (BendpointConnectionRouter)this.getObliqueRouter());
        this.testDifferentTargetContainerObstruction(true, (BendpointConnectionRouter)this.getRectilinearRouter());
    }

    public void testDifferentSourceAndTargetContainerObstruction_horizontal() {
        this.testDifferentSourceAndTargetContainerObstruction(true, (BendpointConnectionRouter)this.getObliqueRouter());
        this.testDifferentSourceAndTargetContainerObstruction(true, (BendpointConnectionRouter)this.getRectilinearRouter());
    }

    public void testSameContainerObstruction_vertical() {
        this.testSameContainerObstruction(false, (BendpointConnectionRouter)this.getObliqueRouter());
        this.testSameContainerObstruction(false, (BendpointConnectionRouter)this.getRectilinearRouter());
    }

    public void testDifferentSourceContainerObstruction_vertical() {
        this.testDifferentSourceContainerObstruction(false, (BendpointConnectionRouter)this.getObliqueRouter());
        this.testDifferentSourceContainerObstruction(false, (BendpointConnectionRouter)this.getRectilinearRouter());
    }

    public void testDifferentTargetContainerObstruction_vertical() {
        this.testDifferentTargetContainerObstruction(false, (BendpointConnectionRouter)this.getObliqueRouter());
        this.testDifferentTargetContainerObstruction(false, (BendpointConnectionRouter)this.getRectilinearRouter());
    }

    public void testDifferentSourceAndTargetContainerObstruction_vertical() {
        this.testDifferentSourceAndTargetContainerObstruction(false, (BendpointConnectionRouter)this.getObliqueRouter());
        this.testDifferentSourceAndTargetContainerObstruction(false, (BendpointConnectionRouter)this.getRectilinearRouter());
    }

    private void verifyObstructionIsCleared(IFigure topNode, IFigure node1, IFigure node3, IFigure obstruction, BendpointConnectionRouter router) {
        PolylineConnectionEx conn1 = new PolylineConnectionEx();
        conn1.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor(node1));
        conn1.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor(node3));
        conn1.setConnectionRouter((ConnectionRouter)router);
        PointList points = new PointList();
        Point pt1 = node1.getBounds().getCenter();
        node1.translateToAbsolute((Translatable)pt1);
        conn1.translateToRelative((Translatable)pt1);
        points.addPoint(pt1);
        Point pt2 = node3.getBounds().getCenter();
        node3.translateToAbsolute((Translatable)pt2);
        conn1.translateToRelative((Translatable)pt2);
        points.addPoint(pt2);
        conn1.setPoints(points);
        AvoidObstructionsRoutingTest.assertTrue((boolean)this.isConnectionObstructed((Connection)conn1, obstruction.getBounds().getCopy()));
        conn1.setRoutingStyles(true, true);
        this.getObliqueRouter().route((Connection)conn1);
        AvoidObstructionsRoutingTest.assertFalse((boolean)this.isConnectionObstructed((Connection)conn1, obstruction.getBounds().getCopy()));
    }
}

