/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.type.baseimpl.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.expression.ExpressionFacade;

public class IntegerTypeTest
extends TestCase {
    private ExpressionFacade ef;

    protected void setUp() throws Exception {
        this.ef = new ExpressionFacade((ExecutionContext)new ExecutionContextImpl(null, new EPackage[0]));
    }

    public final void testUpTo1() {
        Map emptyMap = Collections.emptyMap();
        List r = (List)this.ef.evaluate("1.upTo(5)", emptyMap);
        ArrayList<Integer> c = new ArrayList<Integer>();
        int i = 1;
        while (i <= 5) {
            c.add(i);
            ++i;
        }
        IntegerTypeTest.assertEquals(c, (Object)r);
    }

    public void testComparisonOps() {
        Map emptyMap = Collections.emptyMap();
        IntegerTypeTest.assertTrue((boolean)((Boolean)this.ef.evaluate("1 > 0", emptyMap)));
        IntegerTypeTest.assertTrue((boolean)((Boolean)this.ef.evaluate("2 >= 2", emptyMap)));
        IntegerTypeTest.assertTrue((boolean)((Boolean)this.ef.evaluate("1 < 4", emptyMap)));
        IntegerTypeTest.assertTrue((boolean)((Boolean)this.ef.evaluate("1 <= 3", emptyMap)));
        IntegerTypeTest.assertTrue((boolean)((Boolean)this.ef.evaluate("1 != 2", emptyMap)));
        IntegerTypeTest.assertTrue((boolean)((Boolean)this.ef.evaluate("2 == 2", emptyMap)));
        IntegerTypeTest.assertFalse((boolean)((Boolean)this.ef.evaluate("1 < 0", emptyMap)));
        IntegerTypeTest.assertFalse((boolean)((Boolean)this.ef.evaluate("1 >= 2", emptyMap)));
        IntegerTypeTest.assertFalse((boolean)((Boolean)this.ef.evaluate("1 > 4", emptyMap)));
        IntegerTypeTest.assertFalse((boolean)((Boolean)this.ef.evaluate("3 <= 1", emptyMap)));
        IntegerTypeTest.assertFalse((boolean)((Boolean)this.ef.evaluate("2 != 2", emptyMap)));
        IntegerTypeTest.assertFalse((boolean)((Boolean)this.ef.evaluate("1 == 0", emptyMap)));
    }

    public void testCompareNonLiterals() {
        Map emptyMap = Collections.emptyMap();
        IntegerTypeTest.assertTrue((boolean)((Boolean)this.ef.evaluate("\"sdf \".trim().length() > 0", emptyMap)));
        IntegerTypeTest.assertTrue((boolean)((Boolean)this.ef.evaluate("\"sdf \".trim().length() == 3", emptyMap)));
        IntegerTypeTest.assertTrue((boolean)((Boolean)this.ef.evaluate("a.trim().length() == 3", Collections.singletonMap("a", "sdf "))));
        IntegerTypeTest.assertTrue((boolean)((Boolean)this.ef.evaluate("\" sdf\".trim().length() == b", Collections.singletonMap("b", 3))));
    }
}

