/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gef;

import java.util.Iterator;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.rt.GeneratedCanvasTest;
import org.eclipse.gmf.tests.setup.CompartmentsSessionSetup;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.RTSetup;
import org.eclipse.gmf.tests.setup.RTSource;
import org.eclipse.gmf.tests.setup.SessionSetup;

public abstract class DiagramTestBase
extends GeneratedCanvasTest {
    private EditPart myNodeEditPartA;
    private EditPart myNodeEditPartB;

    public DiagramTestBase(String name) {
        super(name);
    }

    protected final EditPart getNodeEditPartA() {
        return this.myNodeEditPartA;
    }

    protected final EditPart getNodeEditPartB() {
        return this.myNodeEditPartB;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.myNodeEditPartA = this.findEditPart((View)this.getCompartmentsRTSetup().getNodeA());
        this.myNodeEditPartB = this.findEditPart((View)this.getCompartmentsRTSetup().getNodeB());
    }

    protected RTSource createCanvasInstance() throws Exception {
        return new CompartmentsRTSetup().init(this.getSetup().getGenProject().getBundle(), this.getSetup().getGenModel());
    }

    protected SessionSetup createDefaultSetup() {
        return CompartmentsSessionSetup.newInstance();
    }

    protected final Node getNotation(EditPart editPart) {
        return (Node)editPart.getModel();
    }

    protected CompartmentsRTSetup getCompartmentsRTSetup() {
        return (CompartmentsRTSetup)this.getCanvasInstance();
    }

    protected static View findChildView(View parentView, GenCommonBase childType) {
        String notationType = String.valueOf(childType.getVisualID());
        Iterator children = parentView.getChildren().iterator();
        while (children.hasNext()) {
            View next = (View)children.next();
            if (!notationType.equals(next.getType())) continue;
            return next;
        }
        return null;
    }

    protected class CompartmentsRTSetup
    extends RTSetup {
        private Node myNotationCompartmentA;
        private Node myNotationCompartmentB;

        protected CompartmentsRTSetup() {
        }

        protected void initDiagramFileContents(RTSetup.DomainInstanceProducer instanceProducer, DiaGenSource genSource) {
            super.initDiagramFileContents(instanceProducer, genSource);
            this.myNotationCompartmentA = this.setupNotationCompartment(this.getNodeA(), genSource.getNodeA());
            this.myNotationCompartmentB = this.setupNotationCompartment(this.getNodeB(), genSource.getNodeB());
        }

        private Node setupNotationCompartment(Node notationParent, GenNode genParent) {
            Node notationCompartment = NotationFactory.eINSTANCE.createNode();
            GenCompartment genCompartment = (GenCompartment)genParent.getCompartments().get(0);
            notationCompartment.setType(String.valueOf(genCompartment.getVisualID()));
            notationParent.getTransientChildren().add((Object)notationCompartment);
            DiagramTestBase.assertTrue((boolean)notationParent.getChildren().contains((Object)notationCompartment));
            return notationCompartment;
        }

        public Node getNotationCompartmentA() {
            return this.myNotationCompartmentA;
        }

        public Node getNotationCompartmentB() {
            return this.myNotationCompartmentB;
        }
    }
}

