/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.gmf.codegen.gmfgen.ElementType;
import org.eclipse.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GMFGenPackage;
import org.eclipse.gmf.codegen.gmfgen.GenAuditContainer;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRule;
import org.eclipse.gmf.codegen.gmfgen.GenChildContainer;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenEditorView;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderContainer;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.MetamodelType;
import org.eclipse.gmf.codegen.gmfgen.Palette;
import org.eclipse.gmf.codegen.gmfgen.SpecializationType;
import org.eclipse.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.gmf.tests.ConfiguredTestCase;
import org.eclipse.jdt.core.JavaConventions;

public class HandcodedImplTest
extends ConfiguredTestCase {
    private GenDiagram myGenModel;

    public HandcodedImplTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.myGenModel = this.getSetup().getGenModel().getGenDiagram();
    }

    public void testUniqueIdentifier_IsUnique() {
        HashSet<String> allIds = new HashSet<String>(128);
        GenCommonBaseIterator it = new GenCommonBaseIterator(this.myGenModel);
        while (it.hasNext()) {
            GenCommonBase next = it.nextElement();
            HandcodedImplTest.assertFalse((String)"There should be no two same 'unique' identifiers in GMFGen", (boolean)allIds.contains(next.getUniqueIdentifier()));
            allIds.add(next.getUniqueIdentifier());
        }
        HandcodedImplTest.assertTrue((String)"Test is not valid unless few elements were checked", (allIds.size() > 1 ? 1 : 0) != 0);
        allIds.clear();
    }

    public void testUniqueIdentifier_IsConstant() {
        LinkedList<String> allIdsOrdered = new LinkedList<String>();
        GenCommonBaseIterator it = new GenCommonBaseIterator(this.myGenModel);
        while (it.hasNext()) {
            GenCommonBase next = it.nextElement();
            allIdsOrdered.add(next.getUniqueIdentifier());
        }
        HandcodedImplTest.assertTrue((String)"Test is not valid unless there are few elements to check", (allIdsOrdered.size() > 1 ? 1 : 0) != 0);
        Iterator itSaved = allIdsOrdered.iterator();
        GenCommonBaseIterator it2 = new GenCommonBaseIterator(this.myGenModel);
        while (it2.hasNext() && itSaved.hasNext()) {
            GenCommonBase next = it2.nextElement();
            String savedID = itSaved.next().toString();
            HandcodedImplTest.assertEquals((String)"Subsequent invocations of getUniqueIdentifier produce different results", (String)savedID, (String)next.getUniqueIdentifier());
        }
        HandcodedImplTest.assertEquals((String)"Lists are not equal in size", (boolean)itSaved.hasNext(), (boolean)it2.hasNext());
        allIdsOrdered.clear();
    }

    public void testGenEditorGenerator_DiagramFileExtension() {
        GenEditorGenerator generator = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        generator.setDomainFileExtension("AAA");
        generator.setDiagramFileExtension("BBB");
        HandcodedImplTest.assertEquals((String)"AAA", (String)generator.getDomainFileExtension());
        HandcodedImplTest.assertEquals((String)"BBB", (String)generator.getDiagramFileExtension());
        generator.setDomainFileExtension("AAA");
        generator.setDiagramFileExtension(null);
        HandcodedImplTest.assertNotNull((Object)generator.getDiagramFileExtension());
        HandcodedImplTest.assertTrue((generator.getDiagramFileExtension().length() != 0 ? 1 : 0) != 0);
        generator.setDomainFileExtension("AAA");
        generator.setDiagramFileExtension("");
        HandcodedImplTest.assertNotNull((Object)generator.getDiagramFileExtension());
        HandcodedImplTest.assertFalse((boolean)"".equals(generator.getDiagramFileExtension()));
    }

    public void testGenEditorGenerator_ModelId() {
        GenEditorGenerator generator = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        HandcodedImplTest.assertNotNull((Object)generator.getModelID());
        HandcodedImplTest.assertFalse((generator.getModelID().trim().length() == 0 ? 1 : 0) != 0);
        generator.setModelID("");
        HandcodedImplTest.assertNotNull((Object)generator.getModelID());
        HandcodedImplTest.assertFalse((generator.getModelID().trim().length() == 0 ? 1 : 0) != 0);
        generator.setModelID(" ");
        HandcodedImplTest.assertNotNull((Object)generator.getModelID());
        HandcodedImplTest.assertFalse((generator.getModelID().trim().length() == 0 ? 1 : 0) != 0);
        generator.setModelID("ABC");
        HandcodedImplTest.assertEquals((String)"ABC", (String)generator.getModelID());
        generator = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        GenModel mockGenModel = GenModelFactory.eINSTANCE.createGenModel();
        mockGenModel.setModelName("CBA");
        generator.setDomainGenModel(mockGenModel);
        HandcodedImplTest.assertEquals((String)"CBA", (String)generator.getModelID());
    }

    public void testGenPlugin_RequiredPluginIds() {
        String[] BUNDLE_VIEWMAPS_MANY = new String[]{"com.mycompany.viewmapsA", "com.mycompany.viewmapsB"};
        GenEditorGenerator mockGenerator = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        GenExpressionProviderContainer expressionProviderContainer = GMFGenFactory.eINSTANCE.createGenExpressionProviderContainer();
        mockGenerator.setExpressionProviders(expressionProviderContainer);
        GenExpressionInterpreter expressionProvider = GMFGenFactory.eINSTANCE.createGenExpressionInterpreter();
        expressionProviderContainer.getProviders().add((Object)expressionProvider);
        expressionProvider.getRequiredPluginIDs().add((Object)"com.mycompany.expressions");
        GenPlugin mockPlugin = GMFGenFactory.eINSTANCE.createGenPlugin();
        mockGenerator.setPlugin(mockPlugin);
        GenDiagram mockDiagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        mockGenerator.setDiagram(mockDiagram);
        GenTopLevelNode mockNodeA = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        mockDiagram.getTopLevelNodes().add((Object)mockNodeA);
        FigureViewmap mockViewmapA = GMFGenFactory.eINSTANCE.createFigureViewmap();
        mockViewmapA.getRequiredPluginIDs().add((Object)"com.mycompany.viewmapsC");
        mockNodeA.setViewmap((Viewmap)mockViewmapA);
        GenTopLevelNode mockNodeB = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        mockDiagram.getTopLevelNodes().add((Object)mockNodeB);
        FigureViewmap mockViewmapB = GMFGenFactory.eINSTANCE.createFigureViewmap();
        mockViewmapB.getRequiredPluginIDs().addAll(Arrays.asList(BUNDLE_VIEWMAPS_MANY));
        mockNodeB.setViewmap((Viewmap)mockViewmapB);
        EList allRequired = mockPlugin.getRequiredPluginIDs();
        HandcodedImplTest.assertTrue((boolean)allRequired.contains("com.mycompany.expressions"));
        HandcodedImplTest.assertTrue((boolean)allRequired.contains("com.mycompany.viewmapsC"));
        HandcodedImplTest.assertTrue((boolean)allRequired.containsAll(Arrays.asList(BUNDLE_VIEWMAPS_MANY)));
    }

    public void testCompartmentClassNamePrefix() {
        GenTopLevelNode n = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        GenCompartment c = GMFGenFactory.eINSTANCE.createGenCompartment();
        n.getCompartments().add((Object)c);
        IStatus s = JavaConventions.validateJavaTypeName((String)c.getClassNamePrefix());
        HandcodedImplTest.assertTrue((String)("Default prefix (no title set):" + s.getMessage()), (s.getSeverity() != 4 ? 1 : 0) != 0);
        c.setTitle("<>?#!. =\"'\n\t\\");
        s = JavaConventions.validateJavaTypeName((String)c.getClassNamePrefix());
        HandcodedImplTest.assertTrue((String)s.getMessage(), (s.getSeverity() != 4 ? 1 : 0) != 0);
    }

    public void testPackageNames() {
        GenDiagram genDiagram = this.myGenModel;
        HashSet<String> state = new HashSet<String>();
        this.checkPackageName(state, "PackageNames:editCommands", genDiagram.getEditCommandsPackageName());
        this.checkPackageName(state, "PackageNames:editHelpers", genDiagram.getEditHelpersPackageName());
        this.checkPackageName(state, "PackageNames:editParts", genDiagram.getEditPartsPackageName());
        this.checkPackageName(state, "PackageNames:editPolicies", genDiagram.getEditPoliciesPackageName());
        this.checkPackageName(state, "GenEditorView:packageName", genDiagram.getEditorGen().getEditor().getPackageName());
        this.checkPackageName(state, "PackageNames:providers", genDiagram.getProvidersPackageName());
        this.checkPackageName(state, "PackageNames:notationViewFactories", genDiagram.getNotationViewFactoriesPackageName());
        if (genDiagram.getEditorGen().getExpressionProviders() != null) {
            GenExpressionProviderContainer providers = genDiagram.getEditorGen().getExpressionProviders();
            this.checkPackageName(state, "GenExpressionProviderContainer:expressions", providers.getExpressionsPackageName());
        } else {
            state.add("GenExpressionProviderContainer:expressions");
        }
        Iterator classifiers = GMFGenPackage.eINSTANCE.getEClassifiers().iterator();
        while (classifiers.hasNext()) {
            Object next = classifiers.next();
            if (!(next instanceof EClass)) continue;
            this.checkPackageNamesCoverage(state, (EClass)next);
        }
    }

    public void testClassNames() {
        GenDiagram genDiagram = this.myGenModel;
        HashSet<String> state = new HashSet<String>();
        GenEditorView genEditor = this.myGenModel.getEditorGen().getEditor();
        this.checkClassName(state, "EditPartCandies:ReorientConnectionViewCommand", genDiagram.getReorientConnectionViewCommandClassName(), genDiagram.getReorientConnectionViewCommandQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:BaseEditHelper", genDiagram.getBaseEditHelperClassName(), genDiagram.getBaseEditHelperQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:EditPartFactory", genDiagram.getEditPartFactoryClassName(), genDiagram.getEditPartFactoryQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:BaseExternalNodeLabelEditPart", genDiagram.getBaseExternalNodeLabelEditPartClassName(), genDiagram.getBaseExternalNodeLabelEditPartQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:BaseItemSemanticEditPolicy", genDiagram.getBaseItemSemanticEditPolicyClassName(), genDiagram.getBaseItemSemanticEditPolicyQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:BaseGraphicalNodeEditPolicy", genDiagram.getBaseGraphicalNodeEditPolicyClassName(), genDiagram.getBaseGraphicalNodeEditPolicyQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:ReferenceConnectionEditPolicy", genDiagram.getReferenceConnectionEditPolicyClassName(), genDiagram.getReferenceConnectionEditPolicyQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:CanonicalEditPolicy", genDiagram.getCanonicalEditPolicyClassName(), genDiagram.getCanonicalEditPolicyQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:TextSelectionEditPolicy", genDiagram.getTextSelectionEditPolicyClassName(), genDiagram.getTextSelectionEditPolicyQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:TextNonResizableEditPolicy", genDiagram.getTextNonResizableEditPolicyClassName(), genDiagram.getTextNonResizableEditPolicyQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:ExternalNodeLabelHostLayoutEditPolicy", genDiagram.getExternalNodeLabelHostLayoutEditPolicyClassName(), genDiagram.getExternalNodeLabelHostLayoutEditPolicyQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:ElementTypes", genDiagram.getElementTypesClassName(), genDiagram.getElementTypesQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:NotationViewProvider", genDiagram.getNotationViewProviderClassName(), genDiagram.getNotationViewProviderQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:EditPartProvider", genDiagram.getEditPartProviderClassName(), genDiagram.getEditPartProviderQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:PaletteProvider", genDiagram.getPaletteProviderClassName(), genDiagram.getPaletteProviderQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:ModelingAssistantProvider", genDiagram.getModelingAssistantProviderClassName(), genDiagram.getModelingAssistantProviderQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:PropertyProvider", genDiagram.getPropertyProviderClassName(), genDiagram.getPropertyProviderQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:IconProvider", genDiagram.getIconProviderClassName(), genDiagram.getIconProviderQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:ParserProvider", genDiagram.getParserProviderClassName(), genDiagram.getParserProviderQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:AbstractParser", genDiagram.getAbstractParserClassName(), genDiagram.getAbstractParserQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:StructuralFeatureParser", genDiagram.getStructuralFeatureParserClassName(), genDiagram.getStructuralFeatureParserQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:StructuralFeaturesParser", genDiagram.getStructuralFeaturesParserClassName(), genDiagram.getStructuralFeaturesParserQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:ContributionItemProvider", genDiagram.getContributionItemProviderClassName(), genDiagram.getContributionItemProviderQualifiedClassName());
        this.checkClassName(state, "GenEditorView:ActionBarContributor", genEditor.getActionBarContributorClassName(), genEditor.getActionBarContributorQualifiedClassName());
        this.checkClassName(state, "EditorCandies:CreationWizard", genDiagram.getCreationWizardClassName(), genDiagram.getCreationWizardQualifiedClassName());
        this.checkClassName(state, "EditorCandies:CreationWizardPage", genDiagram.getCreationWizardPageClassName(), genDiagram.getCreationWizardPageQualifiedClassName());
        this.checkClassName(state, "EditorCandies:DiagramEditorUtil", genDiagram.getDiagramEditorUtilClassName(), genDiagram.getDiagramEditorUtilQualifiedClassName());
        this.checkClassName(state, "EditorCandies:DiagramFileCreator", genDiagram.getDiagramFileCreatorClassName(), genDiagram.getDiagramFileCreatorQualifiedClassName());
        this.checkClassName(state, "EditorCandies:DocumentProvider", genDiagram.getDocumentProviderClassName(), genDiagram.getDocumentProviderQualifiedClassName());
        this.checkClassName(state, "GenEditorView:className", genEditor.getClassName(), genEditor.getQualifiedClassName());
        this.checkClassName(state, "EditorCandies:InitDiagramFileAction", genDiagram.getInitDiagramFileActionClassName(), genDiagram.getInitDiagramFileActionQualifiedClassName());
        this.checkClassName(state, "EditorCandies:NewDiagramFileWizard", genDiagram.getNewDiagramFileWizardClassName(), genDiagram.getNewDiagramFileWizardQualifiedClassName());
        this.checkClassName(state, "EditorCandies:MatchingStrategy", genDiagram.getMatchingStrategyClassName(), genDiagram.getMatchingStrategyQualifiedClassName());
        this.checkClassName(state, "EditorCandies:PreferenceInitializer", genDiagram.getPreferenceInitializerClassName(), genDiagram.getPreferenceInitializerQualifiedClassName());
        this.checkClassName(state, "EditorCandies:VisualIDRegistry", genDiagram.getVisualIDRegistryClassName(), genDiagram.getVisualIDRegistryQualifiedClassName());
        this.checkClassName(state, "EditorCandies:LoadResourceAction", genDiagram.getLoadResourceActionClassName(), genDiagram.getLoadResourceActionQualifiedClassName());
        this.checkClassName(state, "LinkConstraints:LinkCreationConstraints", genDiagram.getLinkCreationConstraintsClassName(), genDiagram.getLinkCreationConstraintsQualifiedClassName());
        this.checkClassName(state, "Shortcuts:CreateShortcutAction", genDiagram.getCreateShortcutActionClassName(), genDiagram.getCreateShortcutActionQualifiedClassName());
        this.checkClassName(state, "Shortcuts:ShortcutsDecoratorProvider", genDiagram.getShortcutsDecoratorProviderClassName(), genDiagram.getShortcutsDecoratorProviderQualifiedClassName());
        this.checkClassName(state, "EditorCandies:ElementChooser", genDiagram.getElementChooserClassName(), genDiagram.getElementChooserQualifiedClassName());
        this.checkClassName(state, "BatchValidation:ValidationProvider", genDiagram.getValidationProviderClassName(), genDiagram.getValidationProviderQualifiedClassName());
        this.checkClassName(state, "BatchValidation:ValidationDecoratorProvider", genDiagram.getValidationDecoratorProviderClassName(), genDiagram.getValidationDecoratorProviderQualifedClassName());
        this.checkClassName(state, "BatchValidation:MarkerNavigationProvider", genDiagram.getMarkerNavigationProviderClassName(), genDiagram.getMarkerNavigationProviderQualifiedClassName());
        this.checkClassName(state, "BatchValidation:MetricProvider", genDiagram.getMetricProviderClassName(), genDiagram.getMetricProviderQualifiedClassName());
        if (genDiagram.getEditorGen().getExpressionProviders() != null) {
            GenExpressionProviderContainer providers = genDiagram.getEditorGen().getExpressionProviders();
            this.checkClassName(state, "GenExpressionProviderContainer:AbstractExpression", providers.getAbstractExpressionClassName(), providers.getAbstractExpressionQualifiedClassName());
        } else {
            state.add("GenExpressionProviderContainer:AbstractExpression");
        }
        Palette palette = genDiagram.getPalette();
        if (palette != null) {
            this.checkClassName(state, "Palette:Factory", palette.getFactoryClassName(), palette.getFactoryQualifiedClassName());
        } else {
            state.add("Palette:Factory");
        }
        GenPlugin genPlugin = genDiagram.getEditorGen().getPlugin();
        this.checkClassName(state, "GenPlugin:Activator", genPlugin.getActivatorClassName(), genPlugin.getActivatorQualifiedClassName());
        GenCommonBaseIterator entities = new GenCommonBaseIterator(genDiagram);
        while (entities.hasNext()) {
            GenCommonBase nextEntity = entities.nextElement();
            this.checkClassName(state, "GenCommonBase:EditPart", nextEntity.getEditPartClassName(), nextEntity.getEditPartQualifiedClassName());
            this.checkClassName(state, "GenCommonBase:ItemSemanticEditPolicy", nextEntity.getItemSemanticEditPolicyClassName(), nextEntity.getItemSemanticEditPolicyQualifiedClassName());
            this.checkClassName(state, "GenCommonBase:NotationViewFactory", nextEntity.getNotationViewFactoryClassName(), nextEntity.getNotationViewFactoryQualifiedClassName());
            this.checkEditSupport(state, nextEntity);
            if (nextEntity instanceof GenChildContainer) {
                GenChildContainer genContainer = (GenChildContainer)nextEntity;
                this.checkClassName(state, "GenChildContainer:CanonicalEditPolicy", genContainer.getCanonicalEditPolicyClassName(), genContainer.getCanonicalEditPolicyQualifiedClassName());
            }
            if (!(nextEntity instanceof GenNode)) continue;
            GenNode genNode = (GenNode)nextEntity;
            this.checkClassName(state, "GenNode:GraphicalNodeEditPolicy", genNode.getGraphicalNodeEditPolicyClassName(), genNode.getGraphicalNodeEditPolicyQualifiedClassName());
        }
        GenAuditContainer audits = genDiagram.getEditorGen().getAudits();
        if (audits != null && !audits.getAllAuditRules().isEmpty()) {
            HashSet<String> checkedContexts = new HashSet<String>();
            Iterator it = audits.getAllAuditRules().iterator();
            while (it.hasNext()) {
                GenAuditRule nextAudit = (GenAuditRule)it.next();
                if (!checkedContexts.contains(nextAudit.getContextSelectorQualifiedClassName())) {
                    this.checkClassName(state, "GenAuditRule:ContextSelector", nextAudit.getContextSelectorClassName(), nextAudit.getContextSelectorQualifiedClassName());
                    checkedContexts.add(nextAudit.getContextSelectorQualifiedClassName());
                }
                this.checkClassName(state, "GenAuditRule:ConstraintAdapter", nextAudit.getConstraintAdapterClassName(), nextAudit.getConstraintAdapterQualifiedClassName());
            }
        } else {
            state.add("GenAuditRule:ContextSelector");
        }
        state.add("GenCommonBase:EditPart");
        state.add("GenCommonBase:ItemSemanticEditPolicy");
        state.add("GenCommonBase:NotationViewFactory");
        state.add("GenContainer:CanonicalEditPolicy");
        state.add("GenNode:GraphicalNodeEditPolicy");
        state.add("MetamodelType:EditHelper");
        state.add("SpecializationType:EditHelperAdvice");
        state.add("ElementType:EditHelper");
        state.add("FigureViewmap:Figure");
        state.add("ExternalLabel:TextEditPart");
        state.add("ExternalLabel:TextNotationViewFactory");
        Iterator classifiers = GMFGenPackage.eINSTANCE.getEClassifiers().iterator();
        while (classifiers.hasNext()) {
            Object next = classifiers.next();
            if (!(next instanceof EClass)) continue;
            this.checkClassNamesCoverage(state, (EClass)next);
        }
    }

    protected void checkEditSupport(Set state, GenCommonBase diagramElement) {
        ElementType genType = diagramElement.getElementType();
        if (genType instanceof MetamodelType) {
            MetamodelType metamodelType = (MetamodelType)genType;
            this.checkClassName(state, "MetamodelType:EditHelper", metamodelType.getEditHelperClassName(), metamodelType.getEditHelperQualifiedClassName());
        } else if (genType instanceof SpecializationType) {
            SpecializationType specializationType = (SpecializationType)genType;
            this.checkClassName(state, "SpecializationType:EditHelperAdvice", specializationType.getEditHelperAdviceClassName(), specializationType.getEditHelperAdviceQualifiedClassName());
        }
    }

    protected void checkPackageName(Set state, String id, String packageName) {
        IStatus s = JavaConventions.validatePackageName((String)packageName);
        HandcodedImplTest.assertTrue((String)(String.valueOf(id) + " package name is not valid : " + s.getMessage()), (s.getSeverity() != 4 ? 1 : 0) != 0);
        state.add(packageName);
        state.add(id);
    }

    protected void checkClassName(Set state, String id, String simpleClassName, String qualifiedClassName) {
        IStatus s = JavaConventions.validateJavaTypeName((String)simpleClassName);
        HandcodedImplTest.assertTrue((String)(String.valueOf(id) + " simple class name is not valid : " + s.getMessage()), (s.getSeverity() != 4 ? 1 : 0) != 0);
        s = JavaConventions.validateJavaTypeName((String)qualifiedClassName);
        HandcodedImplTest.assertTrue((String)(String.valueOf(id) + " qualified class name is not valid : " + s.getMessage()), (s.getSeverity() != 4 ? 1 : 0) != 0);
        HandcodedImplTest.assertTrue((String)(String.valueOf(id) + " simple class name does not match the qualified one : '" + simpleClassName + "', '" + qualifiedClassName + "'"), (boolean)qualifiedClassName.endsWith(String.valueOf('.') + simpleClassName));
        HandcodedImplTest.assertFalse((String)(String.valueOf(qualifiedClassName) + " is not unique"), (boolean)state.contains(qualifiedClassName));
        state.add(qualifiedClassName);
        state.add(id);
    }

    protected void checkPackageNamesCoverage(Set state, EClass eClass) {
        Iterator attributes = eClass.getEAttributes().iterator();
        while (attributes.hasNext()) {
            EAttribute attribute = (EAttribute)attributes.next();
            if (!attribute.getName().endsWith("PackageName") || attribute.getName().length() <= "PackageName".length()) continue;
            String packageName = attribute.getName();
            packageName = packageName.substring(0, packageName.length() - "PackageName".length());
            String id = String.valueOf(eClass.getName()) + ':' + packageName;
            HandcodedImplTest.assertTrue((String)(String.valueOf(id) + " package name is not checked"), (boolean)state.contains(id));
        }
    }

    protected void checkClassNamesCoverage(Set state, EClass eClass) {
        String id;
        String className;
        Iterator attributes = eClass.getEAttributes().iterator();
        while (attributes.hasNext()) {
            EAttribute attribute = (EAttribute)attributes.next();
            if (attribute.getName().endsWith("QualifiedClassName") && attribute.getName().length() > "QualifiedClassName".length() || !attribute.getName().endsWith("ClassName") || attribute.getName().length() <= "ClassName".length()) continue;
            className = attribute.getName();
            className = className.substring(0, className.length() - "ClassName".length());
            className = String.valueOf(Character.toUpperCase(className.charAt(0))) + className.substring(1);
            id = String.valueOf(eClass.getName()) + ':' + className;
            HandcodedImplTest.assertTrue((String)(String.valueOf(id) + " simple class name is not checked"), (boolean)state.contains(id));
        }
        Iterator operations = eClass.getEOperations().iterator();
        while (operations.hasNext()) {
            EOperation operation = (EOperation)operations.next();
            if (!operation.getName().startsWith("get") || !operation.getName().endsWith("QualifiedClassName") || operation.getName().length() <= "get".length() + "QualifiedClassName".length()) continue;
            className = operation.getName();
            className = className.substring("get".length(), className.length() - "QualifiedClassName".length());
            id = String.valueOf(eClass.getName()) + ':' + className;
            HandcodedImplTest.assertTrue((String)(String.valueOf(id) + " qualified class name is not checked"), (boolean)state.contains(id));
        }
    }

    private static class GenCommonBaseIterator
    implements Iterator {
        private GenCommonBase nextBase;
        private Iterator wrappedIterator;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.tests.gen.HandcodedImplTest");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public GenCommonBaseIterator(GenDiagram genDiagram) {
            if (!$assertionsDisabled && genDiagram == null) {
                throw new AssertionError();
            }
            this.nextBase = genDiagram;
            this.wrappedIterator = genDiagram.eAllContents();
        }

        public boolean hasNext() {
            return this.nextBase != null;
        }

        public GenCommonBase nextElement() {
            if (this.nextBase == null) {
                throw new NoSuchElementException();
            }
            GenCommonBase rv = this.nextBase;
            this.advance();
            return rv;
        }

        public Object next() {
            return this.nextElement();
        }

        private void advance() {
            this.nextBase = null;
            while (this.wrappedIterator.hasNext()) {
                Object next = this.wrappedIterator.next();
                if (!(next instanceof GenCommonBase)) continue;
                this.nextBase = (GenCommonBase)next;
                break;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

