/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.util;

import java.lang.ref.WeakReference;
import java.util.StringTokenizer;
import org.eclipse.internal.xtend.util.StringCache;
import org.eclipse.internal.xtend.util.WeakInterningHashSet;

public final class QualifiedName {
    protected final int hash;
    protected String[] segments;
    protected WeakReference<String> toString;
    protected static final QualifiedNameCache CACHE = new QualifiedNameCache();

    protected QualifiedName(String[] segments, int hashCode) {
        this.segments = segments;
        this.hash = hashCode;
    }

    public QualifiedName append(QualifiedName t) {
        return CACHE.intern(this.segments, t.segments);
    }

    public String toString() {
        String result;
        int segmentCount = this.segments.length;
        switch (segmentCount) {
            case 0: {
                return "";
            }
            case 1: {
                return this.segments[0];
            }
        }
        String string = result = this.toString != null ? (String)this.toString.get() : null;
        if (result == null) {
            StringBuilder builder = new StringBuilder(segmentCount * 8);
            String[] stringArray = this.segments;
            int n = this.segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                builder.append(segment);
                ++n2;
            }
            result = builder.toString();
            this.toString = new WeakReference<String>(result);
        }
        return result;
    }

    public String toString(String delimiter) {
        int segmentCount = this.segments.length;
        if (segmentCount < 2) {
            return this.toString();
        }
        StringBuilder builder = new StringBuilder(segmentCount * (8 + delimiter.length()));
        String[] stringArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (segment != this.segments[0]) {
                builder.append(delimiter);
            }
            builder.append(segment);
            ++n2;
        }
        return builder.toString();
    }

    public int getSegmentCount() {
        return this.segments.length;
    }

    public String getSegment(int index) {
        return this.segments[index];
    }

    public String getLastSegment() {
        return this.segments[this.segments.length - 1];
    }

    public String getFirstSegment() {
        return this.segments[0];
    }

    public int hashCode() {
        return this.hash;
    }

    public static QualifiedName create(String[] segments) {
        return CACHE.intern(segments);
    }

    public static QualifiedName create(String segment) {
        return CACHE.intern(segment);
    }

    public static QualifiedName create(String segments, String delimiter) {
        StringTokenizer st = new StringTokenizer(segments, delimiter);
        int size = st.countTokens();
        if (size == 1) {
            return CACHE.intern(segments);
        }
        String[] segmented = new String[size];
        int i = 0;
        while (i < size) {
            segmented[i] = st.nextToken();
            ++i;
        }
        return CACHE.intern(segmented);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QualifiedNameCache
    extends WeakInterningHashSet<QualifiedName> {
        private static final long serialVersionUID = 1L;

        private QualifiedNameCache() {
        }

        protected int hashCode(int initialHashCode, String[] segments) {
            int length = segments.length;
            if (length == 0) {
                return 0;
            }
            int hashCode = initialHashCode;
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                hashCode = 31 * hashCode + segment.hashCode();
                ++n2;
            }
            return hashCode;
        }

        @Override
        protected boolean equals(Object object, Object otherObject) {
            return object == otherObject;
        }

        protected int hashCode(String[] segments) {
            return this.hashCode(1, segments);
        }

        protected int hashCode(String[] segments1, String[] segments2) {
            return this.hashCode(this.hashCode(segments1), segments2);
        }

        public QualifiedName intern(String[] segments1, String[] segments2) {
            QualifiedName qualifiedName;
            int length1 = segments1.length;
            int length2 = segments2.length;
            int length = length1 + length2;
            int hashCode = this.hashCode(segments1, segments2);
            WeakInterningHashSet.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                block6: {
                    qualifiedName = (QualifiedName)entry.get();
                    if (qualifiedName != null) {
                        String[] segments = qualifiedName.segments;
                        if (length != segments.length) break;
                        int i = 0;
                        while (i < length1) {
                            if (segments[i] == segments1[i]) {
                                ++i;
                                continue;
                            }
                            break block6;
                        }
                        int j = 0;
                        while (j < length2) {
                            if (segments[i] == segments2[j]) {
                                ++i;
                                ++j;
                                continue;
                            }
                            break block6;
                        }
                        return qualifiedName;
                    }
                }
                entry = entry.getNextEntry();
            }
            String[] newSegments = new String[length];
            System.arraycopy(segments1, 0, newSegments, 0, length1);
            System.arraycopy(segments2, 0, newSegments, length1, length2);
            qualifiedName = new QualifiedName(newSegments, hashCode);
            this.addEntry(this.createEntry(qualifiedName, hashCode));
            return qualifiedName;
        }

        @Override
        public QualifiedName intern(String segment) {
            int hashCode = 31 + segment.hashCode();
            WeakInterningHashSet.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                String[] segments;
                QualifiedName qualifiedName = (QualifiedName)entry.get();
                if (qualifiedName != null && (segments = qualifiedName.segments).length == 1 && segments[0].equals(segment)) {
                    return qualifiedName;
                }
                entry = entry.getNextEntry();
            }
            QualifiedName qualifiedName = new QualifiedName(new String[]{StringCache.get(segment)}, hashCode);
            this.addEntry(this.createEntry(qualifiedName, hashCode));
            return qualifiedName;
        }

        @Override
        public QualifiedName intern(String[] segments) {
            int hashCode = this.hashCode(segments);
            WeakInterningHashSet.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                QualifiedName qualifiedName = (QualifiedName)entry.get();
                if (qualifiedName != null && this.equals(qualifiedName.segments, segments)) {
                    return qualifiedName;
                }
                entry = entry.getNextEntry();
            }
            int i = 0;
            while (i < segments.length) {
                segments[i] = StringCache.get(segments[i]);
                ++i;
            }
            QualifiedName qualifiedName = new QualifiedName(segments, hashCode);
            this.addEntry(this.createEntry(qualifiedName, hashCode));
            return qualifiedName;
        }

        private boolean equals(String[] segments1, String[] segments2) {
            int length = segments1.length;
            if (segments2.length != length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (!segments1[i].equals(segments2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

