/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EValidatorRegistryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.internal.options.CommonOptions;
import org.eclipse.ocl.ecore.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.tests.AbstractValidateTests;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.evaluation.AbstractModelManager;
import org.eclipse.ocl.pivot.internal.evaluation.AbstractExecutor;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorManager;
import org.eclipse.ocl.pivot.internal.resource.OCLASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ProjectMap;
import org.eclipse.ocl.pivot.internal.validation.EcoreOCLEValidator;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.utilities.AbstractEnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.ocl.xtext.completeocl.utilities.CompleteOCLLoader;
import org.eclipse.ocl.xtext.completeocl.validation.CompleteOCLEObjectValidator;
import org.eclipse.ocl.xtext.oclinecore.validation.OCLinEcoreEObjectValidator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.junit.After;
import org.junit.Before;

public class ValidateTests
extends AbstractValidateTests {
    public static @NonNull List<Diagnostic> assertEcoreOCLValidationDiagnostics(@Nullable OCL ocl, @NonNull String prefix, @NonNull Resource resource, String ... messages) {
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        if (ocl != null) {
            validationContext.put(OCL.class, ocl);
        }
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (EObject eObject : resource.getContents()) {
            EValidatorRegistryImpl registry = new EValidatorRegistryImpl();
            registry.put((Object)EcorePackage.eINSTANCE, (Object)EcoreOCLEValidator.INSTANCE);
            Diagnostician dignostician = new Diagnostician((EValidator.Registry)registry);
            Diagnostic diagnostic = dignostician.validate(eObject, validationContext);
            diagnostics.addAll(diagnostic.getChildren());
        }
        return ValidateTests.assertDiagnostics(prefix, resource, diagnostics, messages);
    }

    protected @NonNull TestOCL createTestOCL() {
        return new TestOCL(this.getTestFileSystem(), this.getTestPackageName(), this.getTestName(), OCL.NO_PROJECTS, null);
    }

    public Resource doLoadEcore(@NonNull OCL ocl, @NonNull URI ecoreURI) throws IOException {
        Resource ecoreResource = ocl.getResourceSet().getResource(ecoreURI, true);
        return ecoreResource;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testValidate_Bug366229_oclinecore() throws IOException, InterruptedException {
        OCL ocl1 = this.createOCL();
        Resource ecoreResource = this.doLoadOCLinEcore(ocl1, ValidateTests.getTestModelURI("models/oclinecore/Bug366229.oclinecore"));
        ThreadLocalExecutor.resetEnvironmentFactory();
        OCL ocl2 = this.createOCL();
        ocl2.getResourceSet().getResources().add((Object)ecoreResource);
        EPackage overloadsPackage = (EPackage)ecoreResource.getContents().get(0);
        EObject testInstance = this.eCreate(overloadsPackage, "SubClass");
        EValidator.Registry.INSTANCE.put((Object)overloadsPackage, (Object)EObjectValidator.INSTANCE);
        ValidateTests.checkValidationDiagnostics(testInstance, 4, new String[0]);
        ocl1.dispose();
        ocl2.dispose();
    }

    public void testValidate_Bug418551_ecore() throws IOException, InterruptedException {
        String targetRelease = System.getProperty("targetRelease");
        if (targetRelease != null) {
            System.err.println(String.valueOf(this.getTestName()) + " skipped for " + targetRelease + " - message text changes");
            return;
        }
        OCL ocl = this.createOCL();
        Resource ecoreResource = this.doLoadEcore(ocl, ValidateTests.getTestModelURI("models/ecore/Bug418551.ecore"));
        EPackage temp = (EPackage)ecoreResource.getContents().get(0);
        EClass tester = (EClass)temp.getEClassifier("Tester");
        EOperation badOp = (EOperation)NameUtil.getENamedElement((Iterable)tester.getEOperations(), (String)"badOp");
        String[] messages1 = new String[]{StringUtil.bind((String)"Missing ''constraints'' annotation entry for {0} ''{1}::{2}''", (Object[])new Object[]{"\u00abinvariant\u00bb", LabelUtil.getLabel((Object)tester), "extraInvariant"}), StringUtil.bind((String)"Extra ''constraints'' annotation entry for {0} ''{1}::{2}''", (Object[])new Object[]{"\u00abinvariant\u00bb", LabelUtil.getLabel((Object)tester), "missingInvariant"}), StringUtil.bind((String)"Incompatible type ''{0}'' for {1} ''{2}''", (Object[])new Object[]{"String", "\u00abbody\u00bb", LabelUtil.getLabel((Object)badOp)}), StringUtil.bind((String)"Incompatible type ''{0}'' for {1} ''{2}''", (Object[])new Object[]{"Integer", "\u00abprecondition\u00bb", LabelUtil.getLabel((Object)badOp)}), StringUtil.bind((String)"Incompatible type ''{0}'' for {1} ''{2}''", (Object[])new Object[]{"Integer", "\u00abpostcondition\u00bb", LabelUtil.getLabel((Object)badOp)}), StringUtil.bind((String)"Incompatible type ''{0}'' for {1} ''{2}''", (Object[])new Object[]{"Boolean", "\u00abinitializer\u00bb", LabelUtil.getLabel((Object)tester.getEStructuralFeature("badType"))}), StringUtil.bind((String)"Missing ''derivation'' or ''initial'' detail for ''{0}''", (Object[])new Object[]{LabelUtil.getLabel((Object)tester.getEStructuralFeature("badDetailName"))}), StringUtil.bind((String)"Both ''derivation'' and ''initial'' detail for ''{0}''", (Object[])new Object[]{LabelUtil.getLabel((Object)tester.getEStructuralFeature("derivationAndInitial"))})};
        ValidateTests.checkValidationDiagnostics((EObject)temp, 4, messages1);
        String[] messages2 = new String[]{StringUtil.bind((String)"Missing ''{0}'' delegate for ''{1}''", (Object[])new Object[]{"invocationDelegates", LabelUtil.getLabel((Object)temp)}), StringUtil.bind((String)"Missing ''{0}'' delegate for ''{1}''", (Object[])new Object[]{"settingDelegates", LabelUtil.getLabel((Object)temp)}), StringUtil.bind((String)"Missing ''{0}'' delegate for ''{1}''", (Object[])new Object[]{"validationDelegates", LabelUtil.getLabel((Object)temp)}), StringUtil.bind((String)"Missing ''constraints'' annotation entry for {0} ''{1}::{2}''", (Object[])new Object[]{"\u00abinvariant\u00bb", LabelUtil.getLabel((Object)tester), "extraInvariant"}), StringUtil.bind((String)"Extra ''constraints'' annotation entry for {0} ''{1}::{2}''", (Object[])new Object[]{"\u00abinvariant\u00bb", LabelUtil.getLabel((Object)tester), "missingInvariant"}), StringUtil.bind((String)"Incompatible type ''{0}'' for {1} ''{2}''", (Object[])new Object[]{"String", "\u00abbody\u00bb", LabelUtil.getLabel((Object)badOp)}), StringUtil.bind((String)"Incompatible type ''{0}'' for {1} ''{2}''", (Object[])new Object[]{"Integer", "\u00abprecondition\u00bb", LabelUtil.getLabel((Object)badOp)}), StringUtil.bind((String)"Incompatible type ''{0}'' for {1} ''{2}''", (Object[])new Object[]{"Integer", "\u00abpostcondition\u00bb", LabelUtil.getLabel((Object)badOp)}), StringUtil.bind((String)"Incompatible type ''{0}'' for {1} ''{2}''", (Object[])new Object[]{"Boolean", "\u00abinitializer\u00bb", LabelUtil.getLabel((Object)tester.getEStructuralFeature("badType"))}), StringUtil.bind((String)"Missing ''derivation'' or ''initial'' detail for ''{0}''", (Object[])new Object[]{LabelUtil.getLabel((Object)tester.getEStructuralFeature("badDetailName"))}), StringUtil.bind((String)"Both ''derivation'' and ''initial'' detail for ''{0}''", (Object[])new Object[]{LabelUtil.getLabel((Object)tester.getEStructuralFeature("derivationAndInitial"))})};
        ValidateTests.assertEcoreOCLValidationDiagnostics(ocl, "Ecore Load", ecoreResource, messages2);
        ocl.dispose();
    }

    public void testValidate_Bug418552_oclinecore() throws IOException, InterruptedException {
        String testDocument = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\n\npackage temp : Test = 'http://www.eclipse.org/mdt/ocl/oclinecore/tutorial'\n{\n\tclass Tester\n\t{\n\t\tattribute total : ecore::EDoubleObject { derived volatile }\n\t\t{\n\t\t\tderivation: true;\n\t\t}\n\t}\n}\n";
        this.createFile("Bug418552.oclinecore", testDocument);
        OCL ocl1 = this.createOCL();
        @NonNull List<Diagnostic> diagnostics = this.doValidateOCLinEcore(ocl1, "Bug418552", ValidateTests.getMessages(StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Property::CompatibleDefaultExpression", "temp::Tester::total"})));
        Object property = diagnostics.get(0).getData().get(0);
        assert (property != null);
        ValidateTests.assertEquals((Object)PivotPackage.Literals.PROPERTY, (Object)((EObject)property).eClass());
        ModelElementCS csElement = ElementUtil.getCsElement((Element)((Element)property));
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        assert (node != null);
        ValidateTests.assertEquals((int)7, (int)node.getStartLine());
        ValidateTests.assertEquals((int)10, (int)node.getEndLine());
        ocl1.dispose();
    }

    public void testValidate_Bug543173_ecore() throws IOException, InterruptedException {
        OCL ocl = OCL.newInstance((ProjectManager)ValidateTests.getProjectMap());
        URI ecoreURI = ValidateTests.getTestModelURI("models/ecore//Bug543173.ecore");
        Resource ecoreResource = ocl.getResourceSet().getResource(ecoreURI, true);
        assert (ecoreResource != null);
        ValidateTests.assertEcoreOCLValidationDiagnostics(ocl, "Ecore Load", ecoreResource, new String[0]);
        ocl.dispose();
    }

    public void testValidate_Bug543187_ecore() throws IOException, InterruptedException {
        OCL ocl = OCL.newInstance((ProjectManager)ValidateTests.getProjectMap());
        URI ecoreURI = ValidateTests.getTestModelURI("models/ecore/Bug543187.ecore");
        Resource ecoreResource = ocl.getResourceSet().getResource(ecoreURI, true);
        assert (ecoreResource != null);
        ValidateTests.assertEcoreOCLValidationDiagnostics(ocl, "Ecore Load", ecoreResource, new String[0]);
        ocl.dispose();
    }

    public void testValidate_Bug543187_xmi() throws IOException, InterruptedException {
        int oldAbstractEnvironmentFactory_CONSTRUCTION_COUNT = AbstractEnvironmentFactory.CONSTRUCTION_COUNT;
        int oldAbstractModelManager_CONSTRUCTION_COUNT = AbstractModelManager.CONSTRUCTION_COUNT;
        int oldExecutorManager_CONSTRUCTION_COUNT = ExecutorManager.CONSTRUCTION_COUNT;
        int oldAbstractExecutor_CONSTRUCTION_COUNT = AbstractExecutor.CONSTRUCTION_COUNT;
        OCL ocl = OCL.newInstance((ProjectManager)ValidateTests.getProjectMap());
        ResourceSet resourceSet = ocl.getResourceSet();
        URI xmiURI = ValidateTests.getTestModelURI("models/ecore/Bug543187.xmi");
        Resource resource = resourceSet.getResource(xmiURI, true);
        ValidateTests.assertNoValidationErrors("Validating", (Resource)ClassUtil.nonNullState((Object)resource));
        ValidateTests.assertEquals((String)"AbstractEnvironmentFactory.CONSTRUCTION_COUNT", (int)1, (int)(AbstractEnvironmentFactory.CONSTRUCTION_COUNT - oldAbstractEnvironmentFactory_CONSTRUCTION_COUNT));
        ValidateTests.assertEquals((String)"AbstractModelManager.CONSTRUCTION_COUNT", (int)1, (int)(AbstractModelManager.CONSTRUCTION_COUNT - oldAbstractModelManager_CONSTRUCTION_COUNT));
        ValidateTests.assertEquals((String)"ExecutorManager.CONSTRUCTION_COUNT", (int)1, (int)(ExecutorManager.CONSTRUCTION_COUNT - oldExecutorManager_CONSTRUCTION_COUNT));
        ValidateTests.assertEquals((String)"AbstractExecutor.CONSTRUCTION_COUNT", (int)8, (int)(AbstractExecutor.CONSTRUCTION_COUNT - oldAbstractExecutor_CONSTRUCTION_COUNT));
        ocl.dispose();
    }

    public void testValidate_IsPrimeNumber_completeocl() throws IOException, InterruptedException, InvocationTargetException {
        TestOCL ocl = this.createTestOCL();
        String xmiDocument = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\"\n    name=\"IsPrimeNumber\" nsURI=\"isPrimeNumber\" nsPrefix=\"isp\">\n</ecore:EPackage>\n\n";
        TestFile xmiTestFile = this.createFile("IsPrimeNumber.xmi", xmiDocument);
        URI xmiURI = xmiTestFile.getFileURI();
        Resource ecoreResource = ocl.getResourceSet().getResource(xmiURI, true);
        EPackage testPackage = (EPackage)ClassUtil.nonNullState((Object)((EPackage)ecoreResource.getContents().get(0)));
        String oclTestDocument = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/'\n\npackage ecore\n\ncontext EModelElement\ndef: isPrimeNumber(candidatePrime : Integer) : Boolean =\n\t(0 < candidatePrime)\n\t  and ((candidatePrime < 4)\n\t\t  or ((candidatePrime.div(2) * 2) <> candidatePrime)\n\t\t\t and isPrimeNumber(candidatePrime, 3))\n\ndef: isPrimeNumber(candidatePrime : Integer, candidateFactor:Integer) : Boolean =\n\t((candidatePrime.div(candidateFactor) * candidateFactor) <> candidatePrime)\n\t  and ((candidateFactor*candidateFactor > candidatePrime)\n\t\t  or isPrimeNumber(candidatePrime, candidateFactor+2))\nendpackage\n";
        TestFile oclTestFile = this.createFile("IsPrimeNumber.ocl", oclTestDocument);
        URI oclURI = oclTestFile.getFileURI();
        ocl.getResourceSet().getResource(oclURI, true);
        try {
            ValidateTests.checkValidationDiagnostics((EObject)testPackage, 2, new String[0]);
            ocl.assertQueryFalse(testPackage, "isPrimeNumber(0)");
            ocl.assertQueryTrue(testPackage, "isPrimeNumber(1)");
            ocl.assertQueryTrue(testPackage, "isPrimeNumber(2)");
            ocl.assertQueryTrue(testPackage, "isPrimeNumber(3)");
            ocl.assertQueryFalse(testPackage, "isPrimeNumber(4)");
            ocl.assertQueryTrue(testPackage, "isPrimeNumber(5)");
            ocl.assertQueryFalse(testPackage, "isPrimeNumber(15)");
            ocl.assertQueryFalse(testPackage, "isPrimeNumber(16)");
            ocl.assertQueryTrue(testPackage, "isPrimeNumber(17)");
            ocl.assertQueryFalse(testPackage, "isPrimeNumber(18)");
            ocl.assertQueryTrue(testPackage, "isPrimeNumber(19)");
            ocl.assertQueryFalse(testPackage, "isPrimeNumber(20)");
            ocl.assertQueryFalse(testPackage, "isPrimeNumber(96)");
            ocl.assertQueryTrue(testPackage, "isPrimeNumber(97)");
            ocl.assertQueryFalse(testPackage, "isPrimeNumber(98)");
            ocl.assertQueryFalse(testPackage, "isPrimeNumber(996)");
            ocl.assertQueryTrue(testPackage, "isPrimeNumber(997)");
            ocl.assertQueryFalse(testPackage, "isPrimeNumber(998)");
            ocl.assertQueryFalse(testPackage, "isPrimeNumber(10005)");
            ocl.assertQueryFalse(testPackage, "isPrimeNumber(10006)");
            ocl.assertQueryTrue(testPackage, "isPrimeNumber(10007)");
            ocl.assertQueryFalse(testPackage, "isPrimeNumber(10008)");
            ocl.assertQueryTrue(testPackage, "isPrimeNumber(10009)");
            ocl.assertQueryFalse(testPackage, "isPrimeNumber(10010)");
            ocl.assertQueryFalse(testPackage, "isPrimeNumber(10011)");
        }
        finally {
            ocl.dispose();
        }
    }

    public void testValidate_IsPrimeNumber_completeocl_Integer() throws IOException, InterruptedException, InvocationTargetException {
        TestOCL ocl = this.createTestOCL();
        String oclTestDocument = "package ocl\n\ncontext Integer\ndef: isPrimeNumber() : Boolean =\n\t(0 < self)\n\t  and ((self < 4)\n\t\t  or ((self.div(2) * 2) <> self)\n\t\t\t and self.isPrimeNumber(3))\n\ndef: isPrimeNumber(candidateFactor:Integer) : Boolean =\n\t((self.div(candidateFactor) * candidateFactor) <> self)\n\t  and ((candidateFactor*candidateFactor > self)\n\t\t  or self.isPrimeNumber(candidateFactor+2))\nendpackage\n";
        TestFile oclTestFile = this.createFile("IsPrimeNumber.ocl", oclTestDocument);
        URI oclURI = oclTestFile.getFileURI();
        CSResource csResource = (CSResource)ocl.getResourceSet().getResource(oclURI, true);
        assert (csResource != null);
        ValidateTests.assertNoResourceErrors("Load", (Resource)csResource);
        try {
            ocl.assertQueryFalse(null, "0.isPrimeNumber()");
            ocl.assertQueryTrue(null, "1.isPrimeNumber()");
            ocl.assertQueryTrue(null, "2.isPrimeNumber()");
            ocl.assertQueryTrue(null, "3.isPrimeNumber()");
            ocl.assertQueryFalse(null, "4.isPrimeNumber()");
            ocl.assertQueryTrue(null, "5.isPrimeNumber()");
            ocl.assertQueryFalse(null, "15.isPrimeNumber()");
            ocl.assertQueryFalse(null, "16.isPrimeNumber()");
            ocl.assertQueryTrue(null, "17.isPrimeNumber()");
            ocl.assertQueryFalse(null, "18.isPrimeNumber()");
            ocl.assertQueryTrue(null, "19.isPrimeNumber()");
            ocl.assertQueryFalse(null, "20.isPrimeNumber()");
            ocl.assertQueryFalse(null, "96.isPrimeNumber()");
            ocl.assertQueryTrue(null, "97.isPrimeNumber()");
            ocl.assertQueryFalse(null, "98.isPrimeNumber()");
            ocl.assertQueryFalse(null, "996.isPrimeNumber()");
            ocl.assertQueryTrue(null, "997.isPrimeNumber()");
            ocl.assertQueryFalse(null, "998.isPrimeNumber()");
            ocl.assertQueryFalse(null, "10005.isPrimeNumber()");
            ocl.assertQueryFalse(null, "10006.isPrimeNumber()");
            ocl.assertQueryTrue(null, "10007.isPrimeNumber()");
            ocl.assertQueryFalse(null, "10008.isPrimeNumber()");
            ocl.assertQueryTrue(null, "10009.isPrimeNumber()");
            ocl.assertQueryFalse(null, "10010.isPrimeNumber()");
            ocl.assertQueryFalse(null, "10011.isPrimeNumber()");
        }
        finally {
            ocl.dispose();
        }
    }

    public void testValidate_IsPrimeNumber_oclinecore() throws IOException, InterruptedException, InvocationTargetException {
        TestOCL ocl = this.createTestOCL();
        String testDocument = "package isPrimeNumber : isp = 'isPrimeNumber'\n{\n\tclass MyNumber\n\t{\n\t\toperation isPrimeNumber(candidatePrime : Integer) : Boolean {\n\t\t\tbody: (0 < candidatePrime)\n\t\t\t\t  and ((candidatePrime < 4)\n\t\t\t\t\t  or ((candidatePrime.div(2) * 2) <> candidatePrime)\n\t\t\t\t\t\t and isPrimeNumber(candidatePrime, 3));\n\t\t}\n\n\t\toperation isPrimeNumber(candidatePrime : Integer, candidateFactor:Integer) : Boolean {\n\t\t\tbody: ((candidatePrime.div(candidateFactor) * candidateFactor) <> candidatePrime)\n\t\t\t\t  and ((candidateFactor*candidateFactor > candidatePrime)\n\t\t\t\t\t  or isPrimeNumber(candidatePrime, candidateFactor+2));\n\t\t}\n\t}\n}\n";
        TestFile testFile = this.createFile("IsPrimeNumber.oclinecore", testDocument);
        URI inputURI = testFile.getFileURI();
        URI ecoreURI = this.getTestFile("IsPrimeNumber.ecore").getFileURI();
        Resource ecoreResource = this.doLoadOCLinEcore((OCL)ocl, inputURI, ecoreURI);
        EPackage validatePackage = (EPackage)ClassUtil.nonNullState((Object)((EPackage)ecoreResource.getContents().get(0)));
        try {
            EObject testInstance = this.eCreate(validatePackage, "MyNumber");
            ValidateTests.checkValidationDiagnostics(testInstance, 2, new String[0]);
            ocl.assertQueryFalse(testInstance, "isPrimeNumber(0)");
            ocl.assertQueryTrue(testInstance, "isPrimeNumber(1)");
            ocl.assertQueryTrue(testInstance, "isPrimeNumber(2)");
            ocl.assertQueryTrue(testInstance, "isPrimeNumber(3)");
            ocl.assertQueryFalse(testInstance, "isPrimeNumber(4)");
            ocl.assertQueryTrue(testInstance, "isPrimeNumber(5)");
            ocl.assertQueryFalse(testInstance, "isPrimeNumber(15)");
            ocl.assertQueryFalse(testInstance, "isPrimeNumber(16)");
            ocl.assertQueryTrue(testInstance, "isPrimeNumber(17)");
            ocl.assertQueryFalse(testInstance, "isPrimeNumber(18)");
            ocl.assertQueryTrue(testInstance, "isPrimeNumber(19)");
            ocl.assertQueryFalse(testInstance, "isPrimeNumber(20)");
            ocl.assertQueryFalse(testInstance, "isPrimeNumber(96)");
            ocl.assertQueryTrue(testInstance, "isPrimeNumber(97)");
            ocl.assertQueryFalse(testInstance, "isPrimeNumber(98)");
            ocl.assertQueryFalse(testInstance, "isPrimeNumber(996)");
            ocl.assertQueryTrue(testInstance, "isPrimeNumber(997)");
            ocl.assertQueryFalse(testInstance, "isPrimeNumber(998)");
            ocl.assertQueryFalse(testInstance, "isPrimeNumber(10005)");
            ocl.assertQueryFalse(testInstance, "isPrimeNumber(10006)");
            ocl.assertQueryTrue(testInstance, "isPrimeNumber(10007)");
            ocl.assertQueryFalse(testInstance, "isPrimeNumber(10008)");
            ocl.assertQueryTrue(testInstance, "isPrimeNumber(10009)");
            ocl.assertQueryFalse(testInstance, "isPrimeNumber(10010)");
            ocl.assertQueryFalse(testInstance, "isPrimeNumber(10011)");
        }
        finally {
            ocl.dispose();
            EValidator.Registry.INSTANCE.remove((Object)validatePackage);
        }
    }

    public void testValidate_Pivot_ecore() throws IOException, InterruptedException {
        OCL ocl = OCL.newInstance((ProjectManager)ValidateTests.getProjectMap());
        URI ecoreURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.pivot/model/Pivot.ecore", (boolean)true);
        Resource ecoreResource = ocl.getResourceSet().getResource(ecoreURI, true);
        assert (ecoreResource != null);
        ValidateTests.assertEcoreOCLValidationDiagnostics(ocl, "Ecore Load", ecoreResource, new String[0]);
        ocl.dispose();
    }

    public void testValidate_OCL_2_5_oclas() throws IOException, InterruptedException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        ValidateTests.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
        Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)"org.eclipse.ocl.pivot/model-gen/OCL-2.5.oclas", (boolean)true), true);
        ValidateTests.assertNoValidationErrors("Validating", (Resource)ClassUtil.nonNullState((Object)resource));
    }

    public void testValidate_Pivot_oclas() throws IOException, InterruptedException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        ValidateTests.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
        OCLASResourceFactory.getInstance().configure((ResourceSet)resourceSet);
        Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)"org.eclipse.ocl.pivot/model-gen/Pivot.oclas", (boolean)true), true);
        ValidateTests.assertNoValidationErrors("Validating", (Resource)ClassUtil.nonNullState((Object)resource));
    }

    public void testValidate_Validate_completeocl() throws IOException, InterruptedException {
        OCL ocl1 = this.createOCL();
        URI inputURI = this.getTestFile("Validate.oclinecore", ocl1, ValidateTests.getTestModelURI("models/oclinecore/Validate.oclinecore")).getFileURI();
        URI ecoreURI = this.getTestFile("Validate.ecore").getFileURI();
        Resource ecoreResource1 = this.doLoadOCLinEcore(ocl1, inputURI, ecoreURI);
        EPackage validatePackage1 = (EPackage)ClassUtil.nonNullState((Object)((EPackage)ecoreResource1.getContents().get(0)));
        ThreadLocalExecutor.resetEnvironmentFactory();
        OCL ocl2 = this.createOCL();
        Resource ecoreResource2 = this.doLoadOCLinEcore(ocl2, inputURI, ecoreURI);
        EPackage validatePackage2 = (EPackage)ClassUtil.nonNullState((Object)((EPackage)ecoreResource2.getContents().get(0)));
        ThreadLocalExecutor.resetEnvironmentFactory();
        OCL ocl0 = this.createOCL();
        URI oclURI = this.getTestFile("Validate.ocl", ocl0, ValidateTests.getTestModelURI("models/oclinecore/Validate.ocl")).getFileURI();
        CompleteOCLEObjectValidator completeOCLEObjectValidator = new CompleteOCLEObjectValidator(validatePackage1, oclURI, ocl0.getEnvironmentFactory());
        EValidator.Registry.INSTANCE.put((Object)validatePackage1, (Object)completeOCLEObjectValidator);
        try {
            EObject testInstance1 = this.eCreate(validatePackage1, "Level3");
            EObject testInstance2 = this.eCreate(validatePackage2, "Level3");
            String template = PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_;
            ThreadLocalExecutor.resetEnvironmentFactory();
            this.eSet(testInstance1, "ref", "xx");
            this.eSet(testInstance1, "l1", "xx");
            this.eSet(testInstance1, "l2a", "xx");
            this.eSet(testInstance1, "l2b", "xx");
            this.eSet(testInstance1, "l3", "xx");
            this.eSet(testInstance2, "ref", "yy");
            this.eSet(testInstance2, "l1", "yy");
            this.eSet(testInstance2, "l2a", "yy");
            this.eSet(testInstance2, "l2b", "yy");
            this.eSet(testInstance2, "l3", "yy");
            ValidateTests.checkValidationDiagnostics(testInstance1, 2, new String[0]);
            ValidateTests.checkValidationDiagnostics(testInstance2, 2, new String[0]);
            ThreadLocalExecutor.resetEnvironmentFactory();
            this.eSet(testInstance1, "ref", "xxx");
            this.eSet(testInstance1, "l1", "xxx");
            this.eSet(testInstance1, "l2a", "xxx");
            this.eSet(testInstance1, "l2b", "xxx");
            this.eSet(testInstance1, "l3", "xxx");
            this.eSet(testInstance2, "ref", "yyy");
            this.eSet(testInstance2, "l1", "yyy");
            this.eSet(testInstance2, "l2a", "yyy");
            this.eSet(testInstance2, "l2b", "yyy");
            this.eSet(testInstance2, "l3", "yyy");
            String objectLabel = LabelUtil.getLabel((Object)testInstance1);
            ValidateTests.checkValidationDiagnostics(testInstance1, 2, StringUtil.bind((String)template, (Object[])new Object[]{"Level1::V1", objectLabel}), StringUtil.bind((String)template, (Object[])new Object[]{"Level2a::V2a", objectLabel}), StringUtil.bind((String)template, (Object[])new Object[]{"Level2b::V2b", objectLabel}), StringUtil.bind((String)template, (Object[])new Object[]{"Level3::V3", objectLabel}));
            ValidateTests.checkValidationDiagnostics(testInstance2, 2, new String[0]);
            ThreadLocalExecutor.resetEnvironmentFactory();
            this.eSet(testInstance1, "ref", "ok");
            this.eSet(testInstance1, "l1", "ok");
            this.eSet(testInstance1, "l2a", "bad");
            this.eSet(testInstance1, "l2b", "ok");
            this.eSet(testInstance1, "l3", "ok");
            this.eSet(testInstance2, "ref", "ok");
            this.eSet(testInstance2, "l1", "ok");
            this.eSet(testInstance2, "l2a", "bad");
            this.eSet(testInstance2, "l2b", "ok");
            this.eSet(testInstance2, "l3", "ok");
            objectLabel = LabelUtil.getLabel((Object)testInstance1);
            ValidateTests.checkValidationDiagnostics(testInstance1, 2, StringUtil.bind((String)template, (Object[])new Object[]{"Level2a::L2a", objectLabel}), StringUtil.bind((String)template, (Object[])new Object[]{"Level2a::V2a", objectLabel}));
            objectLabel = LabelUtil.getLabel((Object)testInstance2);
            ValidateTests.checkValidationDiagnostics(testInstance2, 4, StringUtil.bind((String)"The ''{0}'' constraint is violated on ''{1}''", (Object[])new Object[]{"L2a", "Level3 ok", objectLabel}));
        }
        finally {
            ocl0.dispose();
            ocl1.dispose();
            ocl2.dispose();
            EValidator.Registry.INSTANCE.remove((Object)validatePackage1);
        }
    }

    public void testValidate_Validate_completeocl_loadresource() throws IOException, InterruptedException {
        OCL ocl = this.createOCL();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initialize((ResourceSet)resourceSet, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        URI ecoreURI = ValidateTests.getTestModelURI("models/documentation/OCLinEcoreTutorial.ecore");
        URI xmiURI = ValidateTests.getTestModelURI("models/documentation/OCLinEcoreTutorial.xmi");
        String testDocument = "import '" + ecoreURI.toString() + "'\n" + "package tutorial\n" + "context Book\n" + "inv ExactlyOneCopy: copies=1\n" + "endpackage\n";
        TestFile testFile = this.createFile("ExtraOCLinEcoreTutorial.ocl", testDocument);
        Resource resource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(xmiURI, true));
        ValidateTests.assertValidationDiagnostics("Without Complete OCL", resource, ValidateTests.getMessages(StringUtil.bind((String)"The ''{0}'' constraint is violated on ''{1}''", (Object[])new Object[]{"SufficientCopies", "Library lib::Book b2"}), StringUtil.bind((String)"The ''{0}'' constraint is violated on ''{1}''", (Object[])new Object[]{"AtMostTwoLoans", "Library lib::Member m3"}), StringUtil.bind((String)"The ''{0}'' constraint is violated on ''{1}''", (Object[])new Object[]{"UniqueLoans", "Library lib::Member m3"})));
        CompleteOCLLoader helper = new CompleteOCLLoader(ocl.getEnvironmentFactory()){

            protected boolean error(@NonNull String primaryMessage, @Nullable String detailMessage) {
                TestCase.fail((String)(String.valueOf(primaryMessage) + "\n\t" + detailMessage));
                return false;
            }
        };
        ValidateTests.assertTrue((boolean)helper.loadMetamodels());
        ValidateTests.assertTrue((boolean)helper.loadDocument(testFile.getFileURI()));
        helper.installPackages();
        ValidateTests.assertValidationDiagnostics("Without Complete OCL", resource, ValidateTests.getMessages(StringUtil.bind((String)"The ''{0}'' constraint is violated on ''{1}''", (Object[])new Object[]{"SufficientCopies", "Library lib::Book b2"}), StringUtil.bind((String)"The ''{0}'' constraint is violated on ''{1}''", (Object[])new Object[]{"AtMostTwoLoans", "Library lib::Member m3"}), StringUtil.bind((String)"The ''{0}'' constraint is violated on ''{1}''", (Object[])new Object[]{"UniqueLoans", "Library lib::Member m3"}), StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Book::ExactlyOneCopy", "Library lib::Book b2"})));
        helper.dispose();
        ocl.dispose();
    }

    public void testValidate_Validate_completeocl_Bug422583() throws IOException, InterruptedException {
        UMLStandaloneSetup.init();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        OCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        ProjectMap.initializeURIResourceMap((ResourceSet)resourceSet);
        Map uriMap = resourceSet.getURIConverter().getURIMap();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            uriMap.putAll(EcorePlugin.computePlatformURIMap((boolean)false));
        }
        UML2AS.initialize((ResourceSet)resourceSet);
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initialize((ResourceSet)resourceSet, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        URI umlURI = ValidateTests.getTestModelURI("models/uml/Names.uml");
        String testDocument = "import uml : 'http://www.eclipse.org/uml2/5.0.0/UML#/'\npackage uml\n  context Element\n  def: alwaysTrue() : Boolean = true\n  def: rootFalse() : Boolean = false\n  inv IsElement: self.alwaysTrue()\n  context Classifier\n  def: rootFalse() : Boolean = true\n  def: leafFalse() : Boolean = true\n  inv IsClassifier: self.alwaysTrue()\n  inv IsClassifierWrtLeaf: self.leafFalse()\n  context Class\n  def: leafFalse() : Boolean = false\n  inv IsClass: self.alwaysTrue()\n  inv IsClassWrtRoot: self.rootFalse()\n  inv IsClassWrtLeaf: self.leafFalse()\nendpackage\n";
        TestFile testFile = this.createFile("Bug422583.ocl", testDocument);
        Resource resource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(umlURI, true));
        Class uNamed = null;
        TreeIterator tit = resource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof Class) || !"UNamed".equals(((Class)eObject).getName())) continue;
            uNamed = (Class)eObject;
            break;
        }
        assert (uNamed != null);
        ValidateTests.assertValidationDiagnostics("Without Complete OCL", resource, NO_MESSAGES);
        CompleteOCLLoader helper = new CompleteOCLLoader(ocl.getEnvironmentFactory()){

            protected boolean error(@NonNull String primaryMessage, @Nullable String detailMessage) {
                TestCase.fail((String)(String.valueOf(primaryMessage) + "\n\t" + detailMessage));
                return false;
            }
        };
        ValidateTests.assertTrue((boolean)helper.loadMetamodels());
        ValidateTests.assertTrue((boolean)helper.loadDocument(testFile.getFileURI()));
        helper.installPackages();
        String objectLabel1 = LabelUtil.getLabel((Object)uNamed);
        ValidateTests.assertValidationDiagnostics("Without Complete OCL", resource, ValidateTests.getMessages(StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Classifier::IsClassifierWrtLeaf", objectLabel1}), StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Class::IsClassWrtLeaf", objectLabel1})));
        helper.dispose();
        ocl.dispose();
    }

    public void testValidate_Validate_oclinecore() throws IOException, InterruptedException {
        OCL ocl1 = this.createOCL();
        Resource ecoreResource = this.doLoadOCLinEcore(ocl1, ValidateTests.getTestModelURI("models/oclinecore/Validate.oclinecore"));
        ocl1.getEnvironmentFactory().adapt((Notifier)ecoreResource.getResourceSet());
        EPackage validatePackage = (EPackage)ecoreResource.getContents().get(0);
        EObject testInstance = this.eCreate(validatePackage, "Level3");
        this.eSet(testInstance, "ref", "ref");
        this.eSet(testInstance, "l1", "l1");
        this.eSet(testInstance, "l2a", "l2a");
        this.eSet(testInstance, "l2b", "l2b");
        this.eSet(testInstance, "l3", "l3");
        String objectLabel = LabelUtil.getLabel((Object)testInstance);
        ThreadLocalExecutor.resetEnvironmentFactory();
        EValidator.Registry.INSTANCE.put((Object)validatePackage, (Object)EObjectValidator.INSTANCE);
        try {
            String template = EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic");
            ValidateTests.checkValidationDiagnostics(testInstance, 4, StringUtil.bind((String)template, (Object[])new Object[]{"L1", objectLabel}), StringUtil.bind((String)template, (Object[])new Object[]{"L2a", objectLabel}), StringUtil.bind((String)template, (Object[])new Object[]{"L3", objectLabel}));
            EValidator.Registry.INSTANCE.put((Object)validatePackage, (Object)new OCLinEcoreEObjectValidator());
            template = PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_;
            ValidateTests.checkValidationDiagnostics(testInstance, 2, StringUtil.bind((String)template, (Object[])new Object[]{"Level1::L1", objectLabel}), StringUtil.bind((String)template, (Object[])new Object[]{"Level2a::L2a", objectLabel}), StringUtil.bind((String)template, (Object[])new Object[]{"Level3::L3", objectLabel}));
            this.eSet(testInstance, "ref", "ok");
            this.eSet(testInstance, "l1", "ok");
            this.eSet(testInstance, "l2a", "ok");
            this.eSet(testInstance, "l2b", "ok");
            this.eSet(testInstance, "l3", "ok");
            objectLabel = LabelUtil.getLabel((Object)testInstance);
            ValidateTests.checkValidationDiagnostics(testInstance, 2, new String[0]);
            this.eSet(testInstance, "ref", "ok");
            this.eSet(testInstance, "l1", "bad");
            this.eSet(testInstance, "l2a", "ok");
            this.eSet(testInstance, "l2b", "ok");
            this.eSet(testInstance, "l3", "ok");
            objectLabel = LabelUtil.getLabel((Object)testInstance);
            ValidateTests.checkValidationDiagnostics(testInstance, 2, StringUtil.bind((String)template, (Object[])new Object[]{"Level1::L1", objectLabel}));
        }
        finally {
            ocl1.dispose();
            EValidator.Registry.INSTANCE.remove((Object)validatePackage);
        }
    }
}

