/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ElementExtension;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Stereotype;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.internal.library.CompositionProperty;
import org.eclipse.ocl.pivot.internal.library.ConstrainedProperty;
import org.eclipse.ocl.pivot.internal.library.ImplicitNonCompositionProperty;
import org.eclipse.ocl.pivot.internal.library.StaticProperty;
import org.eclipse.ocl.pivot.internal.library.TuplePartProperty;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.Technology;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.library.LibraryProperty;
import org.eclipse.ocl.pivot.library.UnsupportedOperation;
import org.eclipse.ocl.pivot.resource.ASResource;

public class ImplementationManager {
    private static final Logger logger = Logger.getLogger(ImplementationManager.class);
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    protected final @NonNull Technology technology;
    private final @NonNull PivotMetamodelManager metamodelManager;
    private List<@NonNull ClassLoader> classLoaders = null;

    public ImplementationManager(@NonNull EnvironmentFactoryInternal environmentFactory) {
        this.environmentFactory = environmentFactory;
        this.technology = environmentFactory.getTechnology();
        this.metamodelManager = environmentFactory.getMetamodelManager();
    }

    public void addClassLoader(@NonNull ClassLoader classLoader) {
        List<ClassLoader> classLoaders = this.getClassLoaders();
        if (!classLoaders.contains(classLoader)) {
            classLoaders.add(classLoader);
        }
    }

    public @NonNull List<@NonNull ClassLoader> getClassLoaders() {
        List<@NonNull ClassLoader> classLoaders2 = this.classLoaders;
        if (classLoaders2 == null) {
            classLoaders2 = this.classLoaders = new ArrayList<ClassLoader>();
            ClassLoader classLoader = this.metamodelManager.getClass().getClassLoader();
            assert (classLoader != null);
            classLoaders2.add(classLoader);
        }
        return classLoaders2;
    }

    public @NonNull LibraryProperty getPropertyImplementation(@Nullable Element asNavigationExp, @Nullable Object sourceValue, @NonNull Property property) {
        LibraryFeature implementation = property.getImplementation();
        String implementationClassName = property.getImplementationClass();
        if (!(implementationClassName == null || implementation != null && implementation.getClass().getName().equals(implementationClassName))) {
            try {
                implementation = this.loadImplementation(property);
                if (implementation instanceof LibraryProperty) {
                    return (LibraryProperty)implementation;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to load implementation of '" + property + "'"), (Throwable)e);
            }
            return UnsupportedOperation.INSTANCE;
        }
        Type type = property.getType();
        if (type instanceof Stereotype && property.getName().startsWith("extension_")) {
            return this.technology.createExtensionPropertyImplementation(this.environmentFactory, property);
        }
        ExpressionInOCL specification = this.metamodelManager.getDefaultExpression(property);
        if (property.isIsDerived() && specification != null) {
            return new ConstrainedProperty(property);
        }
        Property opposite = property.getOpposite();
        if (opposite != null && opposite.isIsComposite()) {
            if (property.eContainer() instanceof Stereotype) {
                return this.technology.createBasePropertyImplementation(this.environmentFactory, property);
            }
            if (type != null) {
                ASResource asResource;
                EReference eReference;
                Resource resource;
                EObject eTarget = opposite.getESObject();
                if (eTarget instanceof EReference) {
                    return new CompositionProperty((EReference)eTarget, opposite.getPropertyId());
                }
                if (eTarget != null && (resource = opposite.eResource()) instanceof ASResource && (eReference = (asResource = (ASResource)resource).getASResourceFactory().getEReference(asResource, eTarget)) != null) {
                    return new CompositionProperty(eReference, opposite.getPropertyId());
                }
            }
        }
        if (property.isIsImplicit()) {
            return new ImplicitNonCompositionProperty(property);
        }
        if (property.getOwningClass() instanceof TupleType) {
            TupleType tupleType = (TupleType)property.getOwningClass();
            String name = property.getName();
            assert (name != null);
            TuplePartId tuplePartId = tupleType.getTypeId().getPartId(name);
            assert (tuplePartId != null);
            return new TuplePartProperty(tuplePartId);
        }
        if (property.isIsStatic()) {
            return new StaticProperty(property);
        }
        if (property.getOwningClass() instanceof ElementExtension || property.getOwningClass() instanceof Stereotype) {
            return this.technology.createStereotypePropertyImplementation(this.environmentFactory, property);
        }
        return this.technology.createExplicitNavigationPropertyImplementation(this.environmentFactory, asNavigationExp, sourceValue, property);
    }

    public void dispose() {
        this.classLoaders = null;
    }

    public @Nullable LibraryFeature loadImplementation(@NonNull Feature feature) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        String implementationClassName;
        LibraryFeature implementation = feature.getImplementation();
        if (implementation == null && (implementationClassName = feature.getImplementationClass()) != null) {
            Class<?> theClass = null;
            ClassLoader featureClassLoader = feature.getClass().getClassLoader();
            if (featureClassLoader != null) {
                this.addClassLoader(featureClassLoader);
            }
            ClassNotFoundException e = null;
            for (ClassLoader classLoader : this.getClassLoaders()) {
                try {
                    theClass = classLoader.loadClass(implementationClassName);
                    e = null;
                    break;
                }
                catch (ClassNotFoundException e1) {
                    if (e != null) continue;
                    e = e1;
                }
            }
            if (e != null) {
                throw e;
            }
            if (theClass != null) {
                Field field = theClass.getField("INSTANCE");
                implementation = (LibraryFeature)field.get(null);
            }
        }
        return implementation;
    }
}

