/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.logical;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.library.AbstractSimpleBinaryOperation;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;

public class BooleanImpliesOperation2
extends AbstractSimpleBinaryOperation {
    public static final @NonNull BooleanImpliesOperation2 INSTANCE = new BooleanImpliesOperation2();

    @Override
    public @Nullable Object dispatch(@NonNull Executor executor, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        if (sourceValue == Boolean.FALSE) {
            return TRUE_VALUE;
        }
        Boolean sourceBoolean = ValueUtil.asBoolean(sourceValue);
        OCLExpression argument = PivotUtil.getOwnedArgument(callExp, 0);
        Object argumentValue = executor.evaluate(argument);
        Boolean argBoolean = ValueUtil.asBoolean(argumentValue);
        return this.evaluate(sourceBoolean, argBoolean);
    }

    @Override
    public @NonNull Boolean evaluate(@Nullable Object left, @Nullable Object right) {
        if (left == Boolean.FALSE || right == Boolean.TRUE) {
            return TRUE_VALUE;
        }
        return FALSE_VALUE;
    }
}

