/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.plugin.builder;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.emf.helpers.ProjectDependencyHelper;
import org.eclipse.papyrus.toolsmiths.plugin.builder.Activator;
import org.eclipse.papyrus.toolsmiths.plugin.builder.Messages;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PapyrusPluginBuilder;

public abstract class AbstractPapyrusBuilder {
    public static final String PLUGIN_PROBLEM = "org.eclipse.papyrus.toolsmiths.plugin.builder.problem";
    public static final String MODEL_PROBLEM = "org.eclipse.papyrus.toolsmiths.plugin.builder.diagnostic";
    private ProjectDependencyHelper DEPENDENCY_HELPER = ProjectDependencyHelper.INSTANCE;
    private final String defaultMarkerType;

    public AbstractPapyrusBuilder(String defaultMarkerType) {
        this.defaultMarkerType = defaultMarkerType;
    }

    public AbstractPapyrusBuilder() {
        this(PLUGIN_PROBLEM);
    }

    protected String getDefaultMarkerType() {
        return this.defaultMarkerType;
    }

    public abstract IProject[] build(IProject var1, PapyrusPluginBuilder var2, int var3, Map<String, String> var4, IProgressMonitor var5) throws CoreException;

    public void clean(IProgressMonitor monitor, IProject iProject) throws CoreException {
        iProject.deleteMarkers(this.getDefaultMarkerType(), true, 2);
    }

    protected IMarker createErrorMarker(IResource res, String message) {
        IMarker marker = null;
        try {
            marker = res.createMarker(this.getDefaultMarkerType());
            marker.setAttribute("message", (Object)(Messages.AbstractPapyrusBuilder_PapyrusBuilder + message));
            marker.setAttribute("severity", 2);
            marker.setAttribute("code", 10000);
            marker.setAttribute("sourceId", (Object)"org.eclipse.papyrus.toolsmiths.plugin.builder");
            marker.setAttribute("id", 7500);
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        return marker;
    }

    protected Collection<String> getAllAvailableDependencies(IProject project) {
        return this.DEPENDENCY_HELPER.getAllAvailableDependencies(project.getName());
    }
}

