/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.launching;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.m2m.atl.adt.debug.AtlDebugPlugin;
import org.eclipse.m2m.atl.adt.debug.Messages;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class AtlLauncherTools {
    public static final String ATLVM = "ATL VM";
    public static final String ATLFILENAME = "ATL File Name";
    public static final String AllowInterModelReferences = "AllowInterModelReferences";
    public static final String PROJECTNAME = "Project Name";
    public static final String OUTPUT = "Output";
    public static final String INPUT = "Input";
    public static final String NULLPARAMETER = "<null>";
    public static final String PATH = "Path";
    public static final String HOST = "Host";
    public static final String PORT = "Port";
    public static final String LIBS = "Libs";
    public static final String MODEL_OUTPUT = "MODELOUTPUT";
    public static final String MODEL_INPUT = "MODELINPUT";
    public static final String METAMODEL_OUTPUT = "METAMODELOUTPUT";
    public static final String METAMODEL_INPUT = "METAMODELINPUT";
    public static final String SUPERIMPOSE = "Superimpose";
    public static final String MODELTYPE = "ModelType";
    public static final String INJECTOR = "Injector";
    public static final String EXTRACTOR = "Extractor";
    public static final String MODELHANDLER = "Model Handler";
    public static final String MODEDEBUG = "Mode Debug";
    public static final String MODELCHOICETABNAME = Messages.getString("AtlLauncherTools.MODELCHOICE");
    public static final String ADVANCEDTABNAME = Messages.getString("AtlLauncherTools.ADVANCED");
    public static final String REMOTEATLNAME = Messages.getString("AtlLauncherTools.ATLCONFIGURATION");
    public static final String PATHICONATL = "icons/atllogo_icon.gif";
    public static List EXTENSIONS = new ArrayList();
    public static final String OPTION_CONTINUE_AFTER_ERROR = "continueAfterError";
    public static final String OPTION_DISABLE_ATTRIBUTE_HELPER_CACHE = "disableAttributeHelperCache";
    public static final String OPTION_ALLOW_TARGET_NAVIGATION = "allowTargetNavigation";
    public static final String OPTION_ALLOW_SOURCE_MODIFICATION = "allowSourceModification";
    public static final String OPTION_ALLOW_CONTAINER_REASSIGNMENT = "allowContainerReassignment";
    public static final String OPTION_PRINT_EXECUTION_TIME = "printExecutionTime";
    public static final String OPTION_STEP = "step";
    public static final String OPTION_SHOW_SUMMARY = "showSummary";
    public static final String OPTION_PROFILE = "profile";
    public static final String[] additionalParamIds;
    public static final String[] additionalParamLabels;
    protected static Logger logger;
    private static String[] modelHandlersNames;
    private static int EMFKey;

    static {
        EXTENSIONS.add("atl");
        EXTENSIONS.add("acg");
        additionalParamIds = new String[]{OPTION_CONTINUE_AFTER_ERROR, OPTION_DISABLE_ATTRIBUTE_HELPER_CACHE, OPTION_PRINT_EXECUTION_TIME, OPTION_STEP, OPTION_SHOW_SUMMARY, OPTION_PROFILE};
        additionalParamLabels = new String[]{"Continue execution after errors in Run mode", "Disable attribute helpers caching", "Run mode only: print execution times to console: 1) transformation only, and 2) total (including model loading and saving)", "Run mode only: print execution information to console for each executed bytecode (very verbose!)", "Run mode only: print an execution summary to console (i.e., number of executed bytecodes)", "Run mode only: print information on the number of times operations are called with the same arguments to the console"};
        logger = Logger.getLogger("org.eclipse.m2m.atl");
        EMFKey = -1;
    }

    public static String[] getModelHandlers() {
        if (modelHandlersNames == null) {
            modelHandlersNames = AtlModelHandler.getModelHandlers();
            int i = 0;
            while (i < modelHandlersNames.length) {
                if (modelHandlersNames[i].equals("EMF")) {
                    EMFKey = i;
                }
                ++i;
            }
        }
        return modelHandlersNames;
    }

    public static int getEMFKey() {
        if (EMFKey == -1) {
            AtlLauncherTools.getModelHandlers();
        }
        return EMFKey;
    }

    public static FormData createFormData(int left, int right, int top, int bottom) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(left, 100, 0);
        formData.right = new FormAttachment(right, 100, 0);
        formData.top = new FormAttachment(top, 100, 0);
        formData.bottom = new FormAttachment(bottom, 100, 0);
        return formData;
    }

    public static void messageBox(String textToDisplay) {
        MessageBox msgBox = new MessageBox(new Shell(), 65568);
        msgBox.setText(Messages.getString("AtlLauncherTools.ERROR"));
        msgBox.setMessage(textToDisplay);
        msgBox.open();
    }

    public static Image createImage(String path) {
        try {
            URL BASE_URL = AtlDebugPlugin.getDefault().getBundle().getEntry("/");
            URL url = new URL(BASE_URL, path);
            return ImageDescriptor.createFromURL((URL)url).createImage();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String[] projectNames() {
        IWorkspace wks = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wksroot = wks.getRoot();
        IProject[] myTab = wksroot.getProjects();
        if (myTab != null && myTab.length > 0) {
            ArrayList<String> projectNames = new ArrayList<String>();
            int i = 0;
            while (i < myTab.length) {
                if (myTab[i].isOpen()) {
                    projectNames.add(myTab[i].getName());
                }
                ++i;
            }
            return projectNames.toArray(new String[0]);
        }
        return new String[0];
    }

    public static String[] fileNames(String projectName) {
        IWorkspace wks = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wksroot = wks.getRoot();
        final Vector fileList = new Vector();
        if (projectName == null || projectName.equals("")) {
            return new String[0];
        }
        IProject currentProject = wksroot.getProject(projectName);
        if (currentProject == null) {
            return new String[0];
        }
        try {
            currentProject.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    String extension;
                    if (resource instanceof IFile && (extension = ((IFile)resource).getFileExtension()) != null && AtlLauncherTools.isGoodExtension(extension)) {
                        fileList.add(((IFile)resource).getFullPath().toString());
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        String[] fileNames = new String[fileList.size()];
        int k = 0;
        while (k < fileNames.length) {
            fileNames[k] = (String)fileList.get(k);
            ++k;
        }
        return fileNames;
    }

    public static boolean isGoodExtension(String extension) {
        return EXTENSIONS.contains(extension.toLowerCase());
    }
}

