/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.launching;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.m2m.atl.adt.launching.AtlRegularVM;

public abstract class AtlVM
implements ILaunchConfigurationDelegate {
    public static final String ATLVM_REGULAR = "Regular VM (with debugger)";
    private static String[] atlVMs = null;
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");

    public static AtlVM getVM(String vm) {
        AtlVM ret = null;
        if (vm == null || vm.equals("")) {
            vm = ATLVM_REGULAR;
        }
        if (ATLVM_REGULAR.equals(vm)) {
            ret = new AtlRegularVM();
        } else {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            if (registry == null) {
                throw new RuntimeException("Eclipse platform extension registry not found. Dynamic repository lookup does not work outside Eclipse.");
            }
            IExtensionPoint point = registry.getExtensionPoint("org.eclipse.m2m.atl.adt.debug.atlvm");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            block2: while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    try {
                        if (elements[j].getAttribute("name").equals(vm)) {
                            ret = (AtlVM)elements[j].createExecutableExtension("class");
                            break block2;
                        }
                    }
                    catch (CoreException e) {
                        logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (ret == null) {
            throw new RuntimeException("ATL VM " + vm + " not found. You may need to install an ATL VM plugin.");
        }
        return ret;
    }

    public static String[] getVMs() {
        if (atlVMs == null) {
            ArrayList<String> avms = new ArrayList<String>();
            avms.add(ATLVM_REGULAR);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("org.eclipse.m2m.atl.adt.debug.atlvm");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    avms.add(elements[j].getAttribute("name"));
                    ++j;
                }
                ++i;
            }
            atlVMs = avms.toArray(new String[0]);
        }
        return atlVMs;
    }

    public abstract void launch(URL var1, Map var2, Map var3, Map var4, List var5, Map var6);
}

