/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassWriter;

public final class LineNumberTableWriter
extends ClassWriter.Element {
    private final int attrID;
    private int[] rawTable = emptyTable;
    private static final int[] emptyTable = new int[0];

    public LineNumberTableWriter(ClassWriter w) {
        if (w == null) {
            throw new IllegalArgumentException("w is null");
        }
        this.attrID = w.addCPUtf8("LineNumberTable");
    }

    public void setRawTable(int[] table) {
        if (table == null) {
            table = emptyTable;
        }
        if (table.length % 2 != 0) {
            throw new IllegalArgumentException("Line number table has bad length: " + table.length);
        }
        if (table.length / 2 > 65535) {
            throw new IllegalArgumentException("Too many line number table entries: " + table.length / 2);
        }
        int i = 0;
        while (i < table.length) {
            int v = table[i];
            if (v < 0 || v > 65535) {
                throw new IllegalArgumentException("Bad line number table entry at " + i + ": " + v);
            }
            ++i;
        }
        this.rawTable = table;
    }

    public int getSize() {
        return 8 + this.rawTable.length * 2;
    }

    public int copyInto(byte[] buf, int offset) throws IllegalArgumentException {
        ClassWriter.setUShort(buf, offset, this.attrID);
        ClassWriter.setInt(buf, offset + 2, 2 + this.rawTable.length * 2);
        ClassWriter.setUShort(buf, offset + 6, this.rawTable.length / 2);
        offset += 8;
        int i = 0;
        while (i < this.rawTable.length) {
            ClassWriter.setUShort(buf, offset, this.rawTable[i]);
            offset += 2;
            ++i;
        }
        return offset;
    }

    public static int[] makeRawTable(int[] newLineMap) throws IllegalArgumentException {
        if (newLineMap == null) {
            throw new IllegalArgumentException("newLineMap == null");
        }
        int rawCount = 0;
        int last = -1;
        int i = 0;
        while (i < newLineMap.length) {
            int next = newLineMap[i];
            if (next != last) {
                ++rawCount;
            }
            ++i;
        }
        int[] rawTable = new int[rawCount * 2];
        last = -1;
        int index = 0;
        int i2 = 0;
        while (i2 < newLineMap.length) {
            int next = newLineMap[i2];
            if (next != last) {
                rawTable[index] = i2;
                rawTable[index + 1] = next;
                index += 2;
            }
            ++i2;
        }
        return rawTable;
    }
}

