/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.sections;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.qvt.declarative.editor.ui.commands.SetResourceURICommand;
import org.eclipse.qvt.declarative.editor.ui.sections.AbstractTypedPropertySection;
import org.eclipse.qvt.declarative.editor.ui.utils.TracingAdapter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcePropertySection
extends AbstractTypedPropertySection<Resource> {
    private Adapter adapter = new TracingAdapter(){

        public void handleNotification(Notification msg) {
            if (msg.getEventType() == 1 && msg.getNotifier() == ResourcePropertySection.this.element) {
                int featureID = msg.getFeatureID(Resource.class);
                switch (featureID) {
                    case 6: {
                        ResourcePropertySection.this.refreshErrors();
                        break;
                    }
                    case 3: {
                        ResourcePropertySection.this.refreshIsModified();
                        break;
                    }
                    case 4: {
                        ResourcePropertySection.this.refreshIsLoaded();
                        break;
                    }
                    case 8: {
                        ResourcePropertySection.this.refreshTimeStamp();
                        break;
                    }
                    case 1: {
                        ResourcePropertySection.this.refreshURI();
                        break;
                    }
                    case 7: {
                        ResourcePropertySection.this.refreshWarnings();
                    }
                }
            }
            super.handleNotification(msg);
        }
    };
    private ModifyListener uriListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (ResourcePropertySection.this.uriText != null) {
                URI uri = URI.createURI((String)ResourcePropertySection.this.uriText.getText(), (boolean)true);
                TransactionalEditingDomain domain = ResourcePropertySection.this.getEditingDomain();
                SetResourceURICommand command = new SetResourceURICommand((EditingDomain)domain, (Resource)ResourcePropertySection.this.element, uri);
                domain.getCommandStack().execute((Command)command);
            }
        }
    };
    private Text errorsText;
    private Button isLoaded;
    private Button isLocked;
    private Button isModified;
    private Button isReadOnly;
    private Text timeStampText;
    private Text uriText;
    private Text warningsText;

    public ResourcePropertySection() {
        super(Resource.class);
    }

    public void aboutToBeHidden() {
        if (this.element != null) {
            ((Resource)this.element).eAdapters().remove((Object)this.adapter);
        }
        super.aboutToBeHidden();
    }

    public void aboutToBeShown() {
        if (this.element != null) {
            ((Resource)this.element).eAdapters().add((Object)this.adapter);
        }
        super.aboutToBeShown();
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.uriText = this.getWidgetFactory().createText(composite, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.uriText.setLayoutData((Object)data);
        CLabel uriLabel = this.getWidgetFactory().createCLabel(composite, "URI:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.uriText, -5);
        data.top = new FormAttachment(0, 0);
        uriLabel.setLayoutData((Object)data);
        CLabel flagsLabel = this.getWidgetFactory().createCLabel(composite, "State:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.uriText, -5);
        data.top = new FormAttachment((Control)this.uriText);
        flagsLabel.setLayoutData((Object)data);
        this.isLocked = this.getWidgetFactory().createButton(composite, "Locked", 32);
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.top = new FormAttachment((Control)this.uriText);
        this.isLocked.setLayoutData((Object)data);
        this.isReadOnly = this.getWidgetFactory().createButton(composite, "Read Only", 32);
        data = new FormData();
        data.left = new FormAttachment((Control)this.isLocked);
        data.top = new FormAttachment((Control)this.uriText);
        this.isReadOnly.setLayoutData((Object)data);
        this.isModified = this.getWidgetFactory().createButton(composite, "Modified", 32);
        this.isModified.setEnabled(false);
        data = new FormData();
        data.left = new FormAttachment((Control)this.isReadOnly);
        data.top = new FormAttachment((Control)this.uriText);
        this.isModified.setLayoutData((Object)data);
        this.isLoaded = this.getWidgetFactory().createButton(composite, "Loaded", 32);
        this.isLoaded.setEnabled(false);
        data = new FormData();
        data.left = new FormAttachment((Control)this.isModified);
        data.top = new FormAttachment((Control)this.uriText);
        this.isLoaded.setLayoutData((Object)data);
        CLabel timeStampLabel = this.getWidgetFactory().createCLabel(composite, "Time Stamp:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.uriText, -5);
        data.top = new FormAttachment((Control)this.isLocked);
        timeStampLabel.setLayoutData((Object)data);
        this.timeStampText = this.getWidgetFactory().createText(composite, "1234567890");
        this.timeStampText.setEditable(false);
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.top = new FormAttachment((Control)this.isLocked);
        this.timeStampText.setLayoutData((Object)data);
        CLabel errorsLabel = this.getWidgetFactory().createCLabel(composite, "Errors:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.timeStampText);
        data.top = new FormAttachment((Control)this.isLocked);
        errorsLabel.setLayoutData((Object)data);
        this.errorsText = this.getWidgetFactory().createText(composite, "1234");
        this.errorsText.setEditable(false);
        data = new FormData();
        data.left = new FormAttachment((Control)errorsLabel);
        data.top = new FormAttachment((Control)this.isLocked);
        this.errorsText.setLayoutData((Object)data);
        CLabel warningsLabel = this.getWidgetFactory().createCLabel(composite, "Warnings:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.errorsText);
        data.top = new FormAttachment((Control)this.isLocked);
        warningsLabel.setLayoutData((Object)data);
        this.warningsText = this.getWidgetFactory().createText(composite, "1234");
        this.warningsText.setEditable(false);
        data = new FormData();
        data.left = new FormAttachment((Control)warningsLabel);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.isLocked);
        this.warningsText.setLayoutData((Object)data);
        this.uriText.addModifyListener(this.uriListener);
    }

    public void dispose() {
        if (this.uriText != null) {
            this.uriText.removeModifyListener(this.uriListener);
        }
        super.dispose();
    }

    protected String getErrorsText() {
        if (this.element == null) {
            return "";
        }
        long errors = ((Resource)this.element).getErrors().size();
        return Long.toString(errors);
    }

    protected boolean getIsLoaded() {
        return this.element != null ? ((Resource)this.element).isLoaded() : false;
    }

    protected boolean getIsModified() {
        return this.element != null ? ((Resource)this.element).isModified() : false;
    }

    protected String getTimeStampText() {
        if (this.element == null) {
            return "";
        }
        long timeStamp = ((Resource)this.element).getTimeStamp();
        return Long.toString(timeStamp);
    }

    protected String getURIText() {
        if (this.element == null) {
            return "";
        }
        URI uri = ((Resource)this.element).getURI();
        return uri != null ? uri.toString() : "<null-uri>";
    }

    protected String getWarningsText() {
        long warnings = ((Resource)this.element).getWarnings().size();
        return Long.toString(warnings);
    }

    public void refresh() {
        this.refreshErrors();
        this.refreshIsLoaded();
        this.refreshIsModified();
        this.refreshTimeStamp();
        this.refreshURI();
        this.refreshWarnings();
    }

    protected void refreshButton(Button button, boolean newValue, SelectionListener listener) {
        boolean oldValue = button.getSelection();
        if (oldValue != newValue) {
            if (listener != null) {
                button.removeSelectionListener(listener);
            }
            button.setSelection(newValue);
            if (listener != null) {
                button.addSelectionListener(listener);
            }
        }
    }

    protected void refreshErrors() {
        this.refreshText(this.errorsText, this.getErrorsText(), null);
    }

    protected void refreshIsLoaded() {
        this.refreshButton(this.isLoaded, this.getIsLoaded(), null);
    }

    protected void refreshIsModified() {
        this.refreshButton(this.isModified, this.getIsModified(), null);
    }

    protected void refreshText(Text text, String newText, ModifyListener listener) {
        String oldText = text.getText();
        if (!oldText.equals(newText)) {
            if (listener != null) {
                text.removeModifyListener(listener);
            }
            text.setText(newText);
            if (listener != null) {
                text.addModifyListener(listener);
            }
        }
    }

    protected void refreshTimeStamp() {
        if (this.timeStampText != null) {
            this.refreshText(this.timeStampText, this.getTimeStampText(), null);
        }
    }

    protected void refreshURI() {
        if (this.uriText != null) {
            this.refreshText(this.uriText, this.getURIText(), this.uriListener);
        }
    }

    protected void refreshWarnings() {
        if (this.warningsText != null) {
            this.refreshText(this.warningsText, this.getWarningsText(), null);
        }
    }
}

