/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.ui.properties;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractFileHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.AccessorKindRegistry;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.qvt.declarative.modelregistry.model.Accessor;
import org.eclipse.qvt.declarative.modelregistry.model.AccessorRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.FileHandleRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.ProjectRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.Registration;
import org.eclipse.qvt.declarative.modelregistry.ui.help.ModelRegistryHelpIds;
import org.eclipse.qvt.declarative.modelregistry.ui.help.ModelRegistryHelper;
import org.eclipse.qvt.declarative.modelregistry.ui.icons.Icons;
import org.eclipse.qvt.declarative.modelregistry.ui.icons.ModelRegistryIcons;
import org.eclipse.qvt.declarative.modelregistry.ui.properties.PreferencesMessages;
import org.eclipse.qvt.declarative.modelregistry.ui.properties.RegistrationDialog;
import org.eclipse.qvt.declarative.modelregistry.util.ClassUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationBlock {
    protected final AbstractFileHandle fileHandle;
    private final ProjectRegistry projectRegistry;
    private final List<Registration<?>> editedRegistrationModel = new ArrayList();
    private final List<Registration<?>> uneditedRegistrationModel = new ArrayList();
    private String accessorKind;
    private Shell shell = null;
    private Button addButton = null;
    private Button editButton = null;
    private Button removeButton = null;
    private TableViewer tableViewer = null;

    public ConfigurationBlock(AbstractFileHandle handle) {
        this.fileHandle = handle;
        this.accessorKind = "Model Name";
        this.projectRegistry = new ProjectRegistry(handle.getProjectHandle(), (ResourceSet)new ResourceSetImpl());
        this.projectRegistry.loadModel();
        this.loadEditModel();
    }

    private boolean canEdit(List<Registration<?>> selectedElements) {
        return selectedElements.size() == 1 && this.fileHandle.equals(selectedElements.get(0).getFileHandle());
    }

    private boolean canRemove(List<Registration<?>> selectedElements) {
        for (Registration<?> selectedElement : selectedElements) {
            if (this.fileHandle.equals(selectedElement.getFileHandle())) continue;
            return false;
        }
        return true;
    }

    public Button createAddButton(Composite parent, int widthHint) {
        this.addButton = new Button(parent, 8);
        this.addButton.setText(PreferencesMessages.ModelRegistryConfigurationBlock_markers_tasks_add_button);
        GridData data = new GridData(256);
        Point minButtonSize = this.addButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        this.addButton.setLayoutData((Object)data);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessorRegistry accessorRegistry = ConfigurationBlock.this.getAccessorRegistry();
                RegistrationDialog dialog = new RegistrationDialog(ConfigurationBlock.this.shell, accessorRegistry, null, ConfigurationBlock.this.editedRegistrationModel, ConfigurationBlock.this.fileHandle);
                if (dialog.open() == 0) {
                    ConfigurationBlock.this.editedRegistrationModel.add(dialog.getRegistration());
                    ConfigurationBlock.this.updateFromEditModel();
                }
            }
        });
        ModelRegistryHelper.setHelp((Control)this.addButton, ModelRegistryHelpIds.PropertyPage.ADD);
        return this.addButton;
    }

    protected Control createContents(Composite parent) {
        this.shell = parent.getShell();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 5;
        Composite inner = new Composite(parent, 0);
        inner.setLayout((Layout)layout);
        inner.setFont(parent.getFont());
        Table tableControl = this.createTableControl(inner);
        tableControl.setLayoutData((Object)new GridData(4, 4, true, true, layout.numColumns, 1));
        this.updateFromEditModel();
        return inner;
    }

    public Button createEditButton(Composite parent, int widthHint) {
        this.editButton = new Button(parent, 8);
        this.editButton.setText(PreferencesMessages.ModelRegistryConfigurationBlock_markers_tasks_edit_button);
        GridData data = new GridData(256);
        Point minButtonSize = this.editButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        this.editButton.setLayoutData((Object)data);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selection = ConfigurationBlock.this.getSelectedRegistrations();
                if (selection.size() > 0) {
                    Registration edited = (Registration)selection.get(0);
                    AccessorRegistry accessorRegistry = ConfigurationBlock.this.getAccessorRegistry();
                    RegistrationDialog dialog = new RegistrationDialog(ConfigurationBlock.this.shell, accessorRegistry, edited, ConfigurationBlock.this.editedRegistrationModel, ConfigurationBlock.this.fileHandle);
                    if (dialog.open() == 0) {
                        ConfigurationBlock.this.editedRegistrationModel.set(ConfigurationBlock.this.editedRegistrationModel.indexOf(edited), dialog.getRegistration());
                        ConfigurationBlock.this.updateFromEditModel();
                    }
                }
            }
        });
        ModelRegistryHelper.setHelp((Control)this.editButton, ModelRegistryHelpIds.PropertyPage.EDIT);
        return this.editButton;
    }

    public Button createRemoveButton(Composite parent, int widthHint) {
        this.removeButton = new Button(parent, 8);
        this.removeButton.setText(PreferencesMessages.ModelRegistryConfigurationBlock_markers_tasks_remove_button);
        GridData data = new GridData(256);
        Point minButtonSize = this.removeButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selection = ConfigurationBlock.this.getSelectedRegistrations();
                ConfigurationBlock.this.editedRegistrationModel.removeAll(selection);
                ConfigurationBlock.this.updateFromEditModel();
            }
        });
        ModelRegistryHelper.setHelp((Control)this.removeButton, ModelRegistryHelpIds.PropertyPage.REMOVE);
        return this.removeButton;
    }

    protected Table createTableControl(Composite inner) {
        this.tableViewer = new TableViewer(inner);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new RegistrationLabelProvider());
        this.tableViewer.setComparator((ViewerComparator)new RegistrationLabelComparator());
        Table tableControl = this.tableViewer.getTable();
        String[] columnsHeaders = new String[]{PreferencesMessages.ModelRegistryConfigurationBlock_container_column, PreferencesMessages.ModelRegistryConfigurationBlock_accessor_name_column, PreferencesMessages.ModelRegistryConfigurationBlock_platform_resource_column, PreferencesMessages.ModelRegistryConfigurationBlock_serialization_column};
        int[] columnWidths = new int[]{100, 85, 400, 40};
        int i = 0;
        while (i < columnsHeaders.length) {
            TableColumn column = new TableColumn(tableControl, 0);
            column.setText(columnsHeaders[i]);
            column.setWidth(columnWidths[i]);
            ++i;
        }
        tableControl.setHeaderVisible(true);
        tableControl.setLinesVisible(true);
        tableControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationBlock.this.updateStatus();
            }
        });
        ModelRegistryHelper.setHelp((Control)tableControl, ModelRegistryHelpIds.PropertyPage.TABLE);
        return tableControl;
    }

    public void dispose() {
    }

    public String getAccessorKind() {
        return this.accessorKind;
    }

    private AccessorRegistry<?> getAccessorRegistry() {
        AccessorKindRegistry accessorKindRegistry = ModelRegistryEnvironment.getInstance().getAccessorKindRegistry();
        Class accessorClass = accessorKindRegistry.getAccessorClass(this.accessorKind);
        if (accessorClass == null) {
            return null;
        }
        FileHandleRegistry fileHandleRegistry = this.projectRegistry.getOrCreate(this.fileHandle);
        if (fileHandleRegistry == null) {
            return null;
        }
        AccessorRegistry accessorRegistry = fileHandleRegistry.getOrCreate(accessorClass);
        return accessorRegistry;
    }

    private List<Registration<?>> getSelectedRegistrations() {
        ISelection selection = this.tableViewer.getSelection();
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return Collections.emptyList();
        }
        return (List)ClassUtils.asClassUnchecked((Object)((IStructuredSelection)selection).toList(), null);
    }

    public boolean isDirty() {
        if (this.editedRegistrationModel.size() != this.uneditedRegistrationModel.size()) {
            return true;
        }
        int iMax = this.editedRegistrationModel.size();
        int i = 0;
        while (i < iMax) {
            Registration<?> uneditedRegistration;
            Registration<?> editedRegistration = this.editedRegistrationModel.get(i);
            if (!editedRegistration.equals(uneditedRegistration = this.uneditedRegistrationModel.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isVisible(Registration<?> candidateRegistration) {
        Accessor candidateAccessor = candidateRegistration.getAccessor();
        Registration<?> visibleRegistration = null;
        int visibleDepth = -1;
        int iMax = this.editedRegistrationModel.size();
        int i = 0;
        while (i < iMax) {
            int editedDepth;
            Registration<?> editedRegistration = this.editedRegistrationModel.get(i);
            if (((Object)editedRegistration.getAccessor()).equals(candidateAccessor) && (editedDepth = editedRegistration.getFileHandleRegistry().getDepth()) >= visibleDepth) {
                visibleRegistration = editedRegistration;
                visibleDepth = editedDepth;
            }
            ++i;
        }
        return visibleRegistration == candidateRegistration;
    }

    private void loadEditModel() {
        this.editedRegistrationModel.clear();
        AccessorKindRegistry accessorKindRegistry = ModelRegistryEnvironment.getInstance().getAccessorKindRegistry();
        Class accessorClass = accessorKindRegistry.getAccessorClass(this.accessorKind);
        if (accessorClass != null) {
            AbstractFileHandle fileHandleAncestor = this.fileHandle;
            while (fileHandleAncestor != null) {
                Collection fileHandleRegistrations;
                AccessorRegistry accessorRegistry;
                FileHandleRegistry fileHandleRegistry = this.projectRegistry.get(fileHandleAncestor);
                if (fileHandleRegistry != null && (accessorRegistry = fileHandleRegistry.getOrCreate(accessorClass)) != null && (fileHandleRegistrations = accessorRegistry.getRegistrations()) != null) {
                    this.editedRegistrationModel.addAll(fileHandleRegistrations);
                }
                fileHandleAncestor = fileHandleAncestor.getParentFileHandle();
            }
        }
        this.uneditedRegistrationModel.clear();
        this.uneditedRegistrationModel.addAll(this.editedRegistrationModel);
    }

    public boolean performApply() {
        return this.saveEditModel();
    }

    public void performDefaults() {
        this.performRevert();
    }

    public boolean performOk() {
        return this.saveEditModel();
    }

    public void performRevert() {
        this.editedRegistrationModel.clear();
        this.editedRegistrationModel.addAll(this.uneditedRegistrationModel);
        this.updateFromEditModel();
    }

    private boolean saveEditModel() {
        ArrayList newRegistrations = new ArrayList(this.editedRegistrationModel);
        ArrayList obsoleteRegistrations = new ArrayList(this.uneditedRegistrationModel);
        for (Registration<?> registration : this.editedRegistrationModel) {
            if (!this.uneditedRegistrationModel.contains(registration)) continue;
            newRegistrations.remove(registration);
            obsoleteRegistrations.remove(registration);
        }
        for (Registration registration : obsoleteRegistrations) {
            if (this.projectRegistry.remove(registration) != null) continue;
            ModelRegistryEnvironment.logError((String)("Failed to remove registration ' " + registration + "'"), null);
        }
        for (Registration registration : newRegistrations) {
            Registration displacedRegistration = this.projectRegistry.add(registration);
            if (displacedRegistration == null) continue;
            ModelRegistryEnvironment.logError((String)("Displaced '" + displacedRegistration + "' when adding '" + registration + "'"), null);
        }
        if (!this.projectRegistry.saveModel()) {
            return false;
        }
        this.uneditedRegistrationModel.clear();
        this.uneditedRegistrationModel.addAll(this.editedRegistrationModel);
        return true;
    }

    public boolean setAccessorKind(String accessorKind) {
        if (!this.accessorKind.equals(accessorKind)) {
            if (this.isDirty()) {
                if (!MessageDialog.openConfirm((Shell)this.shell, (String)"Save Changes?", (String)("The '" + accessorKind + "' accessor has unsaved changes. Do you wish to save them?"))) {
                    return false;
                }
                this.saveEditModel();
            }
            this.accessorKind = accessorKind;
            this.loadEditModel();
            this.updateFromEditModel();
        }
        return true;
    }

    public void setEnabled(boolean isEnabled) {
        this.tableViewer.getTable().setEnabled(isEnabled);
        this.addButton.setEnabled(isEnabled);
        this.editButton.setEnabled(isEnabled);
        this.removeButton.setEnabled(isEnabled);
    }

    private void updateFromEditModel() {
        this.tableViewer.setInput(this.editedRegistrationModel);
        this.updateStatus();
    }

    protected void updateStatus() {
        List<Registration<?>> selectedElements = this.getSelectedRegistrations();
        if (this.editButton != null) {
            this.editButton.setEnabled(this.canEdit(selectedElements));
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(this.canRemove(selectedElements));
        }
    }

    public class RegistrationLabelComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            return ((Registration)e1).compareTo((Registration)e2);
        }
    }

    private class RegistrationLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private RegistrationLabelProvider() {
        }

        public Color getBackground(Object element) {
            Registration registration = (Registration)element;
            if (!ConfigurationBlock.this.fileHandle.equals(registration.getFileHandle())) {
                return ConfigurationBlock.this.shell.getDisplay().getSystemColor(22);
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex != 0) {
                return null;
            }
            Registration registration = (Registration)element;
            AbstractFileHandle lineHandle = registration.getFileHandle();
            ModelRegistryIcons imageIcon = null;
            ModelRegistryIcons overlayIcon = null;
            ModelRegistryIcons underlayIcon = null;
            if (lineHandle.isFile() != null) {
                imageIcon = ModelRegistryIcons.FILE;
            } else if (lineHandle.isFolder() != null) {
                imageIcon = ModelRegistryIcons.FOLDER;
            } else if (lineHandle.isProject() != null) {
                imageIcon = ModelRegistryIcons.PROJECT;
            }
            try {
                File file = ModelRegistryEnvironment.getInstance().getFile(registration.getURI());
                if (file == null || !file.exists()) {
                    overlayIcon = ModelRegistryIcons.WITH_WARNING;
                }
            }
            catch (Exception exception) {
                overlayIcon = ModelRegistryIcons.WITH_ERROR;
            }
            if (!ConfigurationBlock.this.isVisible(registration)) {
                underlayIcon = ModelRegistryIcons.OCCLUDED;
            }
            return Icons.getImage(imageIcon, overlayIcon, underlayIcon);
        }

        public String getColumnText(Object element, int columnIndex) {
            Registration registration = (Registration)element;
            switch (columnIndex) {
                case 0: {
                    return registration.getFileHandle().getName();
                }
                case 1: {
                    return registration.getAccessorName();
                }
                case 2: {
                    return registration.getURIString();
                }
                case 3: {
                    return registration.getModelKindName();
                }
            }
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 1);
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ConfigurationBlock.this.editedRegistrationModel.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

