/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.ui.preferences;

import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ExtensionsStringFieldEditor
extends StringFieldEditor {
    private String oldExtensions = null;

    public ExtensionsStringFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.setEmptyStringAllowed(false);
        this.setErrorMessage("File-name patterns starting with *. and separated by commas required");
    }

    protected boolean checkState() {
        if (this.getExtensionsFromControl() != null) {
            this.clearErrorMessage();
            return true;
        }
        this.showErrorMessage();
        return false;
    }

    protected void doLoad() {
        String value = this.getPreferenceStore().getString(this.getPreferenceName());
        this.setStringValue(value);
    }

    protected void doLoadDefault() {
        String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        this.setStringValue(value);
    }

    protected void doStore() {
        String extensionsString = this.getNonNullExtensionsFromControl();
        this.getPreferenceStore().setValue(this.getPreferenceName(), extensionsString);
    }

    protected String getExtensionsFromControl() {
        Text textField = this.getTextControl();
        if (textField == null) {
            return null;
        }
        StringBuffer s = null;
        String[] stringArray = textField.getText().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String extensionString = stringArray[n2];
            String trimmedString = extensionString.trim();
            if (!trimmedString.startsWith("*.")) {
                return null;
            }
            if (s == null) {
                s = new StringBuffer();
            } else {
                s.append(",");
            }
            s.append(trimmedString.substring(2));
            ++n2;
        }
        return s != null ? s.toString() : null;
    }

    protected String getNonNullExtensionsFromControl() {
        String extensionsString = this.getExtensionsFromControl();
        return extensionsString != null ? extensionsString : "";
    }

    public String getStringValue() {
        String value = this.getExtensionsFromControl();
        if (value != null) {
            return value;
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    public void setStringValue(String value) {
        Text textField = this.getTextControl();
        if (textField != null) {
            String newExtensions = value != null ? value : "";
            this.oldExtensions = this.getNonNullExtensionsFromControl();
            if (!this.oldExtensions.equals(newExtensions)) {
                StringBuffer s = null;
                String[] stringArray = newExtensions.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String newExtension = stringArray[n2];
                    if (s == null) {
                        s = new StringBuffer();
                    } else {
                        s.append(",");
                    }
                    s.append("*.");
                    s.append(newExtension);
                    ++n2;
                }
                textField.setText(s != null ? s.toString() : "");
                this.valueChanged();
            }
        }
    }

    protected void valueChanged() {
        String newExtensions;
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid();
        this.refreshValidState();
        boolean newState = this.isValid();
        if (newState != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, newState);
        }
        if (!this.oldExtensions.equals(newExtensions = this.getNonNullExtensionsFromControl())) {
            this.fireValueChanged("field_editor_value", this.oldExtensions, newExtensions);
            this.oldExtensions = newExtensions;
        }
    }
}

