/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.evaluator;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.evaluator.IterateBreakpointHelper;
import org.eclipse.ocl.examples.debug.stepper.AbstractStepper;
import org.eclipse.ocl.examples.debug.vm.IVMDebuggerShell;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.VMBreakpoint;
import org.eclipse.ocl.examples.debug.vm.VMBreakpointManager;
import org.eclipse.ocl.examples.debug.vm.VMVirtualMachine;
import org.eclipse.ocl.examples.debug.vm.data.VMStackFrameData;
import org.eclipse.ocl.examples.debug.vm.data.VMSuspension;
import org.eclipse.ocl.examples.debug.vm.evaluator.IStepper;
import org.eclipse.ocl.examples.debug.vm.evaluator.IStepperVisitor;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationVisitor;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMRootEvaluationVisitor;
import org.eclipse.ocl.examples.debug.vm.event.VMEvent;
import org.eclipse.ocl.examples.debug.vm.event.VMResumeEvent;
import org.eclipse.ocl.examples.debug.vm.event.VMStartEvent;
import org.eclipse.ocl.examples.debug.vm.event.VMSuspendEvent;
import org.eclipse.ocl.examples.debug.vm.request.VMRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMResumeRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMSuspendRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMTerminateRequest;
import org.eclipse.ocl.examples.debug.vm.utils.ASTBindingHelper;
import org.eclipse.ocl.examples.debug.vm.utils.CompiledUnit;
import org.eclipse.ocl.examples.debug.vm.utils.DebugOptions;
import org.eclipse.ocl.examples.debug.vm.utils.VMInterruptedExecutionException;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.debug.core.QVTiDebugCore;
import org.eclipse.qvtd.debug.evaluator.AbstractQVTiVMEvaluationVisitor;
import org.eclipse.qvtd.debug.evaluator.IQVTiVMEvaluationEnvironment;
import org.eclipse.qvtd.debug.evaluator.QVTiVMEvaluationVisitor;
import org.eclipse.qvtd.debug.evaluator.QVTiVMNestedEvaluationVisitor;
import org.eclipse.qvtd.debug.stepper.QVTiStepperVisitor;
import org.eclipse.qvtd.debug.vm.QVTiVMVirtualMachine;

public class QVTiVMRootEvaluationVisitor
extends AbstractQVTiVMEvaluationVisitor
implements IVMRootEvaluationVisitor {
    @NonNull
    private final IVMDebuggerShell fDebugShell;
    @NonNull
    private final VMBreakpointManager fBPM;
    @NonNull
    private UnitLocation fCurrentLocation;
    @NonNull
    private final IterateBreakpointHelper fIterateBPHelper;
    @NonNull
    private VMSuspension fCurrentStepMode;
    @NonNull
    private Stack<AbstractQVTiVMEvaluationVisitor> visitorStack = new Stack();
    @NonNull
    private final Variable invalidVariable;

    public QVTiVMRootEvaluationVisitor(@NonNull IQVTiVMEvaluationEnvironment evalEnv, @NonNull IVMDebuggerShell shell) {
        super(new QVTiVMEvaluationVisitor(evalEnv));
        this.fDebugShell = shell;
        this.fBPM = shell.getBreakPointManager();
        this.fIterateBPHelper = new IterateBreakpointHelper(this.fBPM);
        this.fCurrentStepMode = VMSuspension.UNSPECIFIED;
        this.pushVisitor(this);
        this.fCurrentLocation = this.getCurrentLocation();
        this.invalidVariable = (Variable)ClassUtil.nonNullEMF((Object)PivotFactory.eINSTANCE.createVariable());
        this.invalidVariable.setName("$invalid");
        String typeName = (String)ClassUtil.nonNullEMF((Object)PivotPackage.Literals.OCL_EXPRESSION.getName());
        this.invalidVariable.setType((Type)this.getEnvironmentFactory().getMetamodelManager().getASClass(typeName));
    }

    @Override
    @Nullable
    protected Object badVisit(@NonNull IVMEvaluationEnvironment evalEnv, @NonNull Element element, Object preState, @NonNull Throwable e) {
        Stack stepperStack = evalEnv.getStepperStack();
        if (!stepperStack.isEmpty()) {
            stepperStack.pop();
        }
        evalEnv.add((TypedElement)this.invalidVariable, (Object)e);
        int endPosition = ASTBindingHelper.getEndPosition((Element)element);
        UnitLocation endLocation = this.newLocalLocation(evalEnv, element, endPosition, endPosition);
        this.setCurrentLocation(element, endLocation, true);
        this.suspendAndWaitForResume(endLocation, VMSuspension.BREAKPOINT);
        if (e instanceof Exception) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    @NonNull
    private VMSuspendEvent createVMSuspendEvent(@NonNull VMSuspension vmSuspension) {
        VMStackFrameData[] vmStack = QVTiVMVirtualMachine.createStackFrame(this.getLocationStack());
        assert (vmStack.length > 0);
        return new VMSuspendEvent(vmStack, vmSuspension);
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException();
    }

    private void doProcessRequest(@NonNull UnitLocation location, @NonNull VMRequest request) {
        if (VMVirtualMachine.VM_REQUEST.isActive()) {
            VMVirtualMachine.VM_REQUEST.println(">[" + Thread.currentThread().getName() + "] " + location.toString() + " " + request);
        }
        if (request instanceof VMResumeRequest) {
            VMResumeRequest resumeRequest = (VMResumeRequest)request;
            this.fCurrentStepMode = resumeRequest.suspension;
            if (this.fCurrentStepMode == VMSuspension.UNSPECIFIED) {
                this.fIterateBPHelper.removeAllIterateBreakpoints();
            }
        } else if (request instanceof VMSuspendRequest) {
            VMSuspendRequest suspendRequest = (VMSuspendRequest)request;
            this.suspendAndWaitForResume(location, suspendRequest.suspension);
        } else if (request instanceof VMTerminateRequest) {
            this.terminate();
        } else {
            throw new IllegalArgumentException("Unsupported debug request: " + request);
        }
    }

    @NonNull
    public UnitLocation getCurrentLocation() {
        AbstractQVTiVMEvaluationVisitor currentVisitor = this.visitorStack.peek();
        IQVTiVMEvaluationEnvironment evaluationEnvironment = currentVisitor.getVMEvaluationEnvironment();
        return evaluationEnvironment.getCurrentLocation();
    }

    @Override
    public int getDepth() {
        return 1;
    }

    @NonNull
    public IQVTiVMEvaluationEnvironment getEvaluationEnvironment() {
        return (IQVTiVMEvaluationEnvironment)super.getEvaluationEnvironment();
    }

    @NonNull
    public List<UnitLocation> getLocationStack() {
        IQVTiVMEvaluationEnvironment leafEvaluationEnvironment;
        ArrayList<UnitLocation> fLocationStack = new ArrayList<UnitLocation>();
        IQVTiVMEvaluationEnvironment evaluationEnvironment = leafEvaluationEnvironment = this.visitorStack.peek().getVMEvaluationEnvironment();
        while (evaluationEnvironment != null) {
            Element element = evaluationEnvironment.getCurrentIP();
            IStepper stepper = this.getStepperVisitor().getStepper(element);
            UnitLocation unitLocation = stepper.createUnitLocation((IVMEvaluationEnvironment)evaluationEnvironment, element);
            fLocationStack.add(unitLocation);
            evaluationEnvironment = evaluationEnvironment.getVMParentEvaluationEnvironment();
        }
        return fLocationStack;
    }

    @NonNull
    private String getMainModuleName() {
        CompiledUnit mainUnit = this.fBPM.getUnitManager().getMainUnit();
        List modules = mainUnit.getModules();
        if (modules.isEmpty()) {
            return "<null>";
        }
        String name = ((NamedElement)modules.get(0)).getName();
        if (name == null) {
            return "<null>";
        }
        return (String)ClassUtil.nonNullState((Object)name);
    }

    @Override
    @NonNull
    public QVTiVMRootEvaluationVisitor getRootEvaluationVisitor() {
        return this;
    }

    @NonNull
    public IStepperVisitor getStepperVisitor() {
        return QVTiStepperVisitor.INSTANCE;
    }

    protected void handleLocationChanged(@NonNull Element element, @NonNull UnitLocation location, boolean isElementEnd) {
        if (VMVirtualMachine.LOCATION.isActive()) {
            VMVirtualMachine.LOCATION.println("[" + Thread.currentThread().getName() + "] " + element.eClass().getName() + ": " + element.toString() + " @ " + location + " " + (isElementEnd ? "start" : "end"));
        }
        boolean doSuspendAndResume = false;
        if (this.fCurrentStepMode == VMSuspension.STEP_INTO) {
            doSuspendAndResume = true;
        } else if (this.fCurrentStepMode == VMSuspension.STEP_OVER) {
            if (this.isSmallerStackDepth(location) || this.isNewLine(location)) {
                doSuspendAndResume = true;
            }
        } else if (this.fCurrentStepMode == VMSuspension.STEP_RETURN && this.isSmallerStackDepth(location)) {
            doSuspendAndResume = true;
        }
        if (doSuspendAndResume) {
            this.suspendAndWaitForResume(location, this.fCurrentStepMode);
            return;
        }
        for (VMBreakpoint breakpoint : this.fBPM.getBreakpoints(element)) {
            if (breakpoint.getLineNumber() != location.getLineNum()) continue;
            Boolean isTriggered = null;
            try {
                isTriggered = breakpoint.hitAndCheckIfTriggered((IVMEvaluationVisitor)this);
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                String reason = null;
                if (status.getCode() == 100) {
                    reason = "Breakpoint condition compilation failed";
                } else if (status.getCode() == 110) {
                    reason = "Breakpoint condition evaluation failed";
                }
                if (reason != null) {
                    VMSuspendEvent suspendOnBpConditionErrr = this.createVMSuspendEvent(VMSuspension.BREAKPOINT_CONDITION_ERR);
                    suspendOnBpConditionErrr.setBreakpointID(Long.valueOf(breakpoint.getID()));
                    suspendOnBpConditionErrr.setReason(reason, status.getMessage());
                    this.suspendAndWaitForResume(location, suspendOnBpConditionErrr);
                    continue;
                }
                QVTiDebugCore.INSTANCE.log(e.getStatus());
                continue;
            }
            if (!Boolean.TRUE.equals(isTriggered)) continue;
            boolean isIterateBp = this.fIterateBPHelper.isIterateBreakpoint(breakpoint);
            VMSuspension vmSuspension = isIterateBp ? this.fCurrentStepMode : VMSuspension.BREAKPOINT;
            this.suspendAndWaitForResume(location, vmSuspension);
            if (!isIterateBp) continue;
            this.fBPM.removeBreakpoint(breakpoint);
        }
    }

    protected boolean isLargerStackDepth(@NonNull UnitLocation location) {
        return location.getStackDepth() > this.fCurrentLocation.getStackDepth();
    }

    protected boolean isNewLine(@NonNull UnitLocation location) {
        return !location.isTheSameLine(this.fCurrentLocation);
    }

    protected boolean isNewLocation(@NonNull UnitLocation location) {
        return !location.isTheSameLocation(this.fCurrentLocation);
    }

    protected boolean isSmallerStackDepth(@NonNull UnitLocation location) {
        return location.getStackDepth() < this.fCurrentLocation.getStackDepth();
    }

    @NonNull
    private UnitLocation newLocalLocation(@NonNull IVMEvaluationEnvironment evalEnv, @NonNull Element node, int startPosition, int endPosition) {
        return new UnitLocation(startPosition, endPosition, evalEnv, node);
    }

    public void popVisitor(@NonNull QVTiVMNestedEvaluationVisitor evaluationVisitor) {
        if (VMVirtualMachine.VISITOR_STACK.isActive()) {
            VMVirtualMachine.VISITOR_STACK.println("[" + Thread.currentThread().getName() + "] " + "Pop " + evaluationVisitor.toString());
        }
        AbstractQVTiVMEvaluationVisitor poppedVisitor = this.visitorStack.pop();
        assert (poppedVisitor == evaluationVisitor);
    }

    public void postIterate(@NonNull LoopExp loopExp) {
    }

    @Override
    protected void postVisit(@NonNull IVMEvaluationEnvironment evalEnv, @NonNull Element element, @Nullable Object result) {
        Element postElement;
        Stack stepperStack = evalEnv.getStepperStack();
        if (stepperStack.isEmpty()) {
            return;
        }
        IStepper parentStepper = null;
        EObject eContainer = element.eContainer();
        Element parentElement = eContainer instanceof Element ? (Element)eContainer : null;
        IVMEvaluationEnvironment.StepperEntry childStepperEntry = (IVMEvaluationEnvironment.StepperEntry)stepperStack.pop();
        childStepperEntry.popFrom(evalEnv);
        if (!stepperStack.isEmpty()) {
            IVMEvaluationEnvironment.StepperEntry parentStepperEntry = (IVMEvaluationEnvironment.StepperEntry)stepperStack.peek();
            if (element instanceof OCLExpression) {
                parentStepperEntry.pushTo(evalEnv, (TypedElement)element, result);
            }
            parentStepper = parentStepperEntry.stepper;
        } else if (evalEnv != this.getEvaluationEnvironment() && parentElement != null) {
            parentStepper = this.getStepperVisitor().getStepper(parentElement);
        }
        if (parentStepper != null && (postElement = parentStepper.isPostStoppable((IVMRootEvaluationVisitor)this, element, result)) != null) {
            evalEnv.setCurrentIP(postElement);
            evalEnv.replace((TypedElement)evalEnv.getPCVariable(), (Object)postElement);
            evalEnv.remove((TypedElement)this.invalidVariable);
            UnitLocation unitLocation = parentStepper.createUnitLocation(evalEnv, postElement);
            this.setCurrentLocation(postElement, unitLocation, false);
            this.processDebugRequest(unitLocation);
        }
    }

    public void preIterate(@NonNull LoopExp loopExp) {
        boolean skipIterate;
        UnitLocation topLocation = this.getCurrentLocation();
        boolean bl = skipIterate = this.fCurrentStepMode == VMSuspension.UNSPECIFIED || this.fCurrentStepMode == VMSuspension.STEP_OVER && this.isLargerStackDepth(topLocation);
        if (!skipIterate) {
            this.fIterateBPHelper.stepIterateElement(loopExp, topLocation);
        }
    }

    @Nullable
    protected Element preVisit(@NonNull IVMEvaluationEnvironment evalEnv, @NonNull Element element) {
        Stack stepperStack = evalEnv.getStepperStack();
        IStepper stepper = this.getStepperVisitor().getStepper(element);
        stepperStack.push(new IVMEvaluationEnvironment.StepperEntry(stepper, element));
        if (stepper.isPreStoppable((IVMRootEvaluationVisitor)this, element)) {
            Element firstElement;
            if (stepper instanceof AbstractStepper && (firstElement = ((AbstractStepper)stepper).getFirstElement((IVMRootEvaluationVisitor)this, element)) != null) {
                element = firstElement;
            }
            evalEnv.setCurrentIP(element);
            evalEnv.replace((TypedElement)evalEnv.getPCVariable(), (Object)element);
            evalEnv.remove((TypedElement)this.invalidVariable);
            UnitLocation unitLocation = stepper.createUnitLocation(evalEnv, element);
            this.setCurrentLocation(element, unitLocation, false);
            this.processDebugRequest(unitLocation);
        }
        return null;
    }

    private void processDebugRequest(@NonNull UnitLocation location) {
        VMRequest event = this.fDebugShell.popRequest();
        if (event == null) {
            return;
        }
        this.doProcessRequest(location, event);
    }

    public void pushVisitor(@NonNull AbstractQVTiVMEvaluationVisitor evaluationVisitor) {
        if (VMVirtualMachine.VISITOR_STACK.isActive()) {
            VMVirtualMachine.VISITOR_STACK.println("[" + Thread.currentThread().getName() + "] " + "Push " + evaluationVisitor.toString());
        }
        assert (!this.visitorStack.contains(evaluationVisitor));
        this.visitorStack.push(evaluationVisitor);
    }

    private void setCurrentLocation(@NonNull Element element, UnitLocation newLocation, boolean atEnd) {
        if (newLocation.getStartPosition() < 0) {
            return;
        }
        this.handleLocationChanged(element, newLocation, atEnd);
    }

    public void start(boolean suspendOnStartup) {
        this.fDebugShell.sessionStarted((IVMRootEvaluationVisitor)this);
        VMRequest request = null;
        try {
            QVTiDebugCore.TRACE.trace(DebugOptions.EVALUATOR, "Debug evaluator going to initial SUSPEND state");
            request = this.fDebugShell.waitAndPopRequest((VMEvent)new VMStartEvent(this.getMainModuleName(), suspendOnStartup));
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            this.terminate();
        }
        if (request instanceof VMResumeRequest) {
            this.fCurrentStepMode = ((VMResumeRequest)request).suspension;
        } else {
            this.terminate();
        }
    }

    private void suspendAndWaitForResume(@NonNull UnitLocation location, @NonNull VMSuspension vmSuspension) {
        this.suspendAndWaitForResume(location, this.createVMSuspendEvent(vmSuspension));
    }

    private void suspendAndWaitForResume(@NonNull UnitLocation location, @NonNull VMSuspendEvent suspendEvent) {
        this.fCurrentLocation = location;
        try {
            VMSuspendEvent vmSuspend = suspendEvent;
            VMRequest nextRequest = this.fDebugShell.waitAndPopRequest((VMEvent)vmSuspend);
            assert (nextRequest != null);
            if (nextRequest instanceof VMResumeRequest) {
                this.fDebugShell.handleVMEvent((VMEvent)new VMResumeEvent());
            }
            this.doProcessRequest(location, nextRequest);
        }
        catch (InterruptedException e) {
            this.terminate();
        }
    }

    private void terminate() throws VMInterruptedExecutionException {
        IQVTiVMEvaluationEnvironment evalEnv = this.getEvaluationEnvironment();
        evalEnv.throwVMException((VMRuntimeException)new VMInterruptedExecutionException("User termination request"));
    }
}

