/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.evaluation;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.SlotState;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractInvocationInternal;

public abstract class AbstractInvocation
extends AbstractInvocationInternal
implements Invocation {
    @Override
    public <R> R accept(@NonNull ExecutionVisitor<R> visitor) {
        return visitor.visitInvocation(this);
    }

    public static abstract class Incremental
    extends AbstractInvocation
    implements Invocation.Incremental {
        public static final @NonNull List<@NonNull Object> EMPTY_OBJECT_LIST = Collections.emptyList();
        public static final @NonNull List< @NonNull SlotState.Incremental> EMPTY_SLOT_LIST = Collections.emptyList();
        private Set<@NonNull Object> createdObjects = null;
        private Set< @NonNull SlotState.Incremental> readSlots = null;
        private Set< @NonNull SlotState.Incremental> writeSlots = null;

        @Override
        public void addCreatedObject(@NonNull Object createdObject) {
            if (this.createdObjects == null) {
                this.createdObjects = new HashSet<Object>();
            }
            this.createdObjects.add(createdObject);
        }

        @Override
        public void addReadSlot( @NonNull SlotState.Incremental readSlot) {
            if (this.readSlots == null) {
                this.readSlots = new HashSet<SlotState.Incremental>();
            }
            this.readSlots.add(readSlot);
            readSlot.addTargetInternal(this);
        }

        @Override
        public void addWriteSlot( @NonNull SlotState.Incremental writeSlot) {
            if (this.writeSlots == null) {
                this.writeSlots = new HashSet<SlotState.Incremental>();
            }
            this.writeSlots.add(writeSlot);
            writeSlot.addSourceInternal(this);
        }

        @Override
        public @NonNull Iterable<@NonNull Object> getCreatedObjects() {
            return this.createdObjects != null ? this.createdObjects : EMPTY_OBJECT_LIST;
        }

        @Override
        public @NonNull Iterable< @NonNull SlotState.Incremental> getReadSlots() {
            return this.readSlots != null ? this.readSlots : EMPTY_SLOT_LIST;
        }

        @Override
        public @NonNull Iterable< @NonNull SlotState.Incremental> getWriteSlots() {
            return this.writeSlots != null ? this.writeSlots : EMPTY_SLOT_LIST;
        }
    }
}

