/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.TransformationAnalysis2TracePackage;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicRegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TracePropertyRegionAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.ConnectionEnd;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduledRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class TransformationAnalysis
extends RegionsAnalysis<RegionAnalysis> {
    protected final @NonNull Transformation transformation;
    protected final @NonNull ScheduledRegion scheduledRegion;
    private @Nullable TransformationAnalysis2TracePackage transformationAnalysis2tracePackage = null;
    private final @NonNull Map<@NonNull Rule, @NonNull RuleAnalysis> rule2ruleAnalysis = new HashMap<Rule, RuleAnalysis>();
    private @NonNull Map<@NonNull Region, @NonNull RegionAnalysis> region2regionAnalysis = new HashMap<Region, RegionAnalysis>();
    private final @NonNull Map<@NonNull Property, @NonNull List<@NonNull Region>> corollaryProperty2regions = new HashMap<Property, List<Region>>();
    private @Nullable CyclicRegionsAnalysis cyclesRegionAnalysis = null;

    public TransformationAnalysis(@NonNull ScheduleManager scheduleManager, @NonNull Transformation transformation, @NonNull ScheduledRegion scheduledRegion) {
        super(scheduleManager);
        this.transformation = transformation;
        this.scheduledRegion = scheduledRegion;
        for (Rule asRule : QVTbaseUtil.getOwnedRules((Transformation)transformation)) {
            RuleAnalysis ruleAnalysis = scheduleManager.createRuleAnalysis(this, asRule);
            this.rule2ruleAnalysis.put(asRule, ruleAnalysis);
        }
    }

    public void addCorollary(@NonNull NavigableEdge edge) {
        assert (edge.isRealized());
        Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
        assert (targetNode.isRealized());
        Region region = QVTscheduleUtil.getOwningRegion((ConnectionEnd)edge);
        Property property = QVTscheduleUtil.getProperty((NavigableEdge)edge);
        List<@NonNull Region> regions = this.corollaryProperty2regions.get(property);
        if (regions == null) {
            regions = new ArrayList<Region>();
            this.corollaryProperty2regions.put(property, regions);
        }
        if (!regions.contains(region)) {
            regions.add(region);
        }
    }

    public void analyzeMappingRegions() {
        for (Rule asRule : QVTbaseUtil.getOwnedRules((Transformation)this.transformation)) {
            RuleAnalysis ruleAnalysis = this.getRuleAnalysis(asRule);
            ruleAnalysis.analyzeMappingRegion();
        }
        CompleteModel completeModel = this.environmentFactory.getCompleteModel();
        for (TypedModel typedModel : QVTbaseUtil.getModelParameters((Transformation)this.transformation)) {
            for (Package asPackage : QVTbaseUtil.getUsedPackages((TypedModel)typedModel)) {
                CompletePackage completePackage = completeModel.getCompletePackage(asPackage);
                this.scheduleManager.analyzeCompletePackage(typedModel, completePackage);
            }
        }
    }

    public void analyzeSourceModel() {
        for (RuleAnalysis ruleAnalysis : this.rule2ruleAnalysis.values()) {
            ruleAnalysis.analyzeSourceModel();
        }
    }

    protected @NonNull TraceClassRegionAnalysis createTraceClassAnalysis(@NonNull ClassDatum traceClassDatum) {
        return new TraceClassRegionAnalysis(this, traceClassDatum);
    }

    protected @NonNull TracePropertyRegionAnalysis createTracePropertyAnalysis(@NonNull TraceClassAnalysis<@NonNull RegionAnalysis> traceClassAnalysis, @NonNull PropertyDatum tracePropertyDatum) {
        return new TracePropertyRegionAnalysis(this, traceClassAnalysis, tracePropertyDatum);
    }

    public @NonNull Iterable<@NonNull RuleRegion> gatherRuleRegions() {
        ArrayList<@NonNull RuleRegion> ruleRegions = new ArrayList<RuleRegion>();
        for (RuleAnalysis ruleAnalysis : this.rule2ruleAnalysis.values()) {
            ruleAnalysis.gatherRuleRegions(ruleRegions);
        }
        Collections.sort(ruleRegions, NameUtil.NAMEABLE_COMPARATOR);
        return ruleRegions;
    }

    public @Nullable List<@NonNull Region> getCorollaryOf(@NonNull NavigableEdge edge) {
        return this.corollaryProperty2regions.get(edge.getProperty());
    }

    public String getName() {
        return this.transformation.getName();
    }

    public @NonNull RegionAnalysis getRegionAnalysis(@NonNull Region region) {
        RegionAnalysis regionAnalysis = this.region2regionAnalysis.get(region);
        if (regionAnalysis == null) {
            regionAnalysis = new RegionAnalysis(this, region);
            this.region2regionAnalysis.put(region, regionAnalysis);
        }
        return regionAnalysis;
    }

    public @NonNull RuleAnalysis getRuleAnalysis(@NonNull Rule rule) {
        return (RuleAnalysis)((Object)ClassUtil.nonNullState((Object)((Object)this.rule2ruleAnalysis.get(rule))));
    }

    public @NonNull ScheduledRegion getScheduledRegion() {
        return this.scheduledRegion;
    }

    public @NonNull Transformation getTransformation() {
        return this.transformation;
    }

    public @NonNull TransformationAnalysis2TracePackage getTransformationAnalysis2TracePackage() {
        TransformationAnalysis2TracePackage transformationAnalysis2tracePackage2 = this.transformationAnalysis2tracePackage;
        if (transformationAnalysis2tracePackage2 == null) {
            this.transformationAnalysis2tracePackage = transformationAnalysis2tracePackage2 = this.scheduleManager.createTransformationAnalysis2TracePackage(this);
        }
        return transformationAnalysis2tracePackage2;
    }

    public boolean isCorollary(@NonNull Node node) {
        block3: {
            block2: {
                if (!node.isPredicated()) break block2;
                for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                    List<Region> corollaryOf;
                    if (!edge.isPredicated() || edge.isSecondary() || !(edge instanceof NavigableEdge) || (corollaryOf = this.getCorollaryOf((NavigableEdge)edge)) == null) continue;
                    return true;
                }
                break block3;
            }
            if (!node.isRealized()) break block3;
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                List<Region> corollaryOf;
                if (!edge.isRealized() || edge.isSecondary() || !(edge instanceof NavigableEdge) || (corollaryOf = this.getCorollaryOf((NavigableEdge)edge)) == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCyclic(@NonNull TraceClassAnalysis<@NonNull RegionAnalysis> traceClassAnalysis) {
        assert (this.cyclesRegionAnalysis != null);
        return this.cyclesRegionAnalysis.isCyclic(traceClassAnalysis);
    }

    public boolean isCyclic(@NonNull RegionAnalysis regionAnalysis) {
        assert (this.cyclesRegionAnalysis != null);
        return this.cyclesRegionAnalysis.isCyclic(regionAnalysis);
    }

    public boolean isCyclic(@NonNull ClassDatum traceClassDatum) {
        TraceClassAnalysis<@NonNull RA> traceClassAnalysis = this.basicGetTraceClassAnalysis(traceClassDatum);
        if (traceClassAnalysis == null) {
            return false;
        }
        return ((TraceClassRegionAnalysis)traceClassAnalysis).isCyclic();
    }

    public void prePartition() throws CompilerChainException {
        if (this.scheduleManager.needsDiscrimination()) {
            this.computeTraceClassDiscrimination();
        }
        this.computeTraceClassInheritance();
        this.cyclesRegionAnalysis = new CyclicRegionsAnalysis(this.region2regionAnalysis.values());
    }

    public @NonNull String toString() {
        return String.valueOf(this.transformation);
    }
}

