/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.TraceClassRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.TracePropertyRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.IteratedEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class AbstractRegionAnalysis
implements CompilerUtil.PartialRegion<RegionAnalysis, TraceClassRegionAnalysis, TracePropertyRegionAnalysis> {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull AbstractTransformationAnalysis transformationAnalysis;
    private final @NonNull Map<@NonNull Node, @Nullable SuccessEdge> traceNode2globalSuccessEdge = new HashMap<Node, SuccessEdge>();
    private final @NonNull Map<@NonNull Node, @Nullable SuccessEdge> traceNode2localSuccessEdge = new HashMap<Node, SuccessEdge>();
    private final @NonNull List<@NonNull Node> constantInputNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Node> constantOutputNodes = new ArrayList<Node>();
    private @Nullable Node dispatchNode = null;
    private final @NonNull Map<@NonNull Node, @NonNull Edge> node2traceEdge = new HashMap<Node, Edge>();
    private final @NonNull Set<@NonNull NavigableEdge> oldPrimaryNavigableEdges = new HashSet<NavigableEdge>();
    private final @NonNull List<@NonNull Node> loadedInputNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Edge> predicatedEdges = new ArrayList<Edge>();
    private final @NonNull List<@NonNull NavigableEdge> predicatedMiddleEdges = new ArrayList<NavigableEdge>();
    private final @NonNull List<@NonNull Node> predicatedMiddleNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull NavigableEdge> predicatedOutputEdges = new ArrayList<NavigableEdge>();
    private final @NonNull List<@NonNull Node> predicatedOutputNodes = new ArrayList<Node>();
    private final @NonNull Set<@NonNull NavigableEdge> realizedEdges = new HashSet<NavigableEdge>();
    private final @NonNull List<@NonNull NavigableEdge> realizedMiddleEdges = new ArrayList<NavigableEdge>();
    private final @NonNull List<@NonNull Node> realizedMiddleNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull NavigableEdge> realizedOutputEdges = new ArrayList<NavigableEdge>();
    private final @NonNull List<@NonNull Node> realizedOutputNodes = new ArrayList<Node>();
    private final @NonNull Set<@NonNull SuccessEdge> successEdges = new HashSet<SuccessEdge>();
    private final @NonNull List<@NonNull Node> traceNodes = new ArrayList<Node>();
    private @Nullable List<@NonNull TraceClassRegionAnalysis> consumedTraceClassAnalyses = null;
    private @Nullable List<@NonNull TracePropertyRegionAnalysis> consumedTracePropertyAnalyses = null;
    private @Nullable List<@NonNull TraceClassRegionAnalysis> producedTraceClassAnalyses = null;
    private @Nullable List<@NonNull TracePropertyRegionAnalysis> producedTracePropertyAnalyses = null;
    private @Nullable Set<@NonNull TraceClassRegionAnalysis> superProducedTraceClassAnalyses = null;

    protected AbstractRegionAnalysis(@NonNull AbstractTransformationAnalysis transformationAnalysis) {
        this.scheduleManager = transformationAnalysis.getScheduleManager();
        this.transformationAnalysis = transformationAnalysis;
    }

    private void addConstantNode(@NonNull Node node) {
        assert (this.isConstant(node));
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!edge.isComputation() && (!edge.isCast() && !edge.isNavigation() || this.isRealized(edge))) continue;
            this.constantOutputNodes.add(node);
            return;
        }
        this.constantInputNodes.add(node);
    }

    private void addConsumptionOfEdge(@NonNull NavigableEdge edge) {
        Property property = QVTscheduleUtil.getProperty((NavigableEdge)edge);
        if (property == this.scheduleManager.getStandardLibraryHelper().getOclContainerProperty()) {
            Node targetNode;
            Node castTarget = targetNode = QVTscheduleUtil.getSourceNode((Edge)edge);
            ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)castTarget);
            for (PropertyDatum propertyDatum : this.scheduleManager.getOclContainerPropertyDatums(classDatum)) {
                this.addConsumptionOfPropertyDatum(propertyDatum);
            }
        } else {
            PropertyDatum propertyDatum = this.scheduleManager.getPropertyDatum(edge);
            this.addConsumptionOfPropertyDatum(propertyDatum);
        }
    }

    private void addConsumptionOfInputNode(@NonNull Node node) {
        if (node.isClass() && !this.loadedInputNodes.contains(node)) {
            this.loadedInputNodes.add(node);
            this.addConsumptionOfNode(node);
        }
    }

    private void addConsumptionOfMiddleEdge(@NonNull NavigableEdge edge) {
        if (!this.predicatedMiddleEdges.contains(edge)) {
            this.predicatedMiddleEdges.add(edge);
            this.addConsumptionOfEdge(edge);
        }
    }

    private void addConsumptionOfMiddleNode(@NonNull Node node) {
        if (!this.predicatedMiddleNodes.contains(node)) {
            this.predicatedMiddleNodes.add(node);
            this.addConsumptionOfNode(node);
        }
    }

    private void addConsumptionOfNode(@NonNull Node node) {
        Node castNode = QVTscheduleUtil.getCastTarget((Node)node);
        TraceClassRegionAnalysis consumedTraceAnalysis = this.transformationAnalysis.addConsumer(QVTscheduleUtil.getClassDatum((Node)castNode), this.getRegionAnalysis());
        List<@NonNull TraceClassRegionAnalysis> consumedTraceClassAnalyses2 = this.consumedTraceClassAnalyses;
        if (consumedTraceClassAnalyses2 == null) {
            this.consumedTraceClassAnalyses = consumedTraceClassAnalyses2 = new ArrayList<TraceClassRegionAnalysis>();
        }
        if (!consumedTraceClassAnalyses2.contains(consumedTraceAnalysis)) {
            consumedTraceClassAnalyses2.add(consumedTraceAnalysis);
        }
    }

    private void addConsumptionOfOutputEdge(@NonNull NavigableEdge edge) {
        if (!this.predicatedOutputEdges.contains(edge)) {
            this.predicatedOutputEdges.add(edge);
            this.addConsumptionOfEdge(edge);
        }
    }

    private void addConsumptionOfOutputNode(@NonNull Node node) {
        if (!this.predicatedOutputNodes.contains(node)) {
            this.predicatedOutputNodes.add(node);
            this.addConsumptionOfNode(node);
        }
    }

    private void addConsumptionOfPropertyDatum(@NonNull PropertyDatum propertyDatum) {
        TracePropertyRegionAnalysis consumedTraceAnalysis = this.transformationAnalysis.addConsumer(propertyDatum, this.getRegionAnalysis());
        List<@NonNull TracePropertyRegionAnalysis> consumedTracePropertyAnalyses2 = this.consumedTracePropertyAnalyses;
        if (consumedTracePropertyAnalyses2 == null) {
            this.consumedTracePropertyAnalyses = consumedTracePropertyAnalyses2 = new ArrayList<TracePropertyRegionAnalysis>();
        }
        if (!consumedTracePropertyAnalyses2.contains(consumedTraceAnalysis)) {
            consumedTracePropertyAnalyses2.add(consumedTraceAnalysis);
        }
    }

    private void addProductionOfEdge(@NonNull NavigableEdge edge) {
        TracePropertyRegionAnalysis oppositeProducedTraceAnalysis;
        PropertyDatum oppositePropertyDatum;
        assert (edge.isNew());
        Property property = QVTscheduleUtil.getProperty((NavigableEdge)edge);
        assert (property != this.scheduleManager.getStandardLibraryHelper().getOclContainerProperty());
        if (property.toString().contains("toA1") || property.toString().contains("ownsB")) {
            property.toString();
        }
        PropertyDatum propertyDatum = this.scheduleManager.getPropertyDatum(edge);
        TracePropertyRegionAnalysis producedTraceAnalysis = this.transformationAnalysis.addProducer(propertyDatum, this.getRegionAnalysis());
        List<@NonNull TracePropertyRegionAnalysis> producedTracePropertyAnalyses2 = this.producedTracePropertyAnalyses;
        if (producedTracePropertyAnalyses2 == null) {
            this.producedTracePropertyAnalyses = producedTracePropertyAnalyses2 = new ArrayList<TracePropertyRegionAnalysis>();
        }
        if (!producedTracePropertyAnalyses2.contains(producedTraceAnalysis)) {
            producedTracePropertyAnalyses2.add(producedTraceAnalysis);
        }
        if ((oppositePropertyDatum = propertyDatum.getOpposite()) != null && !producedTracePropertyAnalyses2.contains(oppositeProducedTraceAnalysis = this.transformationAnalysis.addProducer(oppositePropertyDatum, this.getRegionAnalysis()))) {
            producedTracePropertyAnalyses2.add(oppositeProducedTraceAnalysis);
        }
    }

    private void addProductionOfMiddleEdge(@NonNull NavigableEdge edge) {
        if (this.isRealized((Edge)edge) && !this.realizedMiddleEdges.contains(edge)) {
            this.realizedMiddleEdges.add(edge);
            this.addProductionOfEdge(edge);
        }
    }

    private void addProductionOfMiddleNode(@NonNull Node node) {
        if (this.isRealized(node) && !this.realizedMiddleNodes.contains(node)) {
            this.realizedMiddleNodes.add(node);
            this.addProductionOfNode(node);
        }
    }

    private void addProductionOfNode(@NonNull Node node) {
        assert (node.isNew());
        TraceClassRegionAnalysis consumedTraceAnalysis = this.transformationAnalysis.addProducer(QVTscheduleUtil.getClassDatum((Node)node), this.getRegionAnalysis());
        List<@NonNull TraceClassRegionAnalysis> producedTraceClassAnalyses2 = this.producedTraceClassAnalyses;
        if (producedTraceClassAnalyses2 == null) {
            this.producedTraceClassAnalyses = producedTraceClassAnalyses2 = new ArrayList<TraceClassRegionAnalysis>();
        }
        if (!producedTraceClassAnalyses2.contains(consumedTraceAnalysis)) {
            producedTraceClassAnalyses2.add(consumedTraceAnalysis);
        }
    }

    private void addProductionOfOutputEdge(@NonNull NavigableEdge edge) {
        if (this.isRealized((Edge)edge) && !this.realizedOutputEdges.contains(edge)) {
            this.realizedOutputEdges.add(edge);
            this.addProductionOfEdge(edge);
        }
    }

    private void addProductionOfOutputNode(@NonNull Node node) {
        if (this.isRealized(node) && !this.realizedOutputNodes.contains(node)) {
            this.realizedOutputNodes.add(node);
            this.addProductionOfNode(node);
        }
    }

    protected @NonNull List<@NonNull Node> analyze() {
        this.analyzeNodes();
        for (Node traceNode : this.analyzeTraceNodes()) {
            this.analyzeLocalSuccessEdge(traceNode);
            this.analyzeGlobalSuccessEdge(traceNode);
            this.analyzeTraceEdges(traceNode);
        }
        this.analyzeEdges();
        ArrayList<@NonNull Node> alreadyRealized = new ArrayList<Node>(this.getTraceNodes());
        Node dispatchNode = this.basicGetDispatchNode();
        if (dispatchNode != null) {
            alreadyRealized.add(dispatchNode);
        }
        return alreadyRealized;
    }

    private void analyzeEdges() {
        for (Edge edge : this.getPartialEdges()) {
            if (edge.isSecondary()) continue;
            if (this.isPredicated(edge)) {
                this.predicatedEdges.add(edge);
            }
            if (edge instanceof NavigableEdge) {
                Node sourceNode;
                NavigableEdge navigableEdge = (NavigableEdge)edge;
                if (navigableEdge.isSuccess()) {
                    this.successEdges.add((SuccessEdge)navigableEdge);
                }
                if (this.isRealized((Edge)navigableEdge)) {
                    this.realizedEdges.add(navigableEdge);
                } else {
                    this.oldPrimaryNavigableEdges.add(navigableEdge);
                }
                if (!this.isRealized((Edge)navigableEdge) && navigableEdge.isMatched() && !navigableEdge.isCast()) {
                    assert (!navigableEdge.isExpression());
                    assert (!navigableEdge.isComputation());
                }
                if (this.scheduleManager.isMiddle(sourceNode = navigableEdge.getEdgeSource())) {
                    if (this.isPredicated((Edge)navigableEdge) || this.isSpeculated((Edge)navigableEdge)) {
                        this.addConsumptionOfMiddleEdge(navigableEdge);
                        continue;
                    }
                    if (this.isRealized((Edge)navigableEdge)) {
                        this.addProductionOfMiddleEdge(navigableEdge);
                        continue;
                    }
                    throw new IllegalStateException("middle edge must be predicated or realized : " + navigableEdge);
                }
                if (this.isLoaded((Edge)navigableEdge) || this.isConstant((Edge)navigableEdge)) continue;
                if (this.isPredicated((Edge)navigableEdge)) {
                    if (navigableEdge.isCast()) continue;
                    this.addConsumptionOfOutputEdge(navigableEdge);
                    continue;
                }
                if (this.isRealized((Edge)navigableEdge)) {
                    this.addProductionOfOutputEdge(navigableEdge);
                    continue;
                }
                throw new IllegalStateException("other edge must be predicated or realized : " + navigableEdge);
            }
            if (edge.isExpression() || edge instanceof IteratedEdge || edge.isDependency()) continue;
            throw new IllegalStateException("unsupported analyzeEdge : " + edge);
        }
    }

    private void analyzeGlobalSuccessEdge(@NonNull Node traceNode) {
        NavigationEdge statusNavigationEdge;
        SuccessEdge globalSuccessEdge = null;
        Property globalSuccessProperty = this.scheduleManager.basicGetGlobalSuccessProperty(traceNode);
        if (globalSuccessProperty != null && (statusNavigationEdge = QVTscheduleUtil.basicGetNavigationEdge((Node)traceNode, (Property)globalSuccessProperty)) != null) {
            globalSuccessEdge = (SuccessEdge)statusNavigationEdge;
        }
        this.traceNode2globalSuccessEdge.put(traceNode, globalSuccessEdge);
    }

    protected void analyzeLocalSuccessEdge(@NonNull Node traceNode) {
        NavigationEdge statusNavigationEdge;
        SuccessEdge localSuccessEdge = null;
        Property localSuccessProperty = this.scheduleManager.basicGetLocalSuccessProperty(traceNode);
        if (localSuccessProperty != null && (statusNavigationEdge = QVTscheduleUtil.basicGetNavigationEdge((Node)traceNode, (Property)localSuccessProperty)) != null) {
            localSuccessEdge = (SuccessEdge)statusNavigationEdge;
        }
        this.traceNode2localSuccessEdge.put(traceNode, localSuccessEdge);
    }

    private void analyzeNodes() {
        for (Node node : this.getPartialNodes()) {
            if (node.isDependency()) {
                this.addConsumptionOfOutputNode(node);
                continue;
            }
            boolean isOperation = node.isOperation();
            boolean isPattern = node.isPattern();
            boolean isIterator = node.isIterator();
            if (!(isOperation || isPattern || isIterator)) {
                throw new IllegalStateException("unsupported analyzeNode : " + node);
            }
            boolean isMiddle = this.scheduleManager.isMiddle(node);
            if (isMiddle && !isOperation) {
                if (node.isDispatch()) {
                    if (this.dispatchNode != null) {
                        throw new IllegalStateException();
                    }
                    this.dispatchNode = node;
                } else if (node.isTrace()) {
                    this.traceNodes.add(node);
                }
            }
            if (this.isConstant(node)) {
                if (!isOperation) continue;
                this.addConstantNode(node);
                continue;
            }
            if (this.isLoaded(node)) {
                this.addConsumptionOfInputNode(node);
                continue;
            }
            if (this.isPredicated(node)) {
                if (isMiddle) {
                    this.addConsumptionOfMiddleNode(node);
                    continue;
                }
                this.addConsumptionOfOutputNode(node);
                continue;
            }
            if (this.isSpeculated(node) && isMiddle && !isOperation) {
                if (node.isHead()) continue;
                this.addConsumptionOfMiddleNode(node);
                continue;
            }
            if (this.isSpeculation(node) || this.isRealized(node)) {
                if (isOperation) continue;
                if (isMiddle) {
                    this.addProductionOfMiddleNode(node);
                    continue;
                }
                this.addProductionOfOutputNode(node);
                continue;
            }
            throw new IllegalStateException(String.valueOf(isMiddle ? "middle" : "other") + " node must be predicated or realized : " + node);
        }
    }

    private void analyzeTraceEdges(@NonNull Node traceNode) {
        for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)traceNode)) {
            if (!edge.isCast() && !edge.isNavigation() || !this.isRealized(edge)) continue;
            Node tracedNode = QVTscheduleUtil.getTargetNode((Edge)edge);
            this.node2traceEdge.put(tracedNode, edge);
        }
    }

    private @NonNull Iterable<@NonNull Node> analyzeTraceNodes() {
        return Iterables.concat(this.getPredicatedMiddleNodes(), this.getRealizedMiddleNodes());
    }

    public @Nullable Node basicGetDispatchNode() {
        return this.dispatchNode;
    }

    public @Nullable SuccessEdge basicGetGlobalSuccessEdge(@NonNull Node traceNode) {
        return this.traceNode2globalSuccessEdge.get(traceNode);
    }

    public @Nullable Node basicGetGlobalSuccessNode(@NonNull Node traceNode) {
        SuccessEdge successEdge = this.traceNode2globalSuccessEdge.get(traceNode);
        return successEdge != null ? successEdge.getTargetNode() : null;
    }

    public @Nullable SuccessEdge basicGetLocalSuccessEdge(@NonNull Node traceNode) {
        return this.traceNode2localSuccessEdge.get(traceNode);
    }

    public @Nullable Node basicGetLocalSuccessNode(@NonNull Node traceNode) {
        SuccessEdge successEdge = this.traceNode2localSuccessEdge.get(traceNode);
        return successEdge != null ? successEdge.getTargetNode() : null;
    }

    public @NonNull Iterable<@NonNull Node> getConstantInputNodes() {
        return this.constantInputNodes;
    }

    public @NonNull Iterable<@NonNull Node> getConstantOutputNodes() {
        return this.constantOutputNodes;
    }

    @Override
    public @Nullable Iterable<@NonNull TraceClassRegionAnalysis> getConsumedTraceClassAnalyses() {
        return this.consumedTraceClassAnalyses;
    }

    @Override
    public @Nullable Iterable<@NonNull TracePropertyRegionAnalysis> getConsumedTracePropertyAnalyses() {
        return this.consumedTracePropertyAnalyses;
    }

    public @NonNull SuccessEdge getGlobalSuccessEdge(@NonNull Node traceNode) {
        return (SuccessEdge)ClassUtil.nonNullState((Object)this.traceNode2globalSuccessEdge.get(traceNode));
    }

    public @NonNull Node getGlobalSuccessNode(@NonNull Node traceNode) {
        SuccessEdge successEdge = (SuccessEdge)ClassUtil.nonNullState((Object)this.traceNode2globalSuccessEdge.get(traceNode));
        return QVTscheduleUtil.getTargetNode((Edge)successEdge);
    }

    public @NonNull SuccessEdge getLocalSuccessEdge(@NonNull Node traceNode) {
        return (SuccessEdge)ClassUtil.nonNullState((Object)this.traceNode2localSuccessEdge.get(traceNode));
    }

    public @NonNull Node getLocalSuccessNode(@NonNull Node traceNode) {
        SuccessEdge successEdge = (SuccessEdge)ClassUtil.nonNullState((Object)this.traceNode2localSuccessEdge.get(traceNode));
        return QVTscheduleUtil.getTargetNode((Edge)successEdge);
    }

    protected abstract @NonNull Iterable<@NonNull Edge> getPartialEdges();

    protected abstract @NonNull Iterable<@NonNull Node> getPartialNodes();

    public @NonNull Iterable<@NonNull NavigableEdge> getOldPrimaryNavigableEdges() {
        return this.oldPrimaryNavigableEdges;
    }

    public @NonNull Iterable<@NonNull Edge> getPredicatedEdges() {
        return this.predicatedEdges;
    }

    public @NonNull Iterable<@NonNull Node> getPredicatedMiddleNodes() {
        return this.predicatedMiddleNodes;
    }

    public @NonNull Iterable<@NonNull Node> getPredicatedOutputNodes() {
        return this.predicatedOutputNodes;
    }

    public @Nullable Iterable<@NonNull TraceClassRegionAnalysis> getProducedTraceClassAnalyses() {
        return this.producedTraceClassAnalyses;
    }

    public @Nullable Iterable<@NonNull TracePropertyRegionAnalysis> getProducedTracePropertyAnalyses() {
        return this.producedTracePropertyAnalyses;
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getRealizedEdges() {
        return this.realizedEdges;
    }

    public @NonNull Iterable<@NonNull Node> getRealizedMiddleNodes() {
        return this.realizedMiddleNodes;
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getRealizedOutputEdges() {
        return this.realizedOutputEdges;
    }

    public @NonNull Iterable<@NonNull Node> getRealizedOutputNodes() {
        return this.realizedOutputNodes;
    }

    private @NonNull RegionAnalysis getRegionAnalysis() {
        return (RegionAnalysis)this;
    }

    public @Nullable Role getRole(@NonNull Edge edge) {
        return edge.getEdgeRole();
    }

    public @Nullable Role getRole(@NonNull Node node) {
        return node.getNodeRole();
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @NonNull Iterable<@NonNull SuccessEdge> getSuccessEdges() {
        return this.successEdges;
    }

    public @Nullable Iterable<@NonNull TraceClassRegionAnalysis> getSuperProducedTraceClassAnalyses() {
        List<@NonNull TraceClassRegionAnalysis> producedTraceClassAnalyses2 = this.producedTraceClassAnalyses;
        if (producedTraceClassAnalyses2 != null) {
            Set<@NonNull TraceClassRegionAnalysis> superProducedTraceClassAnalyses2 = this.superProducedTraceClassAnalyses;
            if (superProducedTraceClassAnalyses2 == null) {
                this.superProducedTraceClassAnalyses = superProducedTraceClassAnalyses2 = new HashSet<TraceClassRegionAnalysis>();
            }
            for (TraceClassRegionAnalysis producedTraceClassAnalysis : producedTraceClassAnalyses2) {
                Iterables.addAll(superProducedTraceClassAnalyses2, producedTraceClassAnalysis.getSuperTraceClassAnalyses());
            }
        }
        return this.superProducedTraceClassAnalyses;
    }

    public @NonNull TraceClassRegionAnalysis getTraceClassAnalysis(@NonNull ClassDatum traceClassDatum) {
        return this.transformationAnalysis.getTraceClassAnalysis(traceClassDatum);
    }

    public @NonNull TracePropertyRegionAnalysis getTracePropertyAnalysis(@NonNull PropertyDatum propertyDatum) {
        return this.transformationAnalysis.getTracePropertyAnalysis(propertyDatum);
    }

    public @Nullable Edge getTraceEdge(@NonNull Node node) {
        return this.node2traceEdge.get(node);
    }

    public @NonNull List<@NonNull Node> getTraceNodes() {
        return this.traceNodes;
    }

    protected boolean isConstant(@NonNull Edge edge) {
        return edge.isConstant();
    }

    protected boolean isConstant(@NonNull Node node) {
        return node.isConstant();
    }

    protected boolean isLoaded(@NonNull Edge edge) {
        return edge.isLoaded();
    }

    protected boolean isLoaded(@NonNull Node node) {
        return node.isLoaded();
    }

    protected boolean isPredicated(@NonNull Edge edge) {
        return edge.isPredicated();
    }

    protected boolean isPredicated(@NonNull Node node) {
        return node.isPredicated();
    }

    protected boolean isRealized(@NonNull Edge edge) {
        return edge.isRealized();
    }

    protected boolean isRealized(@NonNull Node node) {
        return node.isRealized();
    }

    protected boolean isSpeculated(@NonNull Edge edge) {
        return edge.isSpeculated();
    }

    protected boolean isSpeculated(@NonNull Node node) {
        return node.isSpeculated();
    }

    protected boolean isSpeculation(@NonNull Node node) {
        return node.isSpeculation();
    }
}

