/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.cst.ClassifierDefCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ConfigPropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ContextualPropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.LocalPropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingMethodCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingQueryCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingRuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModulePropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ParameterDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ScopedNameCS;
import org.eclipse.m2m.internal.qvt.oml.cst.TransformationHeaderCS;
import org.eclipse.m2m.internal.qvt.oml.cst.TypeSpecCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.CompletionProposalUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline.QvtOutlineInformationControl;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline.actions.ShowFQNAction;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.swt.graphics.Image;

public class OutlineLabelProvider
implements ILabelProvider {
    private final ShowFQNAction myShowFQNAction;

    public OutlineLabelProvider(QvtOutlineInformationControl qvtOutlineInformationControl) {
        this.myShowFQNAction = qvtOutlineInformationControl.getShowFQNAction();
    }

    public String getText(Object element) {
        ClassifierDefCS classifierDefCS;
        SimpleNameCS simpleNameCS;
        if (element instanceof MappingModuleCS) {
            PathNameCS nameCS;
            MappingModuleCS mappingModuleCS = (MappingModuleCS)element;
            TransformationHeaderCS headerCS = mappingModuleCS.getHeaderCS();
            if (headerCS != null && (nameCS = headerCS.getPathNameCS()) != null) {
                return QvtOperationalParserUtil.getStringRepresentation((PathNameCS)nameCS, (String)".");
            }
        } else if (element instanceof MappingMethodCS) {
            MappingMethodCS mappingMethodCS = (MappingMethodCS)element;
            MappingDeclarationCS mappingDeclarationCS = mappingMethodCS.getMappingDeclarationCS();
            if (mappingDeclarationCS != null) {
                return this.getDeclaration(mappingDeclarationCS);
            }
        } else if (element instanceof ModulePropertyCS) {
            ModulePropertyCS modulePropertyCS = (ModulePropertyCS)element;
            TypeCS returnTypeCS = null;
            if (modulePropertyCS instanceof LocalPropertyCS) {
                returnTypeCS = ((LocalPropertyCS)modulePropertyCS).getTypeCS();
            } else if (modulePropertyCS instanceof ContextualPropertyCS) {
                returnTypeCS = ((ContextualPropertyCS)modulePropertyCS).getTypeCS();
            } else if (modulePropertyCS instanceof ConfigPropertyCS) {
                returnTypeCS = ((ConfigPropertyCS)modulePropertyCS).getTypeCS();
            }
            SimpleNameCS simpleNameCS2 = modulePropertyCS.getSimpleNameCS();
            if (simpleNameCS2 != null) {
                TypeCS contextTypeCS;
                ContextualPropertyCS contextualPropertyCS;
                ScopedNameCS scopedNameCS;
                String labelText = simpleNameCS2.getValue();
                if (this.isShowFQN() && modulePropertyCS instanceof ContextualPropertyCS && (scopedNameCS = (contextualPropertyCS = (ContextualPropertyCS)modulePropertyCS).getScopedNameCS()) != null && (contextTypeCS = scopedNameCS.getTypeCS()) != null) {
                    labelText = String.valueOf(QvtOperationalParserUtil.getStringRepresentation((TypeCS)contextTypeCS)) + "::" + labelText;
                }
                if (returnTypeCS != null) {
                    labelText = String.valueOf(labelText) + " : " + QvtOperationalParserUtil.getStringRepresentation((TypeCS)returnTypeCS);
                }
                return labelText;
            }
        } else if (element instanceof ClassifierDefCS && (simpleNameCS = (classifierDefCS = (ClassifierDefCS)element).getSimpleNameCS()) != null) {
            return simpleNameCS.getValue();
        }
        return null;
    }

    private String getDeclaration(MappingDeclarationCS mappingDeclarationCS) {
        TypeCS returnType;
        TypeSpecCS returnTypeSpec;
        SimpleNameCS mappingName;
        TypeCS contextType;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isShowFQN() && (contextType = mappingDeclarationCS.getContextType()) != null) {
            stringBuilder.append(QvtOperationalParserUtil.getStringRepresentation((TypeCS)contextType));
            stringBuilder.append("::");
        }
        if ((mappingName = mappingDeclarationCS.getSimpleNameCS()) != null) {
            stringBuilder.append(mappingName.getValue());
            stringBuilder.append('(');
            boolean isFirstParam = true;
            for (ParameterDeclarationCS param : mappingDeclarationCS.getParameters()) {
                SimpleNameCS paramName;
                TypeCS paramType;
                TypeSpecCS paramTypeSpec;
                if (!isFirstParam) {
                    stringBuilder.append(", ");
                }
                if ((paramTypeSpec = param.getTypeSpecCS()) != null && (paramType = paramTypeSpec.getTypeCS()) != null) {
                    stringBuilder.append(QvtOperationalParserUtil.getStringRepresentation((TypeCS)paramType));
                }
                if ((paramName = param.getSimpleNameCS()) != null) {
                    stringBuilder.append(' ');
                    stringBuilder.append(paramName.getValue());
                }
                isFirstParam = false;
            }
            stringBuilder.append(')');
        }
        TypeSpecCS typeSpecCS = returnTypeSpec = !mappingDeclarationCS.getResult().isEmpty() ? ((ParameterDeclarationCS)mappingDeclarationCS.getResult().get(0)).getTypeSpecCS() : null;
        if (returnTypeSpec != null && (returnType = returnTypeSpec.getTypeCS()) != null) {
            stringBuilder.append(" : ");
            stringBuilder.append(QvtOperationalParserUtil.getStringRepresentation((TypeCS)returnType));
        }
        return stringBuilder.toString();
    }

    public Image getImage(Object element) {
        if (element instanceof MappingModuleCS) {
            return CompletionProposalUtil.getImage("cat-package");
        }
        if (element instanceof MappingRuleCS) {
            return CompletionProposalUtil.getImage("cat-mapping");
        }
        if (element instanceof MappingQueryCS) {
            return CompletionProposalUtil.getImage("cat-imperative-operation");
        }
        if (element instanceof ModulePropertyCS) {
            return CompletionProposalUtil.getImage("cat-property");
        }
        if (element instanceof ClassifierDefCS) {
            return CompletionProposalUtil.getImage("cat-class");
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean isShowFQN() {
        return this.myShowFQNAction.isChecked();
    }
}

