/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.ant;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchConfigurationDelegateBase;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtInterpretedTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;

public class TaskModel {
    private final String myTaskName;
    private final String myModuleUri;
    private final String myTraceFile;
    private final boolean myIsUseTraceFile;
    private final boolean myIsIncrementalUpdate;
    private final List<TargetUriData> myTargetUris;
    private final Map<String, Object> myConfigProps;
    private final QvtTransformation myTransformation;
    private final Map<String, Object> myAttributes;
    private static final String INDENT = "    ";

    public TaskModel(ILaunchConfiguration config, String name) throws CoreException {
        this.myTaskName = name;
        this.myModuleUri = QvtLaunchUtil.getTransformationURI((ILaunchConfiguration)config);
        this.myTraceFile = QvtLaunchUtil.getTraceFileURI((ILaunchConfiguration)config);
        this.myIsUseTraceFile = QvtLaunchUtil.shouldGenerateTraceFile((ILaunchConfiguration)config);
        this.myIsIncrementalUpdate = QvtLaunchUtil.isIncrementalUpdate((ILaunchConfiguration)config);
        this.myTargetUris = QvtLaunchUtil.getTargetUris((ILaunchConfiguration)config);
        this.myConfigProps = QvtLaunchUtil.getConfigurationProperty((ILaunchConfiguration)config);
        this.myAttributes = new LinkedHashMap<String, Object>();
        this.myAttributes.put("org.eclipse.m2m.qvt.oml.interpreter.module".substring("org.eclipse.m2m.qvt.oml.interpreter.".length()), this.myModuleUri);
        this.myAttributes.put("org.eclipse.m2m.qvt.oml.interpreter.traceFile".substring("org.eclipse.m2m.qvt.oml.interpreter.".length()), this.myTraceFile);
        this.myTransformation = new QvtInterpretedTransformation(QvtLaunchConfigurationDelegateBase.getQvtModule((ILaunchConfiguration)config));
    }

    public String getTaskName() {
        return this.myTaskName;
    }

    public String getName() {
        try {
            return this.myTransformation.getModuleName();
        }
        catch (MdaException mdaException) {
            return "";
        }
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.myAttributes);
    }

    public String toString() {
        try {
            return this.toXMLString();
        }
        catch (MdaException mdaException) {
            return "";
        }
    }

    public String toXMLString() throws MdaException {
        String result = "";
        result = String.valueOf(result) + "<" + this.myTaskName + "\n";
        result = String.valueOf(result) + "    uri=\"" + this.myModuleUri + "\"\n";
        result = String.valueOf(result) + "    >\n";
        if (!this.myTargetUris.isEmpty()) {
            result = String.valueOf(result) + "\n";
        }
        Iterator<TargetUriData> itrTargetUri = this.myTargetUris.iterator();
        for (QvtTransformation.TransformationParameter transformationParameter : this.myTransformation.getParameters()) {
            if (!itrTargetUri.hasNext()) break;
            TargetUriData targetUri = itrTargetUri.next();
            if (transformationParameter.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.IN) {
                result = String.valueOf(result) + "    <in\n";
                result = String.valueOf(result) + "        uri=\"" + targetUri.getUriString() + "\"\n";
                result = String.valueOf(result) + "    />";
            } else if (transformationParameter.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.INOUT) {
                result = String.valueOf(result) + "    <inout\n";
                result = String.valueOf(result) + "        uri=\"" + targetUri.getUriString() + "\"\n";
                result = String.valueOf(result) + "        outuri=\"" + targetUri.getUriString() + "\"\n";
                result = String.valueOf(result) + "    />";
            } else if (transformationParameter.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.OUT) {
                result = String.valueOf(result) + "    <out\n";
                result = String.valueOf(result) + "        uri=\"" + targetUri.getUriString();
                String feature = targetUri.getFeature();
                if (feature != null && feature.trim().length() > 0) {
                    result = String.valueOf(result) + "\">\n";
                    result = String.valueOf(result) + "        <feature\n";
                    result = String.valueOf(result) + "            name=\"" + targetUri.getFeature() + "\"\n";
                    result = String.valueOf(result) + "            clearcontents=\"" + Boolean.valueOf(targetUri.isClearContents()).toString() + "\"\n";
                    result = String.valueOf(result) + "        />\n";
                    result = String.valueOf(result) + "    </out>";
                } else {
                    result = String.valueOf(result) + "\"\n";
                    result = String.valueOf(result) + "    />";
                }
            }
            result = String.valueOf(result) + "\n";
        }
        if ((this.myIsUseTraceFile || this.myIsIncrementalUpdate) && this.myTraceFile != null && this.myTraceFile.trim().length() > 0) {
            result = String.valueOf(result) + "\n";
            result = String.valueOf(result) + "    <trace\n";
            result = String.valueOf(result) + "        uri=\"" + this.myTraceFile + "\"\n";
            result = String.valueOf(result) + "        generate=\"" + this.myIsUseTraceFile + "\"\n";
            result = String.valueOf(result) + "        incrementalUpdate=\"" + this.myIsIncrementalUpdate + "\"\n";
            result = String.valueOf(result) + "    />\n";
        }
        if (!this.myConfigProps.isEmpty()) {
            result = String.valueOf(result) + "\n";
            result = String.valueOf(result) + "    <configProperty\n";
        }
        for (Map.Entry entry : this.myConfigProps.entrySet()) {
            Object value = entry.getValue();
            if (value == null || value.toString() == "") continue;
            result = String.valueOf(result) + "        name=\"" + (String)entry.getKey() + "\"\n";
            result = String.valueOf(result) + "        value=\"" + value + "\"\n";
        }
        if (!this.myConfigProps.isEmpty()) {
            result = String.valueOf(result) + "    />\n";
        }
        result = String.valueOf(result) + "</" + this.myTaskName + ">\n";
        return result;
    }

    public static String indentString(String s, String indent, String delim) {
        String result = "";
        String[] strings = s.split("\\n");
        int i = 0;
        while (i < strings.length) {
            result = String.valueOf(result) + indent + strings[i] + (i < strings.length - 1 ? delim : "");
            ++i;
        }
        return result;
    }
}

