/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typing;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.xbase.typing.ICallableFeatureFacade;
import org.eclipse.xtext.xbase.typing.TypesService;
import org.eclipse.xtext.xpression.XAssignment;
import org.eclipse.xtext.xpression.XBlockExpression;
import org.eclipse.xtext.xpression.XBooleanLiteral;
import org.eclipse.xtext.xpression.XCasePart;
import org.eclipse.xtext.xpression.XCastedExpression;
import org.eclipse.xtext.xpression.XClosure;
import org.eclipse.xtext.xpression.XConstructorCall;
import org.eclipse.xtext.xpression.XFeatureCall;
import org.eclipse.xtext.xpression.XInstanceOfExpression;
import org.eclipse.xtext.xpression.XIntLiteral;
import org.eclipse.xtext.xpression.XNullLiteral;
import org.eclipse.xtext.xpression.XRichString;
import org.eclipse.xtext.xpression.XStringLiteral;
import org.eclipse.xtext.xpression.XSwitchExpression;
import org.eclipse.xtext.xpression.XTypeLiteral;
import org.eclipse.xtext.xpression.XVariableDeclaration;
import org.eclipse.xtext.xpression.XWhileExpression;

public class ExpressionsTypeResolver {
    static final ExpectedTypesProvider NO_EXPECTED_TYPES = new ExpectedTypesProvider(){

        public Set<JvmTypeReference> get() {
            return Collections.emptySet();
        }
    };
    public static final String JAVA_LANG_CLASS = Class.class.getName();
    public static final String INTEGER_TYPE_NAME = Long.class.getName();
    public static final String VOID_TYPE_NAME = Void.class.getName();
    public static final String BOOLEAN_TYPE_NAME = Boolean.class.getName();
    public static final String STRING_TYPE_NAME = String.class.getName();
    public static final String OBJECT_TYPE_NAME = Object.class.getName();
    private final PolymorphicDispatcher<JvmTypeReference> dispatcher = PolymorphicDispatcher.createForSingleTarget((String)"_case", (int)2, (int)2, (Object)this);
    @Inject
    private TypesService typesService;
    @Inject
    private ICallableFeatureFacade callableFeatureFacade;

    public JvmTypeReference doSwitch(EObject exprNode, ExpectedTypesProvider expected) {
        return (JvmTypeReference)this.dispatcher.invoke(new Object[]{exprNode, expected == null ? NO_EXPECTED_TYPES : expected});
    }

    protected JvmTypeReference _case(XIntLiteral object, ExpectedTypesProvider expected) {
        return this.typesService.getTypeForName(INTEGER_TYPE_NAME, object, new JvmTypeReference[0]);
    }

    protected JvmTypeReference _case(XBlockExpression object, ExpectedTypesProvider expected) {
        return this.doSwitch((EObject)object.getExpressions().get(object.getExpressions().size() - 1), expected);
    }

    protected JvmTypeReference _case(XSwitchExpression object, ExpectedTypesProvider expected) {
        ArrayList returnTypes = Lists.newArrayList();
        EList<XCasePart> cases = object.getCases();
        for (XCasePart xCasePart : cases) {
            returnTypes.add(this.doSwitch(xCasePart, expected));
        }
        if (object.getDefault() != null) {
            returnTypes.add(this.doSwitch(object.getDefault(), expected));
        }
        return this.typesService.getCommonType(returnTypes);
    }

    protected JvmTypeReference _case(XCasePart object, ExpectedTypesProvider expected) {
        return this.doSwitch(object.getThen(), expected);
    }

    protected JvmTypeReference _case(XVariableDeclaration object, ExpectedTypesProvider expected) {
        return this.typesService.getTypeForName(VOID_TYPE_NAME, object, new JvmTypeReference[0]);
    }

    protected JvmTypeReference _case(XFeatureCall object, ExpectedTypesProvider expected) {
        return this.callableFeatureFacade.getReturnType(object.getFeature());
    }

    protected JvmTypeReference _case(XConstructorCall object, ExpectedTypesProvider expected) {
        return object.getType();
    }

    protected JvmTypeReference _case(XBooleanLiteral object, ExpectedTypesProvider expected) {
        return this.typesService.getTypeForName(BOOLEAN_TYPE_NAME, object, new JvmTypeReference[0]);
    }

    protected JvmTypeReference _case(XNullLiteral object, ExpectedTypesProvider expected) {
        return this.typesService.getTypeForName(VOID_TYPE_NAME, object, new JvmTypeReference[0]);
    }

    protected JvmTypeReference _case(XStringLiteral object, ExpectedTypesProvider expected) {
        return this.typesService.getTypeForName(STRING_TYPE_NAME, object, new JvmTypeReference[0]);
    }

    protected JvmTypeReference _case(XRichString object, ExpectedTypesProvider expected) {
        return this.typesService.getTypeForName(STRING_TYPE_NAME, object, new JvmTypeReference[0]);
    }

    protected JvmTypeReference _case(XClosure object, ExpectedTypesProvider expected) {
        JvmTypeReference returnType = this.doSwitch(object.getExpression(), expected);
        ArrayList parameterTypes = Lists.newArrayList();
        EList<JvmFormalParameter> params = object.getParams();
        for (JvmFormalParameter param : params) {
            if (param.getParameterType() != null) {
                parameterTypes.add(param.getParameterType());
                continue;
            }
            throw new IllegalStateException("Type inference for closure params is not yet supported.");
        }
        return this.typesService.createFunctionTypeRef(parameterTypes, returnType);
    }

    protected JvmTypeReference _case(XCastedExpression object) {
        return object.getType();
    }

    protected JvmTypeReference _case(XAssignment object) {
        return this.typesService.getTypeForName(VOID_TYPE_NAME, object, new JvmTypeReference[0]);
    }

    protected JvmTypeReference _case(XWhileExpression object) {
        return this.typesService.getTypeForName(VOID_TYPE_NAME, object, new JvmTypeReference[0]);
    }

    protected JvmTypeReference _case(XTypeLiteral object) {
        JvmParameterizedTypeReference paramType = this.typesService.createJvmTypeReference(object.getType());
        return this.typesService.getTypeForName(JAVA_LANG_CLASS, object, new JvmTypeReference[]{paramType});
    }

    protected JvmTypeReference _case(XInstanceOfExpression object) {
        return this.typesService.getTypeForName(BOOLEAN_TYPE_NAME, object, new JvmTypeReference[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ExpectedTypesProvider
    extends Provider<Set<JvmTypeReference>> {
    }
}

