/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.launcher;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.ui.editor.outline.ContentOutlineNode;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class SelectionUtil {
    public static IFile getSelectedFile(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof TextSelection) {
            IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            return SelectionUtil.getSelectedFile(activeEditor);
        }
        if (selection instanceof IStructuredSelection) {
            return SelectionUtil.getSelectedFile(selection);
        }
        return null;
    }

    public static IFile getSelectedFile(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return fileEditorInput.getFile();
        }
        return null;
    }

    public static IFile getSelectedFile(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Object firstElement = ssel.getFirstElement();
            if (firstElement instanceof IAdaptable) {
                return (IFile)((IAdaptable)firstElement).getAdapter(IFile.class);
            }
            if (firstElement instanceof ContentOutlineNode) {
                ContentOutlineNode outlineNode = (ContentOutlineNode)firstElement;
                return (IFile)outlineNode.getEObjectHandle().readOnly((IUnitOfWork)new IUnitOfWork<IFile, EObject>(){

                    public IFile exec(EObject state) throws Exception {
                        Resource resource = state.eResource();
                        URI uri = resource.getURI();
                        Path path = new Path(uri.toPlatformString(true));
                        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                    }
                });
            }
        }
        return null;
    }
}

