/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.ui.contentassist;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.AbstractJavaBasedContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.util.Strings;

public class TerminalsProposalProvider
extends AbstractJavaBasedContentProposalProvider {
    public void complete_ID(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (this.doCreateIdProposals()) {
            final PrefixMatcher oldMatcher = context.getMatcher();
            try {
                ICompletionProposal proposal;
                String proposalText;
                PrefixMatcher newMatcher = new PrefixMatcher(){

                    public boolean isCandidateMatchingPrefix(String name, String prefix) {
                        String strippedName = name;
                        if (name.startsWith("^") && !prefix.startsWith("^")) {
                            strippedName = name.substring(1);
                        }
                        return oldMatcher.isCandidateMatchingPrefix(strippedName, prefix);
                    }
                };
                context.setMatcher(newMatcher);
                String feature = this.getAssignedFeature(ruleCall);
                String displayText = proposalText = feature != null ? feature : Strings.toFirstUpper((String)ruleCall.getRule().getName().toLowerCase());
                if (feature != null) {
                    displayText = String.valueOf(proposalText) + " - " + ruleCall.getRule().getName();
                }
                if ((proposal = this.createCompletionProposal(proposalText = this.getValueConverter().toString((Object)proposalText, ruleCall.getRule().getName()), displayText, null, context)) instanceof ConfigurableCompletionProposal) {
                    ConfigurableCompletionProposal configurable = (ConfigurableCompletionProposal)proposal;
                    configurable.setSelectionStart(configurable.getReplacementOffset());
                    configurable.setSelectionLength(proposalText.length());
                    configurable.setAutoInsertable(false);
                    configurable.setSimpleLinkedMode(context.getViewer(), '\t', ' ');
                }
                acceptor.accept(proposal);
            }
            finally {
                context.setMatcher(oldMatcher);
            }
        }
    }

    private String getAssignedFeature(RuleCall call) {
        Assignment ass = GrammarUtil.containingAssignment((EObject)call);
        if (ass != null) {
            String result = ass.getFeature();
            if (result.equals(result.toLowerCase())) {
                result = Strings.toFirstUpper((String)result);
            }
            return result;
        }
        return null;
    }

    public void complete_STRING(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (this.doCreateStringProposals()) {
            String feature = this.getAssignedFeature(ruleCall);
            this.createStringProposal(context, acceptor, feature, ruleCall);
        }
    }

    private void createStringProposal(ContentAssistContext context, ICompletionProposalAcceptor acceptor, String feature, RuleCall ruleCall) {
        ICompletionProposal proposal;
        String proposalText = feature != null ? feature : Strings.toFirstUpper((String)ruleCall.getRule().getName().toLowerCase());
        String displayText = proposalText = this.getValueConverter().toString((Object)proposalText, ruleCall.getRule().getName());
        if (feature != null) {
            displayText = String.valueOf(displayText) + " - " + ruleCall.getRule().getName();
        }
        if ((proposal = this.createCompletionProposal(proposalText, displayText, null, context)) instanceof ConfigurableCompletionProposal) {
            ConfigurableCompletionProposal configurable = (ConfigurableCompletionProposal)proposal;
            configurable.setSelectionStart(configurable.getReplacementOffset() + 1);
            configurable.setSelectionLength(proposalText.length() - 2);
            configurable.setAutoInsertable(false);
            configurable.setSimpleLinkedMode(context.getViewer(), proposalText.charAt(0), '\t');
        }
        acceptor.accept(proposal);
    }

    public void complete_INT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String feature = this.getAssignedFeature(ruleCall);
        if (this.doCreateIntProposals()) {
            this.createIntProposal(context, acceptor, ruleCall, feature, 1);
        }
    }

    protected boolean doCreateIntProposals() {
        return true;
    }

    protected boolean doCreateStringProposals() {
        return true;
    }

    protected boolean doCreateIdProposals() {
        return true;
    }

    private void createIntProposal(ContentAssistContext context, ICompletionProposalAcceptor acceptor, RuleCall ruleCall, String feature, int i) {
        ICompletionProposal proposal;
        String proposalText = this.getValueConverter().toString((Object)i, ruleCall.getRule().getName());
        String displayText = String.valueOf(proposalText) + " - " + ruleCall.getRule().getName();
        if (feature != null) {
            displayText = String.valueOf(proposalText) + " - " + feature;
        }
        if ((proposal = this.createCompletionProposal(proposalText, displayText, null, context)) instanceof ConfigurableCompletionProposal) {
            ConfigurableCompletionProposal configurable = (ConfigurableCompletionProposal)proposal;
            configurable.setSelectionStart(configurable.getReplacementOffset());
            configurable.setSelectionLength(proposalText.length());
            configurable.setAutoInsertable(false);
            configurable.setSimpleLinkedMode(context.getViewer(), '\t', ' ');
        }
        acceptor.accept(proposal);
    }

    public void complete_ML_COMMENT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    public void complete_SL_COMMENT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    public void complete_WS(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    public void complete_ANY_OTHER(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }
}

