/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.builderState.IMarkerUpdater;
import org.eclipse.xtext.builder.builderState.IResourceDescriptionsUpdater;
import org.eclipse.xtext.builder.builderState.Messages;
import org.eclipse.xtext.builder.builderState.PersistableResourceDescriptionsImpl;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescriptionChangeEventSource;
import org.eclipse.xtext.resource.impl.ResourceDescriptionChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuilderState
extends AbstractResourceDescriptionChangeEventSource
implements IBuilderState {
    private volatile Map<URI, IResourceDescription> resourceDescriptionMap = Collections.emptyMap();
    @Inject
    private IMarkerUpdater markerUpdater;
    @Inject
    private PersistableResourceDescriptionsImpl.PersistedStateProvider persister;
    @Inject
    private IResourceDescriptionsUpdater updater;
    private boolean isLoaded = false;

    public synchronized void load() {
        this.resourceDescriptionMap = Maps.uniqueIndex(this.persister.load(), (Function)new Function<IResourceDescription, URI>(){

            public URI apply(IResourceDescription from) {
                return from.getURI();
            }
        });
        this.isLoaded = true;
    }

    protected void ensureLoaded() {
        if (!this.isLoaded) {
            this.load();
        }
    }

    protected Set<URI> ensureNotNull(Set<URI> uris) {
        return uris != null ? uris : Collections.emptySet();
    }

    protected void setResourceDescriptionsMap(Map<URI, IResourceDescription> newMap) {
        this.resourceDescriptionMap = Collections.unmodifiableMap(newMap);
    }

    protected void updateMarkers(ResourceSet resourceSet, ImmutableList<IResourceDescription.Delta> deltas, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        this.markerUpdater.updateMarker(resourceSet, deltas, (IProgressMonitor)progress.newChild(1));
    }

    protected Map<URI, IResourceDescription> getCopiedResourceDescriptionsMap() {
        return Maps.newHashMap(this.resourceDescriptionMap);
    }

    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        this.ensureLoaded();
        return this.resourceDescriptionMap.values();
    }

    public IResourceDescription getResourceDescription(URI uri) {
        this.ensureLoaded();
        return this.resourceDescriptionMap.get(uri);
    }

    public void setPersister(PersistableResourceDescriptionsImpl.PersistedStateProvider persister) {
        this.persister = persister;
    }

    @Override
    public synchronized ImmutableList<IResourceDescription.Delta> update(ResourceSet resourceSet, Set<URI> toBeAddedOrUpdated, Set<URI> toBeRemoved, IProgressMonitor monitor) {
        this.ensureLoaded();
        toBeAddedOrUpdated = this.ensureNotNull(toBeAddedOrUpdated);
        toBeRemoved = this.ensureNotNull(toBeRemoved);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AbstractBuilderState_0, (int)1);
        subMonitor.subTask(Messages.AbstractBuilderState_0);
        if (toBeAddedOrUpdated.isEmpty() && toBeRemoved.isEmpty()) {
            return ImmutableList.of();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        Map<URI, IResourceDescription> newMap = this.getCopiedResourceDescriptionsMap();
        Collection<IResourceDescription.Delta> result = this.doUpdate(resourceSet, toBeAddedOrUpdated, toBeRemoved, newMap, (IProgressMonitor)subMonitor.newChild(1));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ResourceDescriptionChangeEvent event = new ResourceDescriptionChangeEvent(result, (IResourceDescription.Event.Source)this);
        this.setResourceDescriptionsMap(newMap);
        this.notifyListeners((IResourceDescription.Event)event);
        return event.getDeltas();
    }

    protected abstract Collection<IResourceDescription.Delta> doUpdate(ResourceSet var1, Set<URI> var2, Set<URI> var3, Map<URI, IResourceDescription> var4, IProgressMonitor var5);

    @Override
    public synchronized ImmutableList<IResourceDescription.Delta> clean(Set<URI> toBeRemoved, IProgressMonitor monitor) {
        this.ensureLoaded();
        toBeRemoved = this.ensureNotNull(toBeRemoved);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AbstractBuilderState_0, (int)2);
        subMonitor.subTask(Messages.AbstractBuilderState_0);
        if (toBeRemoved.isEmpty()) {
            return ImmutableList.of();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        Collection<IResourceDescription.Delta> deltas = this.doClean(toBeRemoved, (IProgressMonitor)subMonitor.newChild(1));
        Map<URI, IResourceDescription> newMap = this.getCopiedResourceDescriptionsMap();
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (IResourceDescription.Delta delta : deltas) {
            newMap.remove(delta.getOld().getURI());
        }
        ResourceDescriptionChangeEvent event = new ResourceDescriptionChangeEvent(deltas, (IResourceDescription.Event.Source)this);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.updateMarkers(null, (ImmutableList<IResourceDescription.Delta>)event.getDeltas(), (IProgressMonitor)subMonitor.newChild(1));
        this.setResourceDescriptionsMap(newMap);
        this.notifyListeners((IResourceDescription.Event)event);
        return event.getDeltas();
    }

    protected Collection<IResourceDescription.Delta> doClean(Set<URI> toBeRemoved, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        Collection<IResourceDescription.Delta> result = this.updater.clean(this, toBeRemoved, (IProgressMonitor)subMonitor.newChild(1));
        return result;
    }

    protected Collection<IResourceDescription.Delta> transitiveUpdate(ResourceSet resourceSet, Set<URI> toBeAddedOrUpdated, Set<URI> toBeRemoved, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        Collection<IResourceDescription.Delta> result = this.updater.transitiveUpdate(this, resourceSet, toBeAddedOrUpdated, toBeRemoved, (IProgressMonitor)subMonitor.newChild(1));
        return result;
    }
}

