/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import java.util.List;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceInitializer;
import org.eclipse.xtext.xbase.typesystem.util.RecursionGuard;

public class ArrayTypes {
    public ArrayTypeReference tryConvertToArray(ParameterizedTypeReference typeReference) {
        ArrayTypeReference result = this.doTryConvertToArray(typeReference);
        if (result != null) {
            return result;
        }
        JvmType type = typeReference.getType();
        if (type.eClass() == TypesPackage.Literals.JVM_TYPE_PARAMETER) {
            return this.doTryConvertToArray(typeReference, new RecursionGuard<JvmTypeParameter>());
        }
        return null;
    }

    private ArrayTypeReference doTryConvertToArray(ParameterizedTypeReference typeReference, RecursionGuard<JvmTypeParameter> recursionGuard) {
        JvmType type = typeReference.getType();
        if (recursionGuard.tryNext((JvmTypeParameter)type)) {
            List<LightweightTypeReference> superTypes = typeReference.getSuperTypes();
            int size = superTypes.size();
            for (int i = 0; i < size; ++i) {
                LightweightTypeReference superType = superTypes.get(i);
                if (superType.isArray()) {
                    return (ArrayTypeReference)superType;
                }
                ArrayTypeReference result = this.doTryConvertToArray(typeReference);
                if (result != null) {
                    return result;
                }
                JvmType rawSuperType = superType.getType();
                if (rawSuperType == null || rawSuperType.eClass() != TypesPackage.Literals.JVM_TYPE_PARAMETER || (result = this.doTryConvertToArray((ParameterizedTypeReference)superType, recursionGuard)) == null) continue;
                return result;
            }
        }
        return null;
    }

    private ArrayTypeReference doTryConvertToArray(ParameterizedTypeReference typeReference) {
        LightweightTypeReference parameterizedIterable = typeReference.getSuperType(Iterable.class);
        if (parameterizedIterable != null) {
            ITypeReferenceOwner owner = typeReference.getOwner();
            if (parameterizedIterable.isRawType()) {
                List<LightweightTypeReference> superTypes = parameterizedIterable.getSuperTypes();
                if (superTypes.isEmpty()) {
                    return null;
                }
                LightweightTypeReference objectType = superTypes.get(0);
                ArrayTypeReference array = owner.newArrayTypeReference(objectType);
                return array;
            }
            LightweightTypeReference componentType = parameterizedIterable.getTypeArguments().get(0).getUpperBoundSubstitute();
            ArrayTypeReference array = owner.newArrayTypeReference(componentType);
            return array;
        }
        return null;
    }

    public LightweightTypeReference convertToList(final ArrayTypeReference type) {
        ITypeReferenceOwner owner = type.getOwner();
        return owner.newReferenceTo(List.class, (TypeReferenceInitializer<? super ParameterizedTypeReference>)new TypeReferenceInitializer<ParameterizedTypeReference>(){

            @Override
            public LightweightTypeReference enhance(ParameterizedTypeReference reference) {
                LightweightTypeReference componentType = type.getComponentType();
                LightweightTypeReference wrapper = componentType.getWrapperTypeIfPrimitive();
                reference.addTypeArgument(wrapper);
                return reference;
            }
        });
    }
}

