/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.validation;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.IRawTypeHelper;
import org.eclipse.xtext.util.Strings;

public class TypeErasedSignature {
    private JvmExecutable executable;
    private List<JvmType> erasureParameterTypes;

    protected TypeErasedSignature(JvmExecutable executable, IRawTypeHelper rawTypeHelper) {
        this.executable = executable;
        if (executable != null) {
            this.erasureParameterTypes = Lists.newArrayListWithCapacity((int)executable.getParameters().size());
            for (JvmFormalParameter parameter : executable.getParameters()) {
                List rawTypes = rawTypeHelper.getAllRawTypes(parameter.getParameterType(), executable.eResource());
                if (rawTypes.isEmpty()) {
                    this.erasureParameterTypes.add(null);
                    continue;
                }
                this.erasureParameterTypes.add((JvmType)rawTypes.get(0));
            }
        } else {
            this.erasureParameterTypes = Collections.emptyList();
        }
    }

    public String getName() {
        if (this.executable == null) {
            return "null";
        }
        return this.executable.getSimpleName();
    }

    public String toString() {
        if (this.executable == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder(this.getName());
        result.append('(');
        boolean isFirst = true;
        for (JvmType parameterType : this.erasureParameterTypes) {
            if (!isFirst) {
                result.append(", ");
            }
            isFirst = false;
            if (parameterType != null) {
                result.append(parameterType.getSimpleName());
                continue;
            }
            result.append("null");
        }
        result.append(')');
        return result.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof TypeErasedSignature) {
            TypeErasedSignature otherSignature = (TypeErasedSignature)other;
            return Strings.equal((String)this.getName(), (String)otherSignature.getName()) && this.erasureParameterTypes.equals(otherSignature.erasureParameterTypes);
        }
        return false;
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().hashCode() + 17 * this.erasureParameterTypes.hashCode();
    }

    @Singleton
    public static class Provider {
        @Inject
        private IRawTypeHelper rawTypeHelper;

        public TypeErasedSignature get(JvmExecutable executable) {
            return new TypeErasedSignature(executable, this.rawTypeHelper);
        }
    }
}

