/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.shared.jdt38;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.xtext.util.Strings;

@Singleton
public class DebugPluginListener
implements IDebugEventSetListener {
    private static Logger log = Logger.getLogger(DebugPluginListener.class);
    private IJavaThread lastThread;
    private IStackFrame lastFrame;

    public DebugPluginListener() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugPluginListener debugPluginListener;
            DebugEvent event = debugEventArray[n2];
            Object source = event.getSource();
            if (source instanceof IJavaThread) {
                debugPluginListener = this;
                synchronized (debugPluginListener) {
                    this.lastThread = (IJavaThread)source;
                }
            }
            if (source instanceof IStackFrame) {
                debugPluginListener = this;
                synchronized (debugPluginListener) {
                    this.lastFrame = (IStackFrame)source;
                }
            }
            if (source instanceof IDebugTarget) {
                debugPluginListener = this;
                synchronized (debugPluginListener) {
                    if (event.getKind() == 8) {
                        if (this.lastThread != null && this.lastThread.getDebugTarget() == source) {
                            this.lastThread = null;
                        }
                        if (this.lastFrame != null && this.lastFrame.getDebugTarget() == source) {
                            this.lastFrame = null;
                        }
                    }
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findXtextSourceFileNameForClassFile(String simpleFileName) {
        if (!simpleFileName.endsWith(".class")) {
            return null;
        }
        String typename = simpleFileName.substring(0, simpleFileName.length() - ".class".length());
        DebugPluginListener debugPluginListener = this;
        synchronized (debugPluginListener) {
            try {
                ArrayList frames = Lists.newArrayList();
                if (this.lastFrame != null) {
                    frames.add(this.lastFrame);
                }
                if (this.lastThread != null) {
                    frames.addAll(Lists.newArrayList((Object[])this.lastThread.getStackFrames()));
                }
                for (IStackFrame frame : frames) {
                    IJavaStackFrame jsf;
                    String simpleName;
                    if (!(frame instanceof IJavaStackFrame) || !(simpleName = Strings.lastToken((String)(jsf = (IJavaStackFrame)frame).getDeclaringTypeName(), (String)".")).equals(typename)) continue;
                    return jsf.getSourceName();
                }
            }
            catch (DebugException e) {
                log.error((Object)e);
            }
            return null;
        }
    }
}

