/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.serializer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFile {
    protected String body;
    protected Map<String, String> imports = Maps.newHashMap();
    protected String packageName;

    public JavaFile(String packageName) {
        this.packageName = packageName;
    }

    public String imported(Class<?> clazz) {
        return this.imported(clazz.getName().replace('$', '.'));
    }

    public String imported(String clazz) {
        String simpleName = Strings.lastToken((String)clazz, (String)".");
        if (CodeGenUtil.isJavaDefaultType((String)simpleName)) {
            return clazz;
        }
        String imported = this.imports.get(simpleName);
        if (imported != null) {
            if (imported.equals(clazz)) {
                return simpleName;
            }
            return clazz;
        }
        this.imports.put(simpleName, clazz);
        return simpleName;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("package " + this.packageName + ";\n\n");
        ArrayList sortedImports = Lists.newArrayList(this.imports.values());
        Collections.sort(sortedImports);
        for (String importName : sortedImports) {
            result.append("import ");
            result.append(importName);
            result.append(";\n");
        }
        result.append("\n");
        result.append(this.body);
        return result.toString();
    }
}

