/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.interpreter.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.impl.ClassFinder;
import org.eclipse.xtext.common.types.util.JavaReflectAccess;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSetLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.eclipse.xtext.xbase.interpreter.IEvaluationResult;
import org.eclipse.xtext.xbase.interpreter.IExpressionInterpreter;
import org.eclipse.xtext.xbase.interpreter.impl.ClosureInvocationHandler;
import org.eclipse.xtext.xbase.interpreter.impl.DefaultEvaluationResult;
import org.eclipse.xtext.xbase.interpreter.impl.DelegatingInvocationHandler;
import org.eclipse.xtext.xbase.interpreter.impl.EvaluationException;
import org.eclipse.xtext.xbase.interpreter.impl.FinallyDidNotCompleteException;
import org.eclipse.xtext.xbase.interpreter.impl.InterpreterCanceledException;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.computation.NumberLiterals;
import org.eclipse.xtext.xbase.typesystem.legacy.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.util.XExpressionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseInterpreter
implements IExpressionInterpreter {
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private IdentifiableSimpleNameProvider featureNameProvider;
    @Inject
    private Provider<IEvaluationContext> contextProvider;
    @Inject
    private JavaReflectAccess javaReflectAccess;
    @Inject
    private XExpressionHelper expressionHelper;
    @Inject
    private NumberLiterals numberLiterals;
    @Inject
    private IBatchTypeResolver typeResolver;
    private ClassFinder classFinder;
    private ClassLoader classLoader;

    public XbaseInterpreter() {
    }

    public XbaseInterpreter(Provider<IEvaluationContext> contextProvider, JavaReflectAccess javaReflectAccess, ClassLoader loader) {
        this.contextProvider = contextProvider;
        this.javaReflectAccess = javaReflectAccess;
        this.setClassLoader(loader);
    }

    public void setFeatureNameProvider(IdentifiableSimpleNameProvider featureNameProvider) {
        this.featureNameProvider = featureNameProvider;
    }

    @Inject
    public void setClassLoader(ClassLoader classLoader) {
        this.classFinder = new ClassFinder(classLoader);
        this.classLoader = classLoader;
        this.javaReflectAccess.setClassLoader(classLoader);
    }

    protected Class<?> getClass(Class<?> class1) {
        try {
            return this.classLoader.loadClass(class1.getName());
        }
        catch (ClassNotFoundException e) {
            throw new EvaluationException(e);
        }
    }

    @Override
    public IEvaluationResult evaluate(XExpression expression) {
        return this.evaluate(expression, this.createContext(), CancelIndicator.NullImpl);
    }

    protected IEvaluationContext createContext() {
        return (IEvaluationContext)this.contextProvider.get();
    }

    @Override
    public IEvaluationResult evaluate(XExpression expression, IEvaluationContext context, CancelIndicator indicator) {
        try {
            Object result = this.internalEvaluate(expression, context, indicator != null ? indicator : CancelIndicator.NullImpl);
            return new DefaultEvaluationResult(result, null);
        }
        catch (ReturnValue e) {
            return new DefaultEvaluationResult(e.returnValue, null);
        }
        catch (EvaluationException e) {
            return new DefaultEvaluationResult(null, e.getCause());
        }
        catch (InterpreterCanceledException e) {
            return null;
        }
    }

    protected Object internalEvaluate(XExpression expression, IEvaluationContext context, CancelIndicator indicator) throws EvaluationException {
        if (indicator.isCanceled()) {
            throw new InterpreterCanceledException();
        }
        Object result = this.doEvaluate(expression, context, indicator);
        LightweightTypeReference expectedType = this.typeResolver.resolveTypes(expression).getExpectedType(expression);
        if (expectedType != null) {
            result = this.wrapOrUnwrapArray(result, expectedType);
        }
        return result;
    }

    protected Object doEvaluate(XExpression expression, IEvaluationContext context, CancelIndicator indicator) {
        if (expression instanceof XAssignment) {
            return this._doEvaluate((XAssignment)expression, context, indicator);
        }
        if (expression instanceof XDoWhileExpression) {
            return this._doEvaluate((XDoWhileExpression)expression, context, indicator);
        }
        if (expression instanceof XMemberFeatureCall) {
            return this._doEvaluate((XMemberFeatureCall)expression, context, indicator);
        }
        if (expression instanceof XWhileExpression) {
            return this._doEvaluate((XWhileExpression)expression, context, indicator);
        }
        if (expression instanceof XFeatureCall) {
            return this._doEvaluate((XFeatureCall)expression, context, indicator);
        }
        if (expression instanceof XAbstractFeatureCall) {
            return this._doEvaluate((XAbstractFeatureCall)expression, context, indicator);
        }
        if (expression instanceof XBlockExpression) {
            return this._doEvaluate((XBlockExpression)expression, context, indicator);
        }
        if (expression instanceof XBooleanLiteral) {
            return this._doEvaluate((XBooleanLiteral)expression, context, indicator);
        }
        if (expression instanceof XCastedExpression) {
            return this._doEvaluate((XCastedExpression)expression, context, indicator);
        }
        if (expression instanceof XClosure) {
            return this._doEvaluate((XClosure)expression, context, indicator);
        }
        if (expression instanceof XConstructorCall) {
            return this._doEvaluate((XConstructorCall)expression, context, indicator);
        }
        if (expression instanceof XForLoopExpression) {
            return this._doEvaluate((XForLoopExpression)expression, context, indicator);
        }
        if (expression instanceof XIfExpression) {
            return this._doEvaluate((XIfExpression)expression, context, indicator);
        }
        if (expression instanceof XInstanceOfExpression) {
            return this._doEvaluate((XInstanceOfExpression)expression, context, indicator);
        }
        if (expression instanceof XNullLiteral) {
            return this._doEvaluate((XNullLiteral)expression, context, indicator);
        }
        if (expression instanceof XNumberLiteral) {
            return this._doEvaluate((XNumberLiteral)expression, context, indicator);
        }
        if (expression instanceof XReturnExpression) {
            return this._doEvaluate((XReturnExpression)expression, context, indicator);
        }
        if (expression instanceof XStringLiteral) {
            return this._doEvaluate((XStringLiteral)expression, context, indicator);
        }
        if (expression instanceof XSwitchExpression) {
            return this._doEvaluate((XSwitchExpression)expression, context, indicator);
        }
        if (expression instanceof XThrowExpression) {
            return this._doEvaluate((XThrowExpression)expression, context, indicator);
        }
        if (expression instanceof XTryCatchFinallyExpression) {
            return this._doEvaluate((XTryCatchFinallyExpression)expression, context, indicator);
        }
        if (expression instanceof XTypeLiteral) {
            return this._doEvaluate((XTypeLiteral)expression, context, indicator);
        }
        if (expression instanceof XVariableDeclaration) {
            return this._doEvaluate((XVariableDeclaration)expression, context, indicator);
        }
        if (expression instanceof XListLiteral) {
            return this._doEvaluate((XListLiteral)expression, context, indicator);
        }
        if (expression instanceof XSetLiteral) {
            return this._doEvaluate((XSetLiteral)expression, context, indicator);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expression, context, indicator).toString());
    }

    protected Object _doEvaluate(XNullLiteral literal, IEvaluationContext context, CancelIndicator indicator) {
        return null;
    }

    protected Object _doEvaluate(XReturnExpression returnExpr, IEvaluationContext context, CancelIndicator indicator) {
        Object returnValue = this.internalEvaluate(returnExpr.getExpression(), context, indicator);
        throw new ReturnValue(returnValue);
    }

    protected Object _doEvaluate(XStringLiteral literal, IEvaluationContext context, CancelIndicator indicator) {
        LightweightTypeReference type = this.typeResolver.resolveTypes(literal).getActualType(literal);
        if (type.isType(Character.TYPE) || type.isType(Character.class)) {
            return Character.valueOf(literal.getValue().charAt(0));
        }
        return literal.getValue();
    }

    protected Object _doEvaluate(XNumberLiteral literal, IEvaluationContext context, CancelIndicator indicator) {
        return this.numberLiterals.numberValue(literal, this.numberLiterals.getJavaType(literal));
    }

    protected Object _doEvaluate(XBooleanLiteral literal, IEvaluationContext context, CancelIndicator indicator) {
        return literal.isIsTrue();
    }

    protected Object _doEvaluate(XTypeLiteral literal, IEvaluationContext context, CancelIndicator indicator) {
        if (literal.getType() == null || literal.getType().eIsProxy()) {
            List nodesForFeature = NodeModelUtils.findNodesForFeature((EObject)literal, (EStructuralFeature)XbasePackage.Literals.XTYPE_LITERAL__TYPE);
            if (nodesForFeature.isEmpty()) {
                throw new EvaluationException(new ClassNotFoundException());
            }
            throw new EvaluationException(new ClassNotFoundException(((INode)nodesForFeature.get(0)).getText()));
        }
        try {
            Class result = this.classFinder.forName(String.valueOf(literal.getType().getQualifiedName()) + Joiner.on((String)"").join(literal.getArrayDimensions()));
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            throw new EvaluationException(cnfe);
        }
    }

    protected Object _doEvaluate(XListLiteral literal, IEvaluationContext context, CancelIndicator indicator) {
        LightweightTypeReference type = this.typeResolver.resolveTypes(literal).getActualType(literal);
        ArrayList list = Lists.newArrayList();
        for (XExpression element : literal.getElements()) {
            if (indicator.isCanceled()) {
                throw new InterpreterCanceledException();
            }
            list.add(this.internalEvaluate(element, context, indicator));
        }
        if (type.isArray()) {
            return Iterables.toArray((Iterable)list, Object.class);
        }
        return Collections.unmodifiableList(list);
    }

    protected Object _doEvaluate(XSetLiteral literal, IEvaluationContext context, CancelIndicator indicator) {
        if (this.isType(literal, Map.class)) {
            HashMap map = Maps.newHashMap();
            for (XExpression element : literal.getElements()) {
                if (indicator.isCanceled()) {
                    throw new InterpreterCanceledException();
                }
                if (this.expressionHelper.isOperatorFromExtension(element, OperatorMapping.MAPPED_TO, ObjectExtensions.class)) {
                    map.put(this.internalEvaluate(((XBinaryOperation)element).getLeftOperand(), context, indicator), this.internalEvaluate(((XBinaryOperation)element).getRightOperand(), context, indicator));
                    continue;
                }
                if (!this.isType(element, Pair.class)) continue;
                Pair pair = (Pair)this.internalEvaluate(element, context, indicator);
                map.put(pair == null ? null : pair.getKey(), pair == null ? null : pair.getValue());
            }
            return Collections.unmodifiableMap(map);
        }
        HashSet set = Sets.newHashSet();
        for (XExpression element : literal.getElements()) {
            if (indicator.isCanceled()) {
                throw new InterpreterCanceledException();
            }
            set.add(this.internalEvaluate(element, context, indicator));
        }
        return Collections.unmodifiableSet(set);
    }

    protected boolean isType(XExpression element, Class<?> clazz) {
        return this.resolveType(element, clazz) != null;
    }

    protected LightweightTypeReference resolveType(XExpression element, Class<?> clazz) {
        LightweightTypeReference elementType = this.typeResolver.resolveTypes(element).getActualType(element);
        return elementType != null && elementType.isType(clazz) ? elementType : null;
    }

    protected Object _doEvaluate(XClosure closure, IEvaluationContext context, CancelIndicator indicator) {
        Class<?> functionIntf = null;
        switch (closure.getFormalParameters().size()) {
            case 0: {
                functionIntf = this.getClass(Functions.Function0.class);
                break;
            }
            case 1: {
                functionIntf = this.getClass(Functions.Function1.class);
                break;
            }
            case 2: {
                functionIntf = this.getClass(Functions.Function2.class);
                break;
            }
            case 3: {
                functionIntf = this.getClass(Functions.Function3.class);
                break;
            }
            case 4: {
                functionIntf = this.getClass(Functions.Function4.class);
                break;
            }
            case 5: {
                functionIntf = this.getClass(Functions.Function5.class);
                break;
            }
            case 6: {
                functionIntf = this.getClass(Functions.Function6.class);
                break;
            }
            default: {
                throw new IllegalStateException("Closures with more then 6 parameters are not supported.");
            }
        }
        ClosureInvocationHandler invocationHandler = new ClosureInvocationHandler(closure, context, this, indicator);
        Object proxy = Proxy.newProxyInstance(this.classLoader, new Class[]{functionIntf}, (InvocationHandler)invocationHandler);
        return proxy;
    }

    protected Object _doEvaluate(XBlockExpression literal, IEvaluationContext context, CancelIndicator indicator) {
        EList<XExpression> expressions = literal.getExpressions();
        Object result = null;
        IEvaluationContext forkedContext = context.fork();
        int i = 0;
        while (i < expressions.size()) {
            result = this.internalEvaluate((XExpression)expressions.get(i), forkedContext, indicator);
            ++i;
        }
        return result;
    }

    protected Object _doEvaluate(XIfExpression ifExpression, IEvaluationContext context, CancelIndicator indicator) {
        Object conditionResult = this.internalEvaluate(ifExpression.getIf(), context, indicator);
        if (Boolean.TRUE.equals(conditionResult)) {
            return this.internalEvaluate(ifExpression.getThen(), context, indicator);
        }
        if (ifExpression.getElse() == null) {
            return null;
        }
        return this.internalEvaluate(ifExpression.getElse(), context, indicator);
    }

    protected Object _doEvaluate(XSwitchExpression switchExpression, IEvaluationContext context, CancelIndicator indicator) {
        IEvaluationContext forkedContext = context.fork();
        Object conditionResult = this.internalEvaluate(switchExpression.getSwitch(), forkedContext, indicator);
        String simpleName = this.featureNameProvider.getSimpleName(switchExpression);
        if (simpleName != null) {
            forkedContext.newValue(QualifiedName.create((String)simpleName), conditionResult);
        }
        for (XCasePart casePart : switchExpression.getCases()) {
            Class expectedType = null;
            if (casePart.getTypeGuard() != null) {
                String typeName = casePart.getTypeGuard().getType().getQualifiedName();
                try {
                    expectedType = this.classFinder.forName(typeName);
                }
                catch (ClassNotFoundException e) {
                    throw new EvaluationException(new NoClassDefFoundError(typeName));
                }
            }
            if (expectedType != null && conditionResult == null) {
                throw new IllegalStateException("Switch without expression or implicit 'this' may not use type guards");
            }
            if (expectedType != null && !expectedType.isInstance(conditionResult)) continue;
            if (casePart.getCase() != null) {
                Object casePartResult = this.internalEvaluate(casePart.getCase(), forkedContext, indicator);
                if (!Boolean.TRUE.equals(casePartResult) && !this.eq(conditionResult, casePartResult)) continue;
                return this.internalEvaluate(casePart.getThen(), forkedContext, indicator);
            }
            return this.internalEvaluate(casePart.getThen(), forkedContext, indicator);
        }
        if (switchExpression.getDefault() != null) {
            Object defaultResult = this.internalEvaluate(switchExpression.getDefault(), forkedContext, indicator);
            return defaultResult;
        }
        return null;
    }

    protected Object _doEvaluate(XCastedExpression castedExpression, IEvaluationContext context, CancelIndicator indicator) {
        Object result = this.internalEvaluate(castedExpression.getTarget(), context, indicator);
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, castedExpression);
        LightweightTypeReference targetType = new OwnedConverter(owner).toLightweightReference(castedExpression.getType());
        result = this.wrapOrUnwrapArray(result, targetType);
        result = this.coerceArgumentType(result, castedExpression.getType());
        JvmType castType = castedExpression.getType().getType();
        if (castType instanceof JvmPrimitiveType) {
            if (result == null) {
                this.throwNullPointerException(castedExpression, "Cannot cast null to primitive " + castType.getIdentifier());
            }
            return this.castToPrimitiveType(result, this.services.getPrimitives().primitiveKind((JvmPrimitiveType)castType));
        }
        String typeName = castType.getQualifiedName();
        Class expectedType = null;
        try {
            expectedType = this.classFinder.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            throw new EvaluationException(new NoClassDefFoundError(typeName));
        }
        try {
            expectedType.cast(result);
        }
        catch (ClassCastException e) {
            throw new EvaluationException(new ClassCastException(typeName));
        }
        return result;
    }

    protected Object castToPrimitiveType(Object castMe, Primitives.Primitive kind) {
        if (Primitives.isWrapperType(castMe.getClass())) {
            if (kind == Primitives.Primitive.Boolean) {
                if (castMe instanceof Boolean) {
                    return castMe;
                }
            } else if (kind == Primitives.Primitive.Char) {
                if (castMe instanceof Character) {
                    return Character.valueOf(((Character)castMe).charValue());
                }
                if (castMe instanceof Byte) {
                    return Character.valueOf((char)((Byte)castMe).byteValue());
                }
                if (castMe instanceof Short) {
                    return Character.valueOf((char)((Short)castMe).shortValue());
                }
                if (castMe instanceof Long) {
                    return Character.valueOf((char)((Long)castMe).longValue());
                }
                if (castMe instanceof Integer) {
                    return Character.valueOf((char)((Integer)castMe).intValue());
                }
                if (castMe instanceof Float) {
                    return Character.valueOf((char)((Float)castMe).floatValue());
                }
                if (castMe instanceof Double) {
                    return Character.valueOf((char)((Double)castMe).doubleValue());
                }
            } else {
                if (castMe instanceof Number) {
                    Number number = (Number)castMe;
                    switch (kind) {
                        case Byte: {
                            return number.byteValue();
                        }
                        case Short: {
                            return number.shortValue();
                        }
                        case Long: {
                            return number.longValue();
                        }
                        case Int: {
                            return number.intValue();
                        }
                        case Float: {
                            return Float.valueOf(number.floatValue());
                        }
                        case Double: {
                            return number.doubleValue();
                        }
                    }
                    throw new IllegalStateException("Unexpected cast type 'void'");
                }
                if (castMe instanceof Character) {
                    char c = ((Character)castMe).charValue();
                    switch (kind) {
                        case Byte: {
                            return (byte)c;
                        }
                        case Short: {
                            return (short)c;
                        }
                        case Long: {
                            return (long)c;
                        }
                        case Int: {
                            return (int)c;
                        }
                        case Float: {
                            return Float.valueOf(c);
                        }
                        case Double: {
                            return (double)c;
                        }
                    }
                    throw new IllegalStateException("Unexpected cast type 'void'");
                }
            }
        }
        throw new EvaluationException(new ClassCastException(String.valueOf(castMe.getClass().getName()) + "!=" + kind.name().toLowerCase()));
    }

    protected Object _doEvaluate(XThrowExpression throwExpression, IEvaluationContext context, CancelIndicator indicator) {
        Object thrown = this.internalEvaluate(throwExpression.getExpression(), context, indicator);
        if (thrown == null) {
            return this.throwNullPointerException(throwExpression, "throwable expression evaluated to 'null'");
        }
        if (!(thrown instanceof Throwable)) {
            return this.throwClassCastException(throwExpression.getExpression(), thrown, Throwable.class);
        }
        throw new EvaluationException((Throwable)thrown);
    }

    /*
     * Unable to fully structure code
     */
    protected Object _doEvaluate(XTryCatchFinallyExpression tryCatchFinally, IEvaluationContext context, CancelIndicator indicator) {
        block9: {
            result = null;
            try {
                result = this.internalEvaluate(tryCatchFinally.getExpression(), context, indicator);
                break block9;
            }
            catch (EvaluationException evaluationException) {
                cause = evaluationException.getCause();
                ** for (catchClause : tryCatchFinally.getCatchClauses())
            }
lbl-1000:
            // 1 sources

            {
                exception = catchClause.getDeclaredParam();
                exceptionTypeName = exception.getParameterType().getType().getQualifiedName();
                try {
                    exceptionType = this.classFinder.forName(exceptionTypeName);
                    if (!exceptionType.isInstance(cause)) {
                        continue;
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new EvaluationException(new NoClassDefFoundError(exceptionTypeName));
                }
                forked = context.fork();
                forked.newValue(QualifiedName.create((String)exception.getName()), cause);
                result = this.internalEvaluate(catchClause.getExpression(), forked, indicator);
                break;
            }
        }
        if (tryCatchFinally.getFinallyExpression() != null) {
            try {
                this.internalEvaluate(tryCatchFinally.getFinallyExpression(), context, indicator);
            }
            catch (EvaluationException e) {
                throw new EvaluationException(new FinallyDidNotCompleteException(e));
            }
        }
        return result;
    }

    protected boolean eq(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    protected Object throwNullPointerException(XExpression expression, String message) {
        throw new EvaluationException(new NullPointerException(message));
    }

    protected Object throwClassCastException(XExpression expression, Object result, Class<?> expectedType) {
        throw new EvaluationException(new ClassCastException("Expected: " + expectedType.getCanonicalName() + " but got: " + result.getClass().getCanonicalName()));
    }

    protected Object wrapOrUnwrapArray(Object result, LightweightTypeReference expectedType) {
        if (expectedType.isArray()) {
            Class arrayType = this.getJavaReflectAccess().getRawType(expectedType.getType());
            return Conversions.unwrapArray((Object)result, arrayType.getComponentType());
        }
        if (expectedType.isSubtypeOf(Iterable.class)) {
            return Conversions.doWrapArray((Object)result);
        }
        return result;
    }

    protected Object _doEvaluate(XForLoopExpression forLoop, IEvaluationContext context, CancelIndicator indicator) {
        Object iterableOrIterator = this.internalEvaluate(forLoop.getForExpression(), context, indicator);
        if (iterableOrIterator == null) {
            return this.throwNullPointerException(forLoop.getForExpression(), "iterable evaluated to 'null'");
        }
        Iterator iter = null;
        if (iterableOrIterator instanceof Iterable) {
            iter = ((Iterable)iterableOrIterator).iterator();
        } else if (iterableOrIterator.getClass().isArray()) {
            iter = ((Iterable)Conversions.doWrapArray((Object)iterableOrIterator)).iterator();
        } else {
            return this.throwClassCastException(forLoop.getForExpression(), iterableOrIterator, Iterable.class);
        }
        IEvaluationContext forkedContext = context.fork();
        QualifiedName paramName = QualifiedName.create((String)forLoop.getDeclaredParam().getName());
        forkedContext.newValue(paramName, null);
        while (iter.hasNext()) {
            Object next = iter.next();
            forkedContext.assignValue(paramName, next);
            this.internalEvaluate(forLoop.getEachExpression(), forkedContext, indicator);
        }
        return null;
    }

    protected Object _doEvaluate(XWhileExpression whileLoop, IEvaluationContext context, CancelIndicator indicator) {
        Object condition = this.internalEvaluate(whileLoop.getPredicate(), context, indicator);
        while (Boolean.TRUE.equals(condition)) {
            this.internalEvaluate(whileLoop.getBody(), context, indicator);
            condition = this.internalEvaluate(whileLoop.getPredicate(), context, indicator);
        }
        return null;
    }

    protected IEvaluationResult _doEvaluate(XDoWhileExpression doWhileLoop, IEvaluationContext context, CancelIndicator indicator) {
        Object condition = null;
        do {
            this.internalEvaluate(doWhileLoop.getBody(), context, indicator);
        } while (Boolean.TRUE.equals(condition = this.internalEvaluate(doWhileLoop.getPredicate(), context, indicator)));
        return null;
    }

    protected Object _doEvaluate(XConstructorCall constructorCall, IEvaluationContext context, CancelIndicator indicator) {
        JvmConstructor jvmConstructor = constructorCall.getConstructor();
        List<Object> arguments = this.evaluateArgumentExpressions((JvmExecutable)jvmConstructor, (List<XExpression>)constructorCall.getArguments(), context, indicator);
        Constructor constructor = this.javaReflectAccess.getConstructor(jvmConstructor);
        try {
            if (constructor == null) {
                throw new NoSuchMethodException("Could not find constructor " + jvmConstructor.getIdentifier());
            }
            constructor.setAccessible(true);
            Object result = constructor.newInstance(arguments.toArray(new Object[arguments.size()]));
            return result;
        }
        catch (InvocationTargetException targetException) {
            throw new EvaluationException(targetException.getTargetException());
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not invoke constructor: " + jvmConstructor.getIdentifier(), e);
        }
    }

    protected Object _doEvaluate(XMemberFeatureCall featureCall, IEvaluationContext context, CancelIndicator indicator) {
        Object receiverObj;
        if (featureCall.isTypeLiteral()) {
            JvmType type = (JvmType)featureCall.getFeature();
            try {
                Class result = this.classFinder.forName(type.getQualifiedName());
                return result;
            }
            catch (ClassNotFoundException cnfe) {
                throw new EvaluationException(cnfe);
            }
        }
        XExpression receiver = this.getActualReceiver(featureCall);
        Object object = receiverObj = receiver == null ? null : this.internalEvaluate(receiver, context, indicator);
        if (featureCall.isNullSafe() && receiverObj == null) {
            return this.getDefaultObjectValue(this.typeResolver.resolveTypes(featureCall).getActualType(featureCall));
        }
        return this.invokeFeature(featureCall.getFeature(), featureCall, receiverObj, context, indicator);
    }

    protected Object getDefaultObjectValue(LightweightTypeReference type) {
        if (!type.isPrimitive()) {
            return null;
        }
        JvmPrimitiveType primitive = (JvmPrimitiveType)type.getType();
        switch (this.services.getPrimitives().primitiveKind(primitive)) {
            case Byte: {
                return (byte)0;
            }
            case Short: {
                return (short)0;
            }
            case Char: {
                return Character.valueOf('\u0000');
            }
            case Int: {
                return 0;
            }
            case Long: {
                return 0L;
            }
            case Float: {
                return Float.valueOf(0.0f);
            }
            case Double: {
                return Double.valueOf("0.");
            }
            case Boolean: {
                return Boolean.FALSE;
            }
            case Void: {
                return null;
            }
        }
        throw new IllegalArgumentException("Not a primitive : " + primitive);
    }

    protected Object _doEvaluate(XInstanceOfExpression instanceOf, IEvaluationContext context, CancelIndicator indicator) {
        Object instance = this.internalEvaluate(instanceOf.getExpression(), context, indicator);
        if (instance == null) {
            return Boolean.FALSE;
        }
        Class expectedType = null;
        String className = instanceOf.getType().getType().getQualifiedName();
        try {
            expectedType = this.classFinder.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new EvaluationException(new NoClassDefFoundError(className));
        }
        return expectedType.isInstance(instance);
    }

    protected Object _doEvaluate(XVariableDeclaration variableDecl, IEvaluationContext context, CancelIndicator indicator) {
        Object initialValue = null;
        if (variableDecl.getRight() != null) {
            initialValue = this.internalEvaluate(variableDecl.getRight(), context, indicator);
        } else if (this.services.getPrimitives().isPrimitive(variableDecl.getType())) {
            Primitives.Primitive primitiveKind = this.services.getPrimitives().primitiveKind((JvmPrimitiveType)variableDecl.getType().getType());
            switch (primitiveKind) {
                case Boolean: {
                    initialValue = Boolean.FALSE;
                    break;
                }
                case Char: {
                    initialValue = Character.valueOf('\u0000');
                    break;
                }
                case Double: {
                    initialValue = 0.0;
                    break;
                }
                case Byte: {
                    initialValue = (byte)0;
                    break;
                }
                case Float: {
                    initialValue = Float.valueOf(0.0f);
                    break;
                }
                case Int: {
                    initialValue = 0;
                    break;
                }
                case Long: {
                    initialValue = 0L;
                    break;
                }
                case Short: {
                    initialValue = (short)0;
                    break;
                }
                case Void: {
                    throw new IllegalStateException("Void is not a valid variable type.");
                }
                default: {
                    throw new IllegalStateException("Unknown primitive type " + primitiveKind);
                }
            }
        }
        context.newValue(QualifiedName.create((String)variableDecl.getName()), initialValue);
        return null;
    }

    protected Object _doEvaluate(XFeatureCall featureCall, IEvaluationContext context, CancelIndicator indicator) {
        if (featureCall.isTypeLiteral()) {
            JvmType type = (JvmType)featureCall.getFeature();
            try {
                Class result = this.classFinder.forName(type.getQualifiedName());
                return result;
            }
            catch (ClassNotFoundException cnfe) {
                throw new EvaluationException(cnfe);
            }
        }
        return this._doEvaluate((XAbstractFeatureCall)featureCall, context, indicator);
    }

    protected Object _doEvaluate(XAbstractFeatureCall featureCall, IEvaluationContext context, CancelIndicator indicator) {
        if (this.expressionHelper.isShortCircuitOperation(featureCall)) {
            XExpression leftOperand = ((XBinaryOperation)featureCall).getLeftOperand();
            Object result = this.internalEvaluate(leftOperand, context, indicator);
            String operatorName = featureCall.getConcreteSyntaxFeatureName();
            if (Strings.equal((String)this.expressionHelper.getElvisOperator(), (String)operatorName)) {
                if (result != null) {
                    return result;
                }
            } else if (Strings.equal((String)this.expressionHelper.getAndOperator(), (String)operatorName)) {
                if (!((Boolean)result).booleanValue()) {
                    return false;
                }
            } else if (Strings.equal((String)this.expressionHelper.getOrOperator(), (String)operatorName) && ((Boolean)result).booleanValue()) {
                return true;
            }
            JvmOperation operation = (JvmOperation)featureCall.getFeature();
            XExpression receiver = this.getActualReceiver(featureCall);
            List<XExpression> operationArguments = this.getActualArguments(featureCall);
            ArrayList argumentValues = Lists.newArrayList();
            for (XExpression expr : operationArguments) {
                if (expr == leftOperand) {
                    argumentValues.add(result);
                    continue;
                }
                argumentValues.add(this.internalEvaluate(expr, context, indicator));
            }
            return this.invokeOperation(operation, receiver, argumentValues, context, indicator);
        }
        XExpression receiver = this.getActualReceiver(featureCall);
        Object receiverObj = receiver == null ? null : this.internalEvaluate(receiver, context, indicator);
        return this.invokeFeature(featureCall.getFeature(), featureCall, receiverObj, context, indicator);
    }

    protected List<XExpression> getActualArguments(XAbstractFeatureCall featureCall) {
        return featureCall.getActualArguments();
    }

    protected XExpression getActualReceiver(XAbstractFeatureCall featureCall) {
        return featureCall.getActualReceiver();
    }

    protected Object invokeFeature(JvmIdentifiableElement feature, XAbstractFeatureCall featureCall, Object receiverObj, IEvaluationContext context, CancelIndicator indicator) {
        if (feature instanceof JvmField) {
            return this._invokeFeature((JvmField)feature, featureCall, receiverObj, context, indicator);
        }
        if (feature instanceof JvmOperation) {
            return this._invokeFeature((JvmOperation)feature, featureCall, receiverObj, context, indicator);
        }
        if (feature != null) {
            return this._invokeFeature(feature, featureCall, receiverObj, context, indicator);
        }
        throw new NullPointerException("Feature was null");
    }

    protected Object _invokeFeature(JvmIdentifiableElement identifiable, XAbstractFeatureCall featureCall, Object receiver, IEvaluationContext context, CancelIndicator indicator) {
        if (receiver != null) {
            throw new IllegalStateException("feature was simple feature call but got receiver instead of null. Receiver: " + receiver);
        }
        String localVarName = this.featureNameProvider.getSimpleName(identifiable);
        Object value = context.getValue(QualifiedName.create((String)localVarName));
        return value;
    }

    protected Object _invokeFeature(JvmField jvmField, XAbstractFeatureCall featureCall, Object receiver, IEvaluationContext context, CancelIndicator indicator) {
        return this.featureCallField(jvmField, receiver);
    }

    protected Object featureCallField(JvmField jvmField, Object receiver) {
        Field field = this.javaReflectAccess.getField(jvmField);
        try {
            if (field == null) {
                throw new NoSuchFieldException("Could not find field " + jvmField.getIdentifier());
            }
            if (!Modifier.isStatic(field.getModifiers()) && receiver == null) {
                throw new EvaluationException(new NullPointerException("cannot access field " + field + " on null"));
            }
            field.setAccessible(true);
            Object result = field.get(receiver);
            return result;
        }
        catch (EvaluationException ee) {
            throw ee;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not access field: " + jvmField.getIdentifier() + " on instance: " + receiver, e);
        }
    }

    protected Object _invokeFeature(JvmOperation operation, XAbstractFeatureCall featureCall, Object receiver, IEvaluationContext context, CancelIndicator indicator) {
        List<XExpression> operationArguments = this.getActualArguments(featureCall);
        List<Object> argumentValues = this.evaluateArgumentExpressions((JvmExecutable)operation, operationArguments, context, indicator);
        return this.invokeOperation(operation, receiver, argumentValues, context, indicator);
    }

    protected Object invokeOperation(JvmOperation operation, Object receiver, List<Object> argumentValues, IEvaluationContext context, CancelIndicator indicator) {
        return this.invokeOperation(operation, receiver, argumentValues);
    }

    protected Object invokeOperation(JvmOperation operation, Object receiver, List<Object> argumentValues) {
        Method method = this.javaReflectAccess.getMethod(operation);
        try {
            if (method == null) {
                throw new NoSuchMethodException("Could not find method " + operation.getIdentifier());
            }
            if (!Modifier.isStatic(method.getModifiers()) && receiver == null) {
                throw new EvaluationException(new NullPointerException("cannot invoke method " + method + " on null"));
            }
            if (Modifier.isStatic(method.getModifiers()) && receiver != null) {
                throw new IllegalArgumentException("A static method can't be invoked on a receiver.");
            }
            if (receiver != null && Proxy.isProxyClass(receiver.getClass())) {
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(receiver);
                try {
                    Object result = invocationHandler.invoke(receiver, method, argumentValues.toArray(new Object[argumentValues.size()]));
                    return result;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            method.setAccessible(true);
            Object result = method.invoke(receiver, argumentValues.toArray(new Object[argumentValues.size()]));
            return result;
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (InvocationTargetException targetException) {
            Throwable cause = targetException.getCause();
            if (cause instanceof InterpreterCanceledException) {
                throw (InterpreterCanceledException)cause;
            }
            if (cause instanceof UndeclaredThrowableException) {
                cause = cause.getCause();
            }
            if (cause instanceof EvaluationException) {
                throw (EvaluationException)cause;
            }
            throw new EvaluationException(cause);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not invoke method: " + operation.getIdentifier() + " on instance: " + receiver, e);
        }
    }

    protected List<Object> evaluateArgumentExpressions(JvmExecutable executable, List<XExpression> expressions, IEvaluationContext context, CancelIndicator indicator) {
        XExpression arg;
        ArrayList result = Lists.newArrayList();
        int paramCount = executable.getParameters().size();
        if (executable.isVarArgs()) {
            --paramCount;
        }
        int i = 0;
        while (i < paramCount) {
            arg = expressions.get(i);
            Object argResult = this.internalEvaluate(arg, context, indicator);
            JvmTypeReference parameterType = ((JvmFormalParameter)executable.getParameters().get(i)).getParameterType();
            Object argumentValue = this.coerceArgumentType(argResult, parameterType);
            result.add(argumentValue);
            ++i;
        }
        if (executable.isVarArgs()) {
            Class<?> componentType = null;
            if (executable instanceof JvmOperation) {
                Method method = this.javaReflectAccess.getMethod((JvmOperation)executable);
                componentType = method.getParameterTypes()[paramCount].getComponentType();
            } else {
                Constructor constructor = this.javaReflectAccess.getConstructor((JvmConstructor)executable);
                componentType = constructor.getParameterTypes()[paramCount].getComponentType();
            }
            if (expressions.size() == executable.getParameters().size()) {
                arg = expressions.get(paramCount);
                Object lastArgResult = this.internalEvaluate(arg, context, indicator);
                if (componentType.isInstance(lastArgResult)) {
                    Object array = Array.newInstance(componentType, 1);
                    Array.set(array, 0, lastArgResult);
                    result.add(array);
                } else {
                    result.add(lastArgResult);
                }
            } else {
                Object array = Array.newInstance(componentType, expressions.size() - paramCount);
                int i2 = paramCount;
                while (i2 < expressions.size()) {
                    XExpression arg2 = expressions.get(i2);
                    Object argValue = this.internalEvaluate(arg2, context, indicator);
                    Array.set(array, i2 - paramCount, argValue);
                    ++i2;
                }
                result.add(array);
            }
        }
        return result;
    }

    protected Object coerceArgumentType(Object value, JvmTypeReference expectedType) {
        if (value == null) {
            return null;
        }
        if (expectedType.getType() instanceof JvmGenericType && ((JvmGenericType)expectedType.getType()).isInterface()) {
            try {
                JvmType type = expectedType.getType();
                Class functionIntf = this.classFinder.forName(type.getIdentifier());
                if (!functionIntf.isInstance(value)) {
                    InvocationHandler invocationHandler = null;
                    if (Proxy.isProxyClass(value.getClass())) {
                        invocationHandler = Proxy.getInvocationHandler(value);
                    } else if (this.getClass(Functions.Function0.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Functions.Function0.class));
                    } else if (this.getClass(Functions.Function1.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Functions.Function1.class));
                    } else if (this.getClass(Functions.Function2.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Functions.Function2.class));
                    } else if (this.getClass(Functions.Function3.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Functions.Function3.class));
                    } else if (this.getClass(Functions.Function4.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Functions.Function4.class));
                    } else if (this.getClass(Functions.Function5.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Functions.Function5.class));
                    } else if (this.getClass(Functions.Function6.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Functions.Function6.class));
                    } else if (this.getClass(Procedures.Procedure0.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Procedures.Procedure0.class));
                    } else if (this.getClass(Procedures.Procedure1.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Procedures.Procedure1.class));
                    } else if (this.getClass(Procedures.Procedure2.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Procedures.Procedure2.class));
                    } else if (this.getClass(Procedures.Procedure3.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Procedures.Procedure3.class));
                    } else if (this.getClass(Procedures.Procedure4.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Procedures.Procedure4.class));
                    } else if (this.getClass(Procedures.Procedure5.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Procedures.Procedure5.class));
                    } else if (this.getClass(Procedures.Procedure6.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Procedures.Procedure6.class));
                    } else {
                        return value;
                    }
                    Object proxy = Proxy.newProxyInstance(this.classLoader, new Class[]{functionIntf}, invocationHandler);
                    return proxy;
                }
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
        }
        return value;
    }

    protected Object _doEvaluate(XAssignment assignment, IEvaluationContext context, CancelIndicator indicator) {
        Object value = this.internalEvaluate(assignment.getValue(), context, indicator);
        Object assign = this.assignValueTo(assignment.getFeature(), assignment, value, context, indicator);
        return assign;
    }

    protected Object assignValueTo(JvmIdentifiableElement feature, XAssignment assignment, Object value, IEvaluationContext context, CancelIndicator indicator) {
        if (feature instanceof XVariableDeclaration) {
            return this._assigneValueTo((XVariableDeclaration)feature, assignment, value, context, indicator);
        }
        if (feature instanceof JvmField) {
            return this._assigneValueTo((JvmField)feature, assignment, value, context, indicator);
        }
        if (feature instanceof JvmOperation) {
            return this._assigneValueTo((JvmOperation)feature, assignment, value, context, indicator);
        }
        throw new IllegalArgumentException("Couldn't invoke 'assignValueTo' for feature " + feature);
    }

    protected Object _assigneValueTo(XVariableDeclaration variable, XAssignment assignment, Object value, IEvaluationContext context, CancelIndicator indicator) {
        if (variable.getType() != null) {
            JvmTypeReference type = variable.getType();
            Object coerced = this.coerceArgumentType(value, type);
            context.assignValue(QualifiedName.create((String)variable.getName()), coerced);
        } else {
            context.assignValue(QualifiedName.create((String)variable.getName()), value);
        }
        return value;
    }

    protected Object _assigneValueTo(JvmField jvmField, XAssignment assignment, Object value, IEvaluationContext context, CancelIndicator indicator) {
        Object receiver = this.getReceiver(assignment, context, indicator);
        if (receiver == null) {
            throw new EvaluationException(new NullPointerException("Cannot assign value to field: " + jvmField.getIdentifier() + " on null instance"));
        }
        JvmTypeReference type = jvmField.getType();
        Object coerced = this.coerceArgumentType(value, type);
        Field field = this.javaReflectAccess.getField(jvmField);
        try {
            if (field == null) {
                throw new NoSuchFieldException("Could not find field " + jvmField.getIdentifier());
            }
            field.setAccessible(true);
            field.set(receiver, coerced);
            return value;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not access field: " + jvmField.getIdentifier() + " on instance: " + receiver, e);
        }
    }

    protected Object getReceiver(XAssignment assignment, IEvaluationContext context, CancelIndicator indicator) {
        XExpression receiver = this.getActualReceiver(assignment);
        Object result = receiver == null ? null : this.internalEvaluate(receiver, context, indicator);
        return result;
    }

    protected Object _assigneValueTo(JvmOperation jvmOperation, XAssignment assignment, Object value, IEvaluationContext context, CancelIndicator indicator) {
        ArrayList argumentValues;
        if (assignment.getImplicitReceiver() != null && assignment.getAssignable() != null) {
            XExpression implicitArgument = assignment.getAssignable();
            Object argResult = this.internalEvaluate(implicitArgument, context, indicator);
            JvmTypeReference firstParameterType = ((JvmFormalParameter)jvmOperation.getParameters().get(0)).getParameterType();
            Object firstValue = this.coerceArgumentType(argResult, firstParameterType);
            JvmTypeReference secondParameterType = ((JvmFormalParameter)jvmOperation.getParameters().get(1)).getParameterType();
            Object secondValue = this.coerceArgumentType(value, secondParameterType);
            argumentValues = Lists.newArrayList((Object[])new Object[]{firstValue, secondValue});
        } else {
            JvmTypeReference secondParameterType = ((JvmFormalParameter)jvmOperation.getParameters().get(0)).getParameterType();
            Object coerced = this.coerceArgumentType(value, secondParameterType);
            argumentValues = Lists.newArrayList((Object[])new Object[]{coerced});
        }
        Object receiver = this.getReceiver(assignment, context, indicator);
        Object result = this.invokeOperation(jvmOperation, receiver, argumentValues, context, indicator);
        return result;
    }

    protected ClassFinder getClassFinder() {
        return this.classFinder;
    }

    protected JavaReflectAccess getJavaReflectAccess() {
        return this.javaReflectAccess;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrefixMethodFilter
    extends PolymorphicDispatcher.MethodNameFilter {
        public PrefixMethodFilter(String prefix, int minParams, int maxParams) {
            super(prefix, minParams, maxParams);
        }

        public boolean apply(Method param) {
            return param.getName().startsWith(this.methodName) && param.getParameterTypes().length >= this.minParams && param.getParameterTypes().length <= this.maxParams;
        }
    }

    static class ReturnValue
    extends RuntimeException {
        public Object returnValue;

        public ReturnValue(Object value) {
            this.returnValue = value;
        }
    }
}

