/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.access.AbstractTypeProviderFactory;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.resource.XtextResourceSet;

public class ClasspathTypeProviderFactory
extends AbstractTypeProviderFactory {
    private final ClassLoader classLoader;

    @Inject
    public ClasspathTypeProviderFactory(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClasspathTypeProvider createTypeProvider(ResourceSet resourceSet) {
        if (resourceSet == null) {
            throw new IllegalArgumentException("resourceSet may not be null.");
        }
        ClasspathTypeProvider result = this.createClasspathTypeProvider(resourceSet);
        return result;
    }

    protected ClasspathTypeProvider createClasspathTypeProvider(ResourceSet resourceSet) {
        return new ClasspathTypeProvider(this.getClassLoader(resourceSet), resourceSet, this.getIndexedJvmTypeAccess());
    }

    public ClassLoader getClassLoader(ResourceSet resourceSet) {
        XtextResourceSet xtextResourceSet;
        Object ctx;
        if (resourceSet instanceof XtextResourceSet && (ctx = (xtextResourceSet = (XtextResourceSet)resourceSet).getClasspathURIContext()) != null) {
            if (ctx instanceof Class) {
                return ((Class)ctx).getClassLoader();
            }
            if (!(ctx instanceof ClassLoader)) {
                return ctx.getClass().getClassLoader();
            }
            return (ClassLoader)ctx;
        }
        return this.classLoader;
    }

    public ClasspathTypeProvider createTypeProvider() {
        return (ClasspathTypeProvider)super.createTypeProvider();
    }

    public ClasspathTypeProvider findTypeProvider(ResourceSet resourceSet) {
        return (ClasspathTypeProvider)super.findTypeProvider(resourceSet);
    }
}

