/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class SyncUtil {
    private static final Logger LOG = Logger.getLogger(SyncUtil.class);
    @Inject(optional=true)
    private IWorkbench workbench;
    @Inject(optional=true)
    private IWorkspace workspace;

    public void totalSync(final boolean saveAll, boolean useProgressDialog) throws InvocationTargetException, InterruptedException {
        if (Display.getCurrent() != null && this.workbench != null) {
            if (useProgressDialog) {
                this.workbench.getProgressService().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
                        SyncUtil.this.reconcileAllEditors(SyncUtil.this.workbench, saveAll, (IProgressMonitor)progress.newChild(1));
                        SyncUtil.this.waitForBuild((IProgressMonitor)progress.newChild(4));
                        SyncUtil.this.yieldToQueuedDisplayJobs((IProgressMonitor)progress.newChild(1));
                    }
                });
            } else {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)new NullProgressMonitor());
                this.reconcileAllEditors(this.workbench, saveAll, (IProgressMonitor)progress.newChild(1));
                this.waitForBuild((IProgressMonitor)progress.newChild(4));
                this.yieldToQueuedDisplayJobs((IProgressMonitor)progress.newChild(1));
            }
        }
    }

    public void totalSync(boolean saveAll) throws InvocationTargetException, InterruptedException {
        this.totalSync(saveAll, true);
    }

    @Deprecated
    public void syncAllEditors(IWorkbench workbench, boolean saveAll, IProgressMonitor monitor) {
        this.reconcileAllEditors(workbench, saveAll, monitor);
    }

    public void reconcileAllEditors(IWorkbench workbench, boolean saveAll, IProgressMonitor monitor) {
        SubMonitor pm0 = SubMonitor.convert((IProgressMonitor)monitor, (int)workbench.getWorkbenchWindowCount());
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            SubMonitor pm1 = pm0.newChild(1).setWorkRemaining(window.getPages().length);
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                SubMonitor pm2 = pm1.newChild(1).setWorkRemaining(2 * page.getEditorReferences().length);
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorReference = iEditorReferenceArray[n6];
                    if (pm2.isCanceled()) {
                        return;
                    }
                    IEditorPart editor = editorReference.getEditor(false);
                    if (editor != null) {
                        if (editor instanceof XtextEditor) {
                            this.waitForReconciler((XtextEditor)editor);
                        }
                        if (editor.isDirty() && saveAll) {
                            editor.doSave((IProgressMonitor)pm2.newChild(1));
                        }
                    }
                    pm2.worked(1);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void waitForReconciler(XtextEditor editor) {
        editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource state) throws Exception {
            }
        });
    }

    public void waitForBuild(IProgressMonitor monitor) {
        try {
            this.workspace.build(10, monitor);
        }
        catch (CoreException e) {
            throw new OperationCanceledException(e.getMessage());
        }
    }

    @Deprecated
    public void waitForAutoBuild(IProgressMonitor monitor) {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public void yieldToQueuedDisplayJobs(IProgressMonitor monitor) {
        this.yieldToQueuedDisplayJobs(monitor, 5000);
    }

    public void yieldToQueuedDisplayJobs(IProgressMonitor monitor, int maxJobsToYieldTo) {
        SubMonitor pm = SubMonitor.convert((IProgressMonitor)monitor, (int)maxJobsToYieldTo);
        int count = 0;
        if (Display.getCurrent() != null) {
            while (count < maxJobsToYieldTo && Display.getCurrent().readAndDispatch()) {
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++count;
                pm.worked(1);
            }
            if (count == maxJobsToYieldTo) {
                LOG.error((Object)("maxJobsToYieldTo probably exceeded. Worked: " + count));
            }
        }
    }
}

