/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.validation;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.validation.ConfigurableIssueCodesProvider;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.validation.IssueSeveritiesProvider;
import org.eclipse.xtext.validation.SeverityConverter;
import org.eclipse.xtext.xbase.validation.XbaseSeverityConverter;

public class XbaseIssueSeveritiesProvider
extends IssueSeveritiesProvider {
    @Inject
    private IJavaProjectProvider projectProvider;
    @Inject
    private ConfigurableIssueCodesProvider configurableIssueCodes;

    public IssueSeverities getIssueSeverities(Resource context) {
        IPreferenceValues preferenceValues = this.getValuesProvider().getPreferenceValues(context);
        return new IssueSeverities(preferenceValues, this.configurableIssueCodes.getConfigurableIssueCodes(), (SeverityConverter)new XbaseSeverityConverter(context){
            final IJavaProject project;
            {
                this.project = XbaseIssueSeveritiesProvider.this.projectProvider.getJavaProject(resource.getResourceSet());
            }

            protected String delegatedValue(Pair<String, String> pair) {
                String jdtSeverity = this.jdtSeverity(this.project, (String)pair.getFirst());
                if (jdtSeverity == null || "".equals(jdtSeverity)) {
                    return super.delegatedValue(pair);
                }
                return jdtSeverity;
            }

            private String jdtSeverity(IJavaProject project, String severityAsString) {
                if (project == null) {
                    return null;
                }
                return project.getOption(severityAsString, true);
            }
        });
    }
}

