/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.xtext.common.types.access.impl.ClassNameUtil;
import org.eclipse.xtext.common.types.access.impl.Primitives;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFinder {
    private static final Class<?> NULL_CLASS;
    private static final ClassNotFoundException CACHED_EXCEPTION;
    private final ClassLoader classLoader;
    private final ClassNameUtil classNameUtil;
    private Map<String, Class<?>> cache = Maps.newHashMapWithExpectedSize((int)500);

    static {
        class Null {
            Null() {
            }
        }
        NULL_CLASS = Null.class;
        CACHED_EXCEPTION = new ClassNotFoundException();
    }

    public ClassFinder(ClassLoader classLoader) {
        for (Class<?> primitiveType : Primitives.ALL_PRIMITIVE_TYPES) {
            this.cache.put(primitiveType.getName(), primitiveType);
        }
        this.classLoader = classLoader;
        this.classNameUtil = new ClassNameUtil();
    }

    public Class<?> forName(String name) throws ClassNotFoundException {
        Class<?> result = this.cache.get(name);
        if (result != null) {
            if (result == NULL_CLASS) {
                throw CACHED_EXCEPTION;
            }
            return result;
        }
        try {
            result = Class.forName(this.classNameUtil.normalizeClassName(name), false, this.classLoader);
            this.cache.put(name, result);
            return result;
        }
        catch (ClassNotFoundException e) {
            this.cache.put(name, NULL_CLASS);
            throw e;
        }
    }
}

