/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.imports;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.label.AbstractLabelProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.imports.TypeUsage;
import org.eclipse.xtext.xbase.ui.imports.Messages;

public class TypeChooser {
    @Inject
    private ILabelProvider labelProvider;
    private ISelection originalSelection;

    public JvmDeclaredType choose(List<JvmDeclaredType> candidateTypes, Iterable<TypeUsage> usages, XtextResource resource) {
        XtextEditor activeXtextEditor = EditorUtils.getActiveXtextEditor();
        this.revealInEditor(activeXtextEditor, usages, resource);
        Shell shell = Display.getDefault().getActiveShell();
        ContentProvider contentProvider = new ContentProvider();
        Dialog dialog = new Dialog(shell, (ILabelProvider)new LabelProvider(this.labelProvider), contentProvider);
        dialog.setInput(candidateTypes);
        dialog.setInitialSelections(new JvmDeclaredType[]{candidateTypes.get(0)});
        int result = dialog.open();
        if (this.originalSelection != null) {
            activeXtextEditor.getSelectionProvider().setSelection(this.originalSelection);
        }
        if (result == 0) {
            return (JvmDeclaredType)dialog.getResult()[0];
        }
        return null;
    }

    protected void revealInEditor(XtextEditor activeXtextEditor, Iterable<TypeUsage> usages, final XtextResource resource) {
        boolean isRevealUsages = (Boolean)activeXtextEditor.getDocument().priorityReadOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

            public Boolean exec(XtextResource state) throws Exception {
                return state.getURI().equals(resource.getURI());
            }
        });
        if (isRevealUsages) {
            this.originalSelection = activeXtextEditor.getSelectionProvider().getSelection();
            ITextRegion firstOccurrence = usages.iterator().next().getTextRegion();
            activeXtextEditor.selectAndReveal(firstOccurrence.getOffset(), firstOccurrence.getLength());
        }
    }

    protected static class ContentProvider
    implements IStructuredContentProvider {
        protected ContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return Iterables.toArray((Iterable)((List)inputElement), JvmDeclaredType.class);
        }
    }

    protected static class Dialog
    extends ListDialog {
        protected Text searchControl;

        public Dialog(Shell parent, ILabelProvider labelProvider, IStructuredContentProvider contentProvider) {
            super(parent);
            this.setTitle(Messages.OrganizeImports);
            this.setMessage(Messages.TypeChooser_dialogTitle);
            this.setAddCancelButton(true);
            this.setContentProvider(contentProvider);
            this.setLabelProvider(labelProvider);
        }

        protected Label createMessageArea(Composite composite) {
            Label label = super.createMessageArea(composite);
            this.searchControl = new Text(composite, 2432);
            this.setDefaultGridData((Control)this.searchControl);
            ModifyListener textModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Dialog.this.applyFilter();
                }
            };
            this.searchControl.addModifyListener(textModifyListener);
            this.searchControl.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x1000002) {
                        Object firstElement;
                        TableViewer tableViewer = Dialog.this.getTableViewer();
                        tableViewer.getTable().setFocus();
                        if (tableViewer.getSelection().isEmpty() && (firstElement = tableViewer.getElementAt(0)) != null) {
                            tableViewer.setSelection((ISelection)new StructuredSelection(firstElement));
                        }
                    }
                }
            });
            return label;
        }

        private void setDefaultGridData(Control control) {
            control.setLayoutData((Object)new GridData(768));
        }

        protected void applyFilter() {
            String searchPattern = this.searchControl.getText();
            if (searchPattern != null) {
                this.getTableViewer().resetFilters();
                this.getTableViewer().addFilter((ViewerFilter)new Filter(searchPattern));
            }
        }
    }

    protected static class Filter
    extends ViewerFilter {
        private SearchPattern searchPattern = new SearchPattern();

        public Filter(String pattern) {
            this.searchPattern.setPattern(pattern);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.searchPattern.matches(((JvmDeclaredType)element).getIdentifier());
        }
    }

    protected static class LabelProvider
    extends AbstractLabelProvider {
        public LabelProvider(ILabelProvider delegate) {
            super(delegate);
        }

        protected String doGetText(Object element) {
            return ((JvmDeclaredType)element).getIdentifier();
        }
    }
}

