/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.richstring;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xtend2.richstring.TextLine;
import org.eclipse.xtext.xtend2.richstring.TextLines;
import org.eclipse.xtext.xtend2.xtend2.RichString;
import org.eclipse.xtext.xtend2.xtend2.RichStringLiteral;
import org.eclipse.xtext.xtend2.xtend2.util.Xtend2Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialTemplateIndentationComputer
extends Xtend2Switch<String> {
    private final String initial;

    public InitialTemplateIndentationComputer(CharSequence initial) {
        if (initial == null) {
            throw new IllegalArgumentException("Initial indentation must not be null.");
        }
        this.initial = initial.toString();
    }

    @Override
    public String caseRichString(RichString object) {
        String result = null;
        EList elements = object.getExpressions();
        int i = 0;
        while (i < elements.size()) {
            XExpression element = (XExpression)elements.get(i);
            String elementResult = (String)this.doSwitch((EObject)element);
            if (elementResult == null && i == 0) {
                return this.initial;
            }
            if (Strings.isEmpty((String)(result = this.getBetterString(result, elementResult)))) {
                return result;
            }
            ++i;
        }
        return result;
    }

    protected String getBetterString(String current, String candidate) {
        if (candidate == null) {
            return current;
        }
        if (candidate.length() == 0) {
            return candidate;
        }
        if (current == null || current.length() > candidate.length()) {
            current = candidate;
        }
        return current;
    }

    @Override
    public String caseRichStringLiteral(RichStringLiteral object) {
        String value = object.getValue();
        List<TextLine> lines = TextLines.splitString(value);
        if (lines.size() <= 1) {
            return null;
        }
        TextLine firstLine = lines.get(0);
        if (!firstLine.containsOnlyWhitespace()) {
            return null;
        }
        String result = null;
        boolean emptyLineSeen = false;
        int i = 1;
        while (i < lines.size()) {
            TextLine line = lines.get(i);
            CharSequence leadingWS = line.getLeadingWhiteSpace();
            if (leadingWS.length() != line.length()) {
                if (leadingWS.length() == 0) {
                    return "";
                }
                result = this.getBetterString(result, leadingWS.toString());
            } else {
                RichString completeString = (RichString)object.eContainer();
                EList siblings = completeString.getExpressions();
                if (siblings.get(siblings.size() - 1) != object) {
                    if (leadingWS.length() == 0) {
                        emptyLineSeen = true;
                    } else {
                        result = this.getBetterString(result, leadingWS.toString());
                    }
                }
            }
            ++i;
        }
        if (emptyLineSeen && result == null) {
            return "";
        }
        return result;
    }
}

